/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public class UserNameCredentialsDialog
extends DialogWrapper
implements DocumentListener {
    private boolean myAllowSave;
    private String myUserName;
    private String myRealm;
    private JTextField myUserNameText;
    private JCheckBox myAllowSaveCheckBox;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.authentication";

    protected UserNameCredentialsDialog(Project project) {
        super(project, true);
        this.setResizable(false);
    }

    public void setup(String realm, String userName, boolean allowSave) {
        this.myRealm = realm;
        this.myUserName = userName;
        this.myAllowSave = allowSave;
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/UserNameCredentialsDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(2, 2, 2, 2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel label = new JLabel(SvnBundle.message("label.auth.authentication.realm", this.myRealm));
        panel.add((Component)label, gb);
        ++gb.gridy;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        label = new JLabel(SvnBundle.message("label.auth.user.name", new Object[0]));
        panel.add((Component)label, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myUserNameText = new JTextField();
        panel.add((Component)this.myUserNameText, gb);
        label.setLabelFor(this.myUserNameText);
        if (this.myUserName != null) {
            this.myUserNameText.setText(this.myUserName);
        }
        this.myUserNameText.selectAll();
        this.myUserNameText.getDocument().addDocumentListener(this);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myAllowSaveCheckBox = new JCheckBox(SvnBundle.message("checkbox.auth.keep.for.current.session", new Object[0]));
        panel.add((Component)this.myAllowSaveCheckBox, gb);
        ++gb.gridy;
        if (!this.myAllowSave) {
            JLabel cannotSaveLabel = new JLabel(SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]));
            cannotSaveLabel.setForeground(UIUtil.getInactiveTextColor());
            panel.add((Component)cannotSaveLabel, gb);
            ++gb.gridy;
        }
        panel.add((Component)new JSeparator(), gb);
        this.myAllowSaveCheckBox.setSelected(false);
        this.myAllowSaveCheckBox.setEnabled(this.myAllowSave);
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "svn.userNameDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserNameText;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        return this.myUserNameText != null && this.myUserNameText.getText().trim().length() != 0;
    }

    public String getUserName() {
        return this.isOK() && this.myUserNameText != null ? this.myUserNameText.getText() : null;
    }

    public boolean isSaveAllowed() {
        return this.isOK() && this.myAllowSave && this.myAllowSaveCheckBox != null && this.myAllowSaveCheckBox.isSelected();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }
}

