/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.CommonBundle;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;

public class SvnRepositoryTreeCellRenderer
extends ColoredTreeCellRenderer {
    private boolean myIsShowDetails;

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setIcon(null);
        if (value instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)value;
            if (node.getSVNDirEntry() == null) {
                this.append(node.getURL().toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                String name = node.getSVNDirEntry().getName();
                this.append(name, node.isCached() ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (this.myIsShowDetails) {
                    SVNDirEntry entry = node.getSVNDirEntry();
                    this.append(" " + entry.getRevision(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    if (entry.getAuthor() != null) {
                        this.append(" " + entry.getAuthor(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                    }
                    if (entry.getDate() != null) {
                        this.append(" " + DateFormatUtil.formatPrettyDateTime((Date)entry.getDate()), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
                if (node.getSVNDirEntry().getKind() == SVNNodeKind.FILE) {
                    this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(name).getIcon());
                } else {
                    this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
                }
            }
        } else if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof String) {
                this.append(CommonBundle.getLoadingTreeNodeText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (node.getUserObject() instanceof SVNErrorMessage) {
                this.append(node.getUserObject().toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }

    public void setShowDetails(boolean state) {
        this.myIsShowDetails = state;
    }
}

