/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.WaitForProgressToShow;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.TrileadAgentProxy;
import com.trilead.ssh2.auth.AgentProxy;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.ProviderType;
import org.jetbrains.idea.svn.dialogs.SSHCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.SSLCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.ServerSSHDialog;
import org.jetbrains.idea.svn.dialogs.ServerSSLDialog;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.UserNameCredentialsDialog;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;

public class SvnInteractiveAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider");
    private final Project myProject;
    private static final ThreadLocal<MyCallState> myCallState = new ThreadLocal();
    private final SvnAuthenticationManager myManager;

    public SvnInteractiveAuthenticationProvider(SvnVcs vcs, SvnAuthenticationManager manager) {
        this.myManager = manager;
        this.myProject = vcs.getProject();
    }

    public static void clearCallState() {
        myCallState.set(null);
    }

    public static boolean wasCalled() {
        return myCallState.get() != null && myCallState.get().isWasCalled();
    }

    public static boolean wasCancelled() {
        return myCallState.get() != null && myCallState.get().isWasCancelled();
    }

    public SVNAuthentication requestClientAuthentication(String kind, final SVNURL url, final String realm, final SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        String userName;
        MyCallState callState = new MyCallState(true, false);
        myCallState.set(callState);
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        configuration.clearCredentials(kind, realm);
        final SVNAuthentication[] result = new SVNAuthentication[1];
        Runnable command = null;
        final boolean authCredsOn = authMayBeStored && this.myManager.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled();
        String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : this.myManager.getDefaultUsername(kind, url);
        if ("svn.simple".equals(kind)) {
            command = new Runnable(){

                @Override
                public void run() {
                    SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject);
                    dialog.setup(realm, userName, authCredsOn);
                    SvnInteractiveAuthenticationProvider.setTitle(dialog, errorMessage);
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNPasswordAuthentication(dialog.getUserName(), dialog.getPassword(), dialog.isSaveAllowed(), url, false);
                    }
                }
            };
        } else if ("svn.username".equals(kind)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return new SVNUserNameAuthentication(userName, false);
            }
            command = new Runnable(){

                @Override
                public void run() {
                    UserNameCredentialsDialog dialog = new UserNameCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject);
                    dialog.setup(realm, userName, authCredsOn);
                    SvnInteractiveAuthenticationProvider.setTitle(dialog, errorMessage);
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNUserNameAuthentication(dialog.getUserName(), dialog.isSaveAllowed(), url, false);
                    }
                }
            };
        } else if ("svn.ssh".equals(kind)) {
            final Connector agentConnector = SvnInteractiveAuthenticationProvider.createSshAgentConnector();
            final boolean isAgentAvailable = agentConnector != null && agentConnector.isAvailable();
            command = new Runnable(){

                @Override
                public void run() {
                    SSHCredentialsDialog dialog = new SSHCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject, realm, userName, authCredsOn, url.getPort(), isAgentAvailable);
                    SvnInteractiveAuthenticationProvider.setTitle(dialog, errorMessage);
                    dialog.show();
                    if (dialog.isOK()) {
                        int port = dialog.getPortNumber();
                        if (dialog.isSshAgentSelected()) {
                            if (agentConnector != null) {
                                result[0] = new SVNSSHAuthentication(dialog.getUserName(), (AgentProxy)new TrileadAgentProxy(agentConnector), port, url, false);
                            }
                        } else if (dialog.getKeyFile() != null && dialog.getKeyFile().trim().length() > 0) {
                            String passphrase = dialog.getPassphrase();
                            if (passphrase != null && passphrase.length() == 0) {
                                passphrase = null;
                            }
                            result[0] = new SVNSSHAuthentication(dialog.getUserName(), new File(dialog.getKeyFile()), passphrase, port, dialog.isSaveAllowed(), url, false);
                        } else {
                            result[0] = new SVNSSHAuthentication(dialog.getUserName(), dialog.getPassword(), port, dialog.isSaveAllowed(), url, false);
                        }
                    }
                }
            };
        } else if ("svn.ssl.client-passphrase".equals(kind)) {
            command = new Runnable(){

                @Override
                public void run() {
                    ISVNHostOptions options = SvnInteractiveAuthenticationProvider.this.myManager.getHostOptionsProvider().getHostOptions(url);
                    String file = options.getSSLClientCertFile();
                    SSLCredentialsDialog dialog = new SSLCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject, realm, authCredsOn);
                    if (!StringUtil.isEmptyOrSpaces((String)file)) {
                        dialog.setFile(file);
                    }
                    SvnInteractiveAuthenticationProvider.setTitle(dialog, errorMessage);
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNSSLAuthentication(new File(dialog.getCertificatePath()), String.valueOf(dialog.getCertificatePassword()), dialog.getSaveAuth(), url, false);
                    }
                }
            };
        }
        if (command != null) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command);
            this.log("3 authentication result: " + result[0]);
        }
        boolean wasCanceled = result[0] == null;
        callState.setWasCancelled(wasCanceled);
        this.myManager.requested(ProviderType.interactive, url, realm, kind, wasCanceled);
        return result[0];
    }

    @Nullable
    private static Connector createSshAgentConnector() {
        Connector result = null;
        try {
            result = ConnectorFactory.getDefault().createConnector();
        }
        catch (AgentProxyException e) {
            LOG.info("Could not create ssh agent connector", (Throwable)e);
        }
        return result;
    }

    private static void setTitle(@NotNull DialogWrapper dialog, @Nullable SVNErrorMessage errorMessage) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/SvnInteractiveAuthenticationProvider", "setTitle"));
        }
        dialog.setTitle(errorMessage == null ? SvnBundle.message("dialog.title.authentication.required", new Object[0]) : SvnBundle.message("dialog.title.authentication.required.was.failed", new Object[0]));
    }

    public int acceptServerAuthentication(final SVNURL url, String realm, final Object certificate, final boolean resultMayBeStored) {
        Runnable command;
        final int[] result = new int[1];
        if (certificate instanceof X509Certificate) {
            command = new Runnable(){

                @Override
                public void run() {
                    ServerSSLDialog dialog = new ServerSSLDialog(SvnInteractiveAuthenticationProvider.this.myProject, (X509Certificate)certificate, resultMayBeStored);
                    dialog.show();
                    result[0] = dialog.getResult();
                }
            };
        } else if (certificate instanceof byte[]) {
            final String sshKeyAlgorithm = this.myManager.getSSHKeyAlgorithm();
            command = new Runnable(){

                @Override
                public void run() {
                    ServerSSHDialog serverSSHDialog = new ServerSSHDialog(SvnInteractiveAuthenticationProvider.this.myProject, resultMayBeStored, url.toDecodedString(), sshKeyAlgorithm, (byte[])certificate);
                    serverSSHDialog.show();
                    result[0] = serverSSHDialog.getResult();
                }
            };
        } else {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Subversion: unknown certificate type from " + url.toDecodedString()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return 0;
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)pi.getModalityState());
        } else {
            try {
                SwingUtilities.invokeAndWait(command);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return result[0];
    }

    private void log(String s) {
        LOG.debug(s);
    }

    public static class MyCallState {
        private final boolean myWasCalled;
        private boolean myWasCancelled;

        public MyCallState(boolean wasCalled, boolean wasCancelled) {
            this.myWasCalled = wasCalled;
            this.myWasCancelled = wasCancelled;
        }

        public boolean isWasCalled() {
            return this.myWasCalled;
        }

        public boolean isWasCancelled() {
            return this.myWasCancelled;
        }

        public void setWasCancelled(boolean wasCancelled) {
            this.myWasCancelled = wasCancelled;
        }
    }
}

