/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.idea.svn.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;

public class SvnAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.SvnAuthenticationProvider");
    private final Project myProject;
    private final SvnAuthenticationNotifier myAuthenticationNotifier;
    private final ISVNAuthenticationProvider mySvnInteractiveAuthenticationProvider;
    private final ISVNAuthenticationStorage myAuthenticationStorage;
    private static final Set<Thread> ourForceInteractive = new HashSet<Thread>();

    public SvnAuthenticationProvider(SvnVcs svnVcs, ISVNAuthenticationProvider provider, ISVNAuthenticationStorage authenticationStorage) {
        this.myAuthenticationStorage = authenticationStorage;
        this.myProject = svnVcs.getProject();
        this.myAuthenticationNotifier = svnVcs.getAuthNotifier();
        this.mySvnInteractiveAuthenticationProvider = provider;
    }

    private void log(String s) {
        LOG.debug(s);
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if (ApplicationManager.getApplication().isUnitTestMode() && "svn.username".equals(kind)) {
            String userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : SystemProperties.getUserName();
            return new SVNUserNameAuthentication(userName, false);
        }
        SvnAuthenticationNotifier.AuthenticationRequest obj = new SvnAuthenticationNotifier.AuthenticationRequest(this.myProject, kind, url, realm);
        SVNURL wcUrl = this.myAuthenticationNotifier.getWcUrl(obj);
        if (wcUrl == null || ourForceInteractive.contains(Thread.currentThread())) {
            return this.mySvnInteractiveAuthenticationProvider.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
        }
        if (this.myAuthenticationNotifier.ensureNotify(obj)) {
            return (SVNAuthentication)this.myAuthenticationStorage.getData(kind, realm);
        }
        return null;
    }

    public static void forceInteractive() {
        ourForceInteractive.add(Thread.currentThread());
    }

    public static void clearInteractive() {
        ourForceInteractive.remove(Thread.currentThread());
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        return this.mySvnInteractiveAuthenticationProvider.acceptServerAuthentication(url, realm, certificate, resultMayBeStored);
    }
}

