/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.util.IconUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.AddRepositoryLocationDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeRootNode;
import org.jetbrains.idea.svn.dialogs.SvnRepositoryTreeCellRenderer;
import org.jetbrains.idea.svn.dialogs.browser.CheckoutOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.CopyOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.DeleteOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.DiffOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.ExportOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.ImportOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.MkdirOptionsDialog;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingExpandedExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.SyntheticWorker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.status.SvnDiffEditor;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class RepositoryBrowserDialog
extends DialogWrapper {
    private final Project myProject;
    protected final SvnVcs myVCS;
    private RepositoryBrowserComponent myRepositoryBrowser;
    @NonNls
    public static final String COPY_OF_PREFIX = "CopyOf";
    @NonNls
    public static final String NEW_FOLDER_POSTFIX = "NewFolder";
    private final DeleteAction myDeleteAction;
    private AnAction copyUrlAction;
    private AnAction mkDirAction;
    private final boolean myShowFiles;
    @NonNls
    private static final String PLACE_TOOLBAR = "RepositoryBrowser.Toolbar";
    @NonNls
    private static final String PLACE_MENU = "RepositoryBrowser.Menu";
    private final String myRepositoriesLabelText;
    protected JLabel myRepositoriesLabel;

    public RepositoryBrowserDialog(Project project) {
        this(project, true, null);
    }

    public RepositoryBrowserDialog(Project project, boolean showFiles, @Nullable String repositoriesLabelText) {
        super(project, true);
        this.myRepositoriesLabelText = repositoriesLabelText == null ? "Repositories:" : repositoriesLabelText;
        this.myShowFiles = showFiles;
        this.myProject = project;
        this.myVCS = SvnVcs.getInstance(project);
        this.setTitle("SVN Repository Browser");
        this.setResizable(true);
        this.setOKButtonText(CommonBundle.getCloseButtonText());
        this.getHelpAction().setEnabled(true);
        Disposer.register((Disposable)project, (Disposable)this.getDisposable());
        this.myDeleteAction = new DeleteAction(this.getRepositoryBrowser());
        this.init();
    }

    protected String getHelpId() {
        return "reference.svn.repository";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return "svn.repositoryBrowser";
    }

    protected boolean showImportAction() {
        return true;
    }

    public JComponent createToolbar(boolean horizontal, AnAction ... additionalActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        final RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        group.add((AnAction)new AddLocationAction(browser));
        group.add((AnAction)new EditLocationAction());
        group.add((AnAction)new DiscardLocationAction(browser));
        group.add((AnAction)new DetailsAction());
        group.addSeparator();
        RefreshAction refreshAction = new RefreshAction(browser);
        refreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), browser);
        group.add((AnAction)refreshAction);
        this.copyUrlAction = new CopyUrlAction();
        this.copyUrlAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 650)), (JComponent)browser);
        this.mkDirAction = new MkDirAction(browser);
        this.mkDirAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(155, 520)), (JComponent)browser);
        AnAction action = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public void expandAll() {
            }

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                JTree tree = browser.getRepositoryTree();
                for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                    tree.collapseRow(row);
                }
            }

            public boolean canCollapse() {
                return true;
            }
        }, (JComponent)browser);
        group.add(action);
        if (additionalActions != null || !horizontal) {
            group.addSeparator();
        }
        if (additionalActions != null) {
            for (AnAction anAction : additionalActions) {
                group.add(anAction);
            }
        }
        if (!horizontal) {
            group.add((AnAction)new CloseToolWindowAction());
        }
        return ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)group, horizontal).getComponent();
    }

    protected JPopupMenu createPopup(boolean toolWindow) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = new DefaultActionGroup("_New", true);
        RepositoryBrowserComponent browser = this.getRepositoryBrowser();
        newGroup.add((AnAction)new AddLocationAction(browser));
        newGroup.add((AnAction)new MkDirAction(browser));
        group.add((AnAction)newGroup);
        group.addSeparator();
        if (toolWindow) {
            group.add((AnAction)new OpenAction());
            group.add((AnAction)new HistoryAction());
        }
        group.add((AnAction)new CheckoutAction());
        group.add((AnAction)new DiffAction());
        group.add((AnAction)new BrowseChangesAction());
        group.addSeparator();
        group.add((AnAction)new ImportAction());
        group.add((AnAction)new ExportAction());
        group.addSeparator();
        group.add((AnAction)new CopyOrMoveAction("Branch or Tag...", "copy.dialog.title", false));
        group.add((AnAction)new CopyOrMoveAction("_Move or Rename...", "move.dialog.title", true));
        group.add((AnAction)this.myDeleteAction);
        group.add(this.copyUrlAction);
        group.addSeparator();
        group.add((AnAction)new RefreshAction(browser));
        group.add((AnAction)new EditLocationAction());
        group.add((AnAction)new DiscardLocationAction(browser));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(PLACE_MENU, (ActionGroup)group);
        return menu.getComponent();
    }

    public JComponent createCenterPanel() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JPanel top = new JPanel();
        BoxLayout layout = new BoxLayout(top, 0);
        top.setLayout(layout);
        this.myRepositoriesLabel = new JLabel(this.myRepositoriesLabelText);
        top.add(this.myRepositoriesLabel);
        top.add(this.createToolbar(true, null));
        parentPanel.add((Component)top, "North");
        JComponent panel = this.createBrowserComponent(false);
        parentPanel.add((Component)panel, "Center");
        return parentPanel;
    }

    public JComponent createBrowserComponent(final boolean toolWindow) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridwidth = 2;
        ++gc.gridy;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 17;
        panel.add((Component)this.getRepositoryBrowser(), gc);
        ++gc.gridy;
        gc.weighty = 0.0;
        gc.fill = 2;
        panel.add((Component)new JLabel(), gc);
        Collection<String> urls = SvnApplicationSettings.getInstance().getCheckoutURLs();
        ArrayList<SVNURL> svnURLs = new ArrayList<SVNURL>();
        for (String url : urls) {
            try {
                svnURLs.add(SVNURL.parseURIEncoded((String)url));
            }
            catch (SVNException e) {}
        }
        this.getRepositoryBrowser().setRepositoryURLs(svnURLs.toArray(new SVNURL[svnURLs.size()]), this.myShowFiles);
        this.getRepositoryBrowser().getRepositoryTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                JPopupMenu popupMenu;
                JTree tree = RepositoryBrowserDialog.this.getRepositoryBrowser().getRepositoryTree();
                int row = tree.getRowForLocation(x, y);
                if (row >= 0) {
                    tree.setSelectionRow(row);
                }
                if ((popupMenu = RepositoryBrowserDialog.this.createPopup(toolWindow)) != null) {
                    popupMenu.show(comp, x, y);
                }
            }
        });
        return panel;
    }

    protected RepositoryBrowserComponent getRepositoryBrowser() {
        if (this.myRepositoryBrowser == null) {
            this.myRepositoryBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
            this.myRepositoryBrowser.setPreferredSize(new Dimension(300, 300));
        }
        return this.myRepositoryBrowser;
    }

    public void disposeRepositoryBrowser() {
        if (this.myRepositoryBrowser != null) {
            Disposer.dispose((Disposable)this.myRepositoryBrowser);
            this.myRepositoryBrowser = null;
        }
    }

    protected void dispose() {
        super.dispose();
        this.disposeRepositoryBrowser();
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.getRepositoryBrowser().getPreferredFocusedComponent();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        return true;
    }

    public String getSelectedURL() {
        return this.getRepositoryBrowser().getSelectedURL();
    }

    @Nullable
    protected RepositoryTreeNode getSelectedNode() {
        return this.getRepositoryBrowser().getSelectedNode();
    }

    @Nullable
    private File selectFile(String title, String description) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(title);
        fcd.setDescription(description);
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)this.myProject, null);
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        if (path.endsWith(":")) {
            return new File(path + "/");
        }
        return new File(path);
    }

    protected static void doMkdir(final SVNURL url, final String comment, final Project project) {
        final SVNException[] exception = new SVNException[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.browser.creating", url.toString()));
                }
                SvnVcs vcs = SvnVcs.getInstance(project);
                try {
                    SVNCommitClient committer = vcs.createCommitClient();
                    committer.doMkDir(new SVNURL[]{url}, comment);
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.text.create.remote.folder", new Object[0]), false, project);
        if (exception[0] != null) {
            Messages.showErrorDialog((String)exception[0].getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
        }
    }

    private void doCopy(final SVNURL src, final SVNURL dst, final boolean move, final String comment) {
        final SVNException[] exception = new SVNException[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.setText(move ? SvnBundle.message("progress.text.browser.moving", src) : SvnBundle.message("progress.text.browser.copying", src));
                    progress.setText2(SvnBundle.message("progress.text.browser.remote.destination", dst));
                }
                SvnVcs vcs = SvnVcs.getInstance(RepositoryBrowserDialog.this.myProject);
                try {
                    SVNCopyClient committer = vcs.createCopyClient();
                    SVNCopySource[] copySource = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.HEAD, src)};
                    committer.doCopy(copySource, dst, move, true, true, comment, null);
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
            }
        };
        String progressTitle = move ? SvnBundle.message("progress.title.browser.move", new Object[0]) : SvnBundle.message("progress.title.browser.copy", new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, progressTitle, false, this.myProject);
        if (exception[0] != null) {
            Messages.showErrorDialog((String)exception[0].getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
        }
    }

    protected void doCheckout(@Nullable CheckoutProvider.Listener listener, RepositoryTreeNode selectedNode) {
        File dir;
        if (selectedNode == null) {
            return;
        }
        SVNURL url = selectedNode.getURL();
        String relativePath = "";
        SVNDirEntry dirEntry = selectedNode.getSVNDirEntry();
        if (dirEntry != null) {
            if (dirEntry.getRepositoryRoot() != null) {
                if (!dirEntry.getRepositoryRoot().equals((Object)url)) {
                    relativePath = SVNPathUtil.getRelativePath((String)dirEntry.getRepositoryRoot().toString(), (String)url.toDecodedString());
                }
            } else {
                relativePath = dirEntry.getRelativePath();
            }
        } else {
            relativePath = url.getPath();
        }
        if ((dir = this.selectFile(SvnBundle.message("svn.checkout.destination.directory.title", new Object[0]), SvnBundle.message("svn.checkout.destination.directory.description", new Object[0]))) == null) {
            return;
        }
        Project p = this.myProject;
        CheckoutOptionsDialog dialog = new CheckoutOptionsDialog(p, url, dir, SvnUtil.getVirtualFile(dir.getAbsolutePath()), relativePath);
        dialog.show();
        dir = dialog.getTarget();
        if (dialog.isOK() && dir != null) {
            SVNRevision revision;
            try {
                revision = dialog.getRevision();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", e.getMessage()), (String)SvnBundle.message("message.title.check.out", new Object[0]));
                return;
            }
            SvnCheckoutProvider.doCheckout(this.myProject, dir, url.toString(), revision, dialog.getDepth(), dialog.isIgnoreExternals(), listener);
        }
    }

    protected boolean doImport() {
        File dir = this.selectFile("Import Directory", "Select directory to import into repository");
        if (dir == null) {
            return false;
        }
        RepositoryTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return false;
        }
        SVNURL url = selectedNode.getURL();
        ImportOptionsDialog dialog = new ImportOptionsDialog(this.myProject, url, dir);
        dialog.show();
        VcsConfiguration.getInstance((Project)this.myProject).saveCommitMessage(dialog.getCommitMessage());
        if (dialog.isOK()) {
            File src = dialog.getTarget();
            boolean ignored = dialog.isIncludeIgnored();
            String message = dialog.getCommitMessage();
            SvnCheckoutProvider.doImport(this.myProject, src, url, dialog.getDepth(), ignored, message);
            selectedNode.reload(false);
        }
        return dialog.isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnifiedDiff(File targetFile, SVNURL sourceURL, SVNURL targetURL) {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(targetFile));
            this.myVCS.createDiffClient().doDiff(sourceURL, SVNRevision.HEAD, targetURL, SVNRevision.HEAD, true, false, os);
        }
        catch (IOException e1) {
        }
        catch (SVNException e1) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGraphicalDiff(SVNURL sourceURL, SVNURL targetURL) throws SVNException {
        SvnDiffEditor diffEditor;
        long rev;
        SVNRepository sourceRepository = this.myVCS.createRepository(sourceURL.toString());
        sourceRepository.setCanceller((ISVNCanceller)new SvnProgressCanceller());
        SVNRepository targetRepository = null;
        try {
            rev = sourceRepository.getLatestRevision();
            targetRepository = this.myVCS.createRepository(targetURL.toString());
            diffEditor = new SvnDiffEditor(sourceRepository, targetRepository, -1L, false);
            ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnProgressCanceller(), null);
            sourceRepository.diff(targetURL, rev, rev, null, true, true, false, new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, rev, false);
                    reporter.finishReport();
                }
            }, cancellableEditor);
        }
        finally {
            sourceRepository.closeSession();
            if (targetRepository != null) {
                targetRepository.closeSession();
            }
        }
        String sourceTitle = SVNPathUtil.tail((String)sourceURL.toString());
        String targetTitle = SVNPathUtil.tail((String)targetURL.toString());
        this.showDiffEditorResults(diffEditor.getChangesMap(), sourceTitle, targetTitle, sourceURL, targetURL, rev);
    }

    private void showDiffEditorResults(Map<String, Change> changes, String sourceTitle, String targetTitle, final SVNURL sourceUrl, final SVNURL targetUrl, final long revision) {
        if (changes.isEmpty()) {
            final String text = SvnBundle.message("repository.browser.compare.no.difference.message", sourceTitle, targetTitle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showInfoMessage((Project)RepositoryBrowserDialog.this.myProject, (String)text, (String)SvnBundle.message("repository.browser.compare.no.difference.title", new Object[0]));
                }
            });
            return;
        }
        final Collection<Change> changesList = changes.values();
        final String title = SvnBundle.message("repository.browser.compare.title", sourceTitle, targetTitle);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeListViewerDialog dlg = new ChangeListViewerDialog((Component)RepositoryBrowserDialog.this.myRepositoryBrowser, RepositoryBrowserDialog.this.myProject, changesList, true);
                dlg.setTitle(title);
                dlg.setConvertor((NotNullFunction)new NotNullFunction<Change, Change>(){

                    @NotNull
                    public Change fun(Change change) {
                        FilePath path = ChangesUtil.getFilePath((Change)change);
                        Change change2 = new Change((ContentRevision)new UrlContentRevision(change.getBeforeRevision(), FilePathImpl.createNonLocal((String)SVNPathUtil.append((String)sourceUrl.toString(), (String)path.getPath()), (boolean)path.isDirectory()), revision), (ContentRevision)new UrlContentRevision(change.getAfterRevision(), FilePathImpl.createNonLocal((String)SVNPathUtil.append((String)targetUrl.toString(), (String)path.getPath()), (boolean)path.isDirectory()), revision));
                        if (change2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog$7$1", "fun"));
                        }
                        return change2;
                    }
                });
                dlg.show();
            }
        });
    }

    public void setDefaultExpander(NotNullFunction<RepositoryBrowserComponent, Expander> expanderFactory) {
        this.myRepositoryBrowser.setLazyLoadingExpander(expanderFactory);
    }

    private static class UrlContentRevision
    implements ContentRevision {
        private final ContentRevision myContentRevision;
        private final FilePath myPath;
        private final SvnRevisionNumber myNumber;

        private UrlContentRevision(ContentRevision contentRevision, FilePath path, long revision) {
            this.myContentRevision = contentRevision;
            this.myPath = path;
            this.myNumber = new SvnRevisionNumber(SVNRevision.create((long)revision));
        }

        public String getContent() throws VcsException {
            return this.myContentRevision == null ? "" : this.myContentRevision.getContent();
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog$UrlContentRevision", "getFile"));
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            SvnRevisionNumber svnRevisionNumber = this.myNumber;
            if (svnRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/RepositoryBrowserDialog$UrlContentRevision", "getRevisionNumber"));
            }
            return svnRevisionNumber;
        }
    }

    private class CloseToolWindowAction
    extends AnAction {
        private CloseToolWindowAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryBrowserDialog.this.disposeRepositoryBrowser();
            Project p = (Project)e.getData(CommonDataKeys.PROJECT);
            ToolWindowManager.getInstance((Project)p).unregisterToolWindow("SVN Repositories");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Close");
            e.getPresentation().setDescription("Close this tool window");
            e.getPresentation().setIcon(AllIcons.Actions.Cancel);
        }
    }

    protected class DetailsAction
    extends ToggleAction {
        private boolean myIsSelected;

        protected DetailsAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.details.action", new Object[0]));
            e.getPresentation().setText(SvnBundle.message("repository.browser.details.action", new Object[0]));
            e.getPresentation().setIcon(AllIcons.Actions.Annotate);
            super.update(e);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIsSelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myIsSelected = state;
            SvnRepositoryTreeCellRenderer r = new SvnRepositoryTreeCellRenderer();
            r.setShowDetails(state);
            RepositoryBrowserDialog.this.getRepositoryBrowser().getRepositoryTree().setCellRenderer((TreeCellRenderer)((Object)r));
        }
    }

    protected class OpenAction
    extends AnAction {
        protected OpenAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(false);
            if (RepositoryBrowserDialog.this.myVCS == null) {
                return;
            }
            e.getPresentation().setText("_Open", true);
            e.getPresentation().setEnabled(RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedVcsFile() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile vcsVF = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedVcsFile();
            if (vcsVF != null) {
                FileEditorManager.getInstance((Project)RepositoryBrowserDialog.this.myVCS.getProject()).openFile(vcsVF, true);
            }
        }
    }

    protected class BrowseChangesAction
    extends AnAction {
        public BrowseChangesAction() {
            super(SvnBundle.message("repository.browser.browse.changes.action", new Object[0]), SvnBundle.message("repository.browser.browse.changes.description", new Object[0]), null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            SVNURL url = node.getURL();
            AbstractVcsHelper.getInstance((Project)RepositoryBrowserDialog.this.myProject).showChangesBrowser(RepositoryBrowserDialog.this.myVCS.getCommittedChangesProvider(), (RepositoryLocation)new SvnRepositoryLocation(url.toString()), "Changes in " + url.toString(), null);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode() != null);
        }
    }

    protected class CheckoutAction
    extends AnAction {
        protected CheckoutAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("_Checkout...", true);
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (node != null) {
                SVNDirEntry entry = node.getSVNDirEntry();
                e.getPresentation().setEnabled(entry == null || entry.getKind() == SVNNodeKind.DIR);
            } else {
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (!ModalityState.NON_MODAL.equals(ModalityState.current())) {
                RepositoryBrowserDialog.this.doCancelAction();
            }
            RepositoryBrowserDialog.this.doCheckout(ProjectLevelVcsManager.getInstance((Project)RepositoryBrowserDialog.this.myProject).getCompositeCheckoutListener(), selectedNode);
        }
    }

    protected class ExportAction
    extends AnAction {
        protected ExportAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("_Export...");
            e.getPresentation().setEnabled(RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (selectedNode == null) {
                return;
            }
            SVNURL url = selectedNode.getURL();
            File dir = RepositoryBrowserDialog.this.selectFile("Destination directory", "Select export destination directory");
            if (dir == null) {
                return;
            }
            Project p = (Project)e.getData(CommonDataKeys.PROJECT);
            ExportOptionsDialog dialog = new ExportOptionsDialog(p, url, dir);
            dialog.show();
            if (dialog.isOK()) {
                SvnCheckoutProvider.doExport(RepositoryBrowserDialog.this.myProject, dir, url, dialog.getDepth(), dialog.isIgnoreExternals(), dialog.isForce(), dialog.getEOLStyle());
            }
        }
    }

    protected class ImportAction
    extends AnAction {
        protected ImportAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RepositoryBrowserDialog.this.showImportAction());
            e.getPresentation().setText(SvnBundle.message("repository.browser.import.action", new Object[0]));
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            boolean running = ProjectLevelVcsManager.getInstance((Project)RepositoryBrowserDialog.this.myProject).isBackgroundVcsOperationRunning();
            if (node != null) {
                SVNDirEntry entry = node.getSVNDirEntry();
                e.getPresentation().setEnabled((entry == null || entry.getKind() == SVNNodeKind.DIR) && !running);
            } else {
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryBrowserDialog.this.doImport();
        }
    }

    private static class AfterDeletionSelectionInstaller
    implements Expander {
        private final RepositoryTreeNode myParentNode;
        private final String myDeletedNodeName;
        private final boolean myIsFolder;
        private final RepositoryBrowserComponent myBrowserComponent;

        private AfterDeletionSelectionInstaller(RepositoryTreeNode deletedNode, RepositoryBrowserComponent browserComponent) {
            this.myBrowserComponent = browserComponent;
            this.myParentNode = (RepositoryTreeNode)deletedNode.getParent();
            this.myDeletedNodeName = deletedNode.toString();
            this.myIsFolder = !deletedNode.isLeaf();
        }

        @Override
        public void onBeforeRefresh(RepositoryTreeNode node) {
        }

        @Override
        public void onAfterRefresh(RepositoryTreeNode node) {
            TreeNode nodeToSelect = this.myParentNode.getNextChildByKey(this.myDeletedNodeName, this.myIsFolder);
            nodeToSelect = nodeToSelect == null ? this.myParentNode : nodeToSelect;
            this.myBrowserComponent.setSelectedNode(nodeToSelect);
        }
    }

    public static class DeleteAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public DeleteAction(RepositoryBrowserComponent browserComponent) {
            super("_Delete...");
            this.myBrowserComponent = browserComponent;
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, this.myBrowserComponent);
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getSVNDirEntry() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            String message;
            SVNURL url;
            boolean successful;
            DeleteOptionsDialog dialog = new DeleteOptionsDialog(this.myBrowserComponent.getProject());
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            dialog.show();
            VcsConfiguration.getInstance((Project)this.myBrowserComponent.getProject()).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK() && (successful = this.doDelete(url = node.getURL(), message = dialog.getCommitMessage()))) {
                SyntheticWorker worker = new SyntheticWorker(url);
                worker.removeSelf();
                RepositoryTreeNode parentNode = (RepositoryTreeNode)node.getParent();
                parentNode.reload(new KeepingExpandedExpander(this.myBrowserComponent, new AfterDeletionSelectionInstaller(node, this.myBrowserComponent)), false);
            }
        }

        private boolean doDelete(final SVNURL url, final String comment) {
            final SVNException[] exception = new SVNException[1];
            final Project project = this.myBrowserComponent.getProject();
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progres.text.deleting", url.toString()));
                    }
                    SvnVcs vcs = SvnVcs.getInstance(project);
                    try {
                        SVNCommitClient committer = vcs.createCommitClient();
                        committer.doDelete(new SVNURL[]{url}, comment);
                    }
                    catch (SVNException e) {
                        exception[0] = e;
                    }
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.browser.delete", new Object[0]), false, project);
            if (exception[0] != null) {
                Messages.showErrorDialog((String)exception[0].getMessage(), (String)SvnBundle.message("message.text.error", new Object[0]));
            }
            return exception[0] == null;
        }
    }

    protected class CopyUrlAction
    extends AnAction {
        protected CopyUrlAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText("Copy URL...");
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode treeNode = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (treeNode != null) {
                String url = treeNode.getURL().toString();
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(url));
            }
        }
    }

    private static interface CopyMoveReloadHelper {
        public static final CopyMoveReloadHelper EMPTY = new CopyMoveReloadHelper(){

            @Override
            public void doRefresh() {
            }

            @Override
            public void doSynthetic() {
            }

            @Override
            @Nullable
            public SVNURL parent() {
                return null;
            }
        };

        public void doRefresh();

        public void doSynthetic();

        @Nullable
        public SVNURL parent();
    }

    private static class MoveSourceReloader
    implements CopyMoveReloadHelper {
        private final RepositoryTreeNode mySource;
        private final RepositoryTreeNode myParent;

        private MoveSourceReloader(RepositoryTreeNode source) {
            this.mySource = source;
            this.myParent = (RepositoryTreeNode)source.getParent();
        }

        @Override
        public void doRefresh() {
            this.myParent.reload(false);
        }

        @Override
        public void doSynthetic() {
            SyntheticWorker worker = new SyntheticWorker(this.mySource.getURL());
            worker.removeSelf();
        }

        @Override
        public SVNURL parent() {
            return this.myParent.getURL();
        }
    }

    private static class TargetReloader
    implements CopyMoveReloadHelper {
        private final RepositoryTreeNode myDialogParent;
        private final SVNURL myDst;
        private final RepositoryTreeNode mySourceNode;
        private final RepositoryTreeNode myRoot;
        private final RepositoryBrowserComponent myBrowserComponent;
        private final String myNewName;

        private TargetReloader(CopyOptionsDialog dialog, RepositoryTreeNode node, RepositoryTreeNode root, RepositoryBrowserComponent browserComponent) {
            this.myDialogParent = dialog.getTargetParentNode();
            this.myDst = dialog.getTargetURL();
            this.mySourceNode = node;
            this.myRoot = root;
            this.myBrowserComponent = browserComponent;
            this.myNewName = dialog.getName();
        }

        @Override
        public void doRefresh() {
            TreeNode[] oldPath = this.myDialogParent.getSelfPath();
            TreeNode[] correctedPath = new TreeNode[oldPath.length + 1];
            System.arraycopy(oldPath, 0, correctedPath, 1, oldPath.length);
            this.myRoot.reload(new OpeningExpander(oldPath, this.myBrowserComponent, this.myDialogParent), false);
        }

        @Override
        public void doSynthetic() {
            SyntheticWorker parentWorker = new SyntheticWorker(this.myDialogParent.getURL());
            parentWorker.addSyntheticChildToSelf(this.myDst, this.myRoot.getURL(), this.myNewName, !this.mySourceNode.isLeaf());
            parentWorker.copyTreeToSelf(this.mySourceNode);
        }

        @Override
        public SVNURL parent() {
            return this.myDialogParent.getURL();
        }
    }

    protected class CopyOrMoveAction
    extends AnAction {
        private final String myActionName;
        private final String myDialogTitleKey;
        private final boolean myMove;

        public CopyOrMoveAction(String actionName, String dialogTitleKey, boolean move) {
            this.myActionName = actionName;
            this.myDialogTitleKey = dialogTitleKey;
            this.myMove = move;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(this.myActionName);
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getSVNDirEntry() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            RepositoryTreeNode rootNode = node;
            while (!rootNode.isRepositoryRoot()) {
                rootNode = (RepositoryTreeNode)rootNode.getParent();
            }
            CopyOptionsDialog dialog = new CopyOptionsDialog(SvnBundle.message(this.myDialogTitleKey, new Object[0]), RepositoryBrowserDialog.this.myProject, rootNode, node, !this.myMove);
            dialog.show();
            VcsConfiguration.getInstance((Project)RepositoryBrowserDialog.this.myProject).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK()) {
                SVNURL dst = dialog.getTargetURL();
                SVNURL src = dialog.getSourceURL();
                String path = src.getPath();
                int folder = path.replace('\\', '/').lastIndexOf(47);
                if (folder != -1) {
                    int result;
                    String lastFolder = path.substring(folder + 1, path.length());
                    if (this.myMove && "trunk".equalsIgnoreCase(lastFolder) && 0 == (result = Messages.showOkCancelDialog((Project)RepositoryBrowserDialog.this.myProject, (String)("You are about to move folder named '" + lastFolder + "'. Are you sure?"), (String)SvnBundle.message(this.myDialogTitleKey, new Object[0]), (Icon)Messages.getWarningIcon()))) {
                        return;
                    }
                }
                String message = dialog.getCommitMessage();
                RepositoryBrowserDialog.this.doCopy(src, dst, this.myMove, message);
                CopyMoveReloadHelper sourceReloader = this.myMove ? new MoveSourceReloader(node) : CopyMoveReloadHelper.EMPTY;
                TargetReloader destinationReloader = new TargetReloader(dialog, node, rootNode, RepositoryBrowserDialog.this.myRepositoryBrowser);
                sourceReloader.doSynthetic();
                destinationReloader.doSynthetic();
                if (!this.myMove || !Comparing.equal((Object)sourceReloader.parent(), (Object)destinationReloader.parent())) {
                    destinationReloader.doRefresh();
                }
                sourceReloader.doRefresh();
            }
        }
    }

    protected class DiffAction
    extends AnAction {
        protected DiffAction() {
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setText("Compare With...", true);
            if (node != null) {
                SVNDirEntry entry = node.getSVNDirEntry();
                e.getPresentation().setEnabled(entry == null || entry.getKind() == SVNNodeKind.DIR);
            } else {
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (node == null) {
                return;
            }
            while (node.getSVNDirEntry() != null) {
                node = (RepositoryTreeNode)node.getParent();
            }
            SVNURL root = node.getURL();
            RepositoryTreeNode selectedNode = RepositoryBrowserDialog.this.getSelectedNode();
            if (selectedNode == null) {
                return;
            }
            SVNURL sourceURL = selectedNode.getURL();
            DiffOptionsDialog dialog = new DiffOptionsDialog(RepositoryBrowserDialog.this.myProject, root, sourceURL);
            dialog.show();
            if (dialog.isOK()) {
                boolean cancelable;
                Runnable command;
                SVNURL targetURL = dialog.getTargetURL();
                if (dialog.isReverseDiff()) {
                    targetURL = sourceURL;
                    sourceURL = dialog.getTargetURL();
                }
                final SVNURL sURL = sourceURL;
                final SVNURL tURL = targetURL;
                if (dialog.isUnifiedDiff()) {
                    final File targetFile = dialog.getTargetFile();
                    command = new Runnable(){

                        @Override
                        public void run() {
                            targetFile.getParentFile().mkdirs();
                            RepositoryBrowserDialog.this.doUnifiedDiff(targetFile, sURL, tURL);
                        }
                    };
                    cancelable = false;
                } else {
                    command = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RepositoryBrowserDialog.this.doGraphicalDiff(sURL, tURL);
                            }
                            catch (SVNCancelException ex) {
                            }
                            catch (SVNException e1) {
                                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showErrorDialog((Project)RepositoryBrowserDialog.this.myProject, (String)e1.getErrorMessage().getFullMessage(), (String)"Error");
                                    }
                                }, null, (Project)RepositoryBrowserDialog.this.myProject);
                            }
                        }
                    };
                    cancelable = true;
                }
                ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.computing.difference", new Object[0]), cancelable, RepositoryBrowserDialog.this.myProject);
            }
        }
    }

    public static class MkDirAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public MkDirAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.new.folder.action", new Object[0]));
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node != null) {
                SVNDirEntry entry = node.getSVNDirEntry();
                e.getPresentation().setEnabled(entry == null || entry.getKind() == SVNNodeKind.DIR);
            } else {
                e.getPresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node == null) {
                return;
            }
            Project project = this.myBrowserComponent.getProject();
            MkdirOptionsDialog dialog = new MkdirOptionsDialog(project, node.getURL());
            dialog.show();
            VcsConfiguration.getInstance((Project)project).saveCommitMessage(dialog.getCommitMessage());
            if (dialog.isOK()) {
                SVNURL url = dialog.getURL();
                String message = dialog.getCommitMessage();
                RepositoryBrowserDialog.doMkdir(url, message, project);
                SVNURL repositoryUrl = node.getSVNDirEntry() == null ? node.getURL() : node.getSVNDirEntry().getRepositoryRoot();
                SyntheticWorker worker = new SyntheticWorker(node.getURL());
                worker.addSyntheticChildToSelf(url, repositoryUrl, dialog.getName(), true);
                node.reload(false);
            }
        }
    }

    protected static class DiscardLocationAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public DiscardLocationAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.discard.location.action", new Object[0]), SvnBundle.message("repository.browser.discard.location.action", new Object[0]), AllIcons.General.Remove);
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            e.getPresentation().setText(SvnBundle.message("repository.browser.discard.location.action", new Object[0]), true);
            e.getPresentation().setIcon(AllIcons.General.Remove);
            e.getPresentation().setEnabled(node != null && node.getParent() instanceof RepositoryTreeRootNode);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = this.myBrowserComponent.getSelectedNode();
            if (node == null) {
                return;
            }
            SVNURL url = node.getURL();
            if (url != null) {
                int rc = Messages.showYesNoDialog((Project)this.myBrowserComponent.getProject(), (String)SvnBundle.message("repository.browser.discard.location.prompt", url.toString()), (String)SvnBundle.message("repository.browser.discard.location.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (rc != 0) {
                    return;
                }
                SvnApplicationSettings.getInstance().removeCheckoutURL(url.toString());
                this.myBrowserComponent.removeURL(url.toString());
            }
        }
    }

    protected class EditLocationAction
    extends AnAction {
        public EditLocationAction() {
            super(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
        }

        public void update(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (e.getPlace().equals(RepositoryBrowserDialog.PLACE_TOOLBAR)) {
                e.getPresentation().setDescription(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
                e.getPresentation().setText(SvnBundle.message("repository.browser.edit.location.menu.item", new Object[0]));
                e.getPresentation().setIcon(AllIcons.Actions.EditSource);
            }
            e.getPresentation().setEnabled(node != null && node.getParent() instanceof RepositoryTreeRootNode);
        }

        public void actionPerformed(AnActionEvent e) {
            String url;
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            if (node == null || !(node.getParent() instanceof RepositoryTreeRootNode)) {
                return;
            }
            final String oldUrl = node.getURL().toString();
            SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
            AddRepositoryLocationDialog dialog = new AddRepositoryLocationDialog(RepositoryBrowserDialog.this.myProject, settings.getTypedUrlsListCopy()){

                @Override
                protected String initText() {
                    return oldUrl;
                }

                @Override
                public String getTitle() {
                    return SvnBundle.message("repository.browser.edit.location.dialog.title", new Object[0]);
                }
            };
            dialog.show();
            if (dialog.getExitCode() == 0 && (url = dialog.getSelected()) != null && url.length() > 0) {
                settings.addTypedUrl(url);
                settings.removeCheckoutURL(oldUrl);
                settings.addCheckoutURL(url);
                RepositoryBrowserComponent browser = RepositoryBrowserDialog.this.getRepositoryBrowser();
                browser.removeURL(oldUrl);
                browser.addURL(url);
            }
        }
    }

    protected static class AddLocationAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public AddLocationAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("repository.browser.add.location.menu.item", new Object[0]));
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            if (e.getPlace().equals(RepositoryBrowserDialog.PLACE_TOOLBAR)) {
                e.getPresentation().setDescription(SvnBundle.message("repository.browser.add.location.action", new Object[0]));
                e.getPresentation().setText(SvnBundle.message("repository.browser.add.location.action", new Object[0]));
                e.getPresentation().setIcon(IconUtil.getAddIcon());
            }
        }

        public void actionPerformed(AnActionEvent e) {
            String url;
            SvnApplicationSettings settings = SvnApplicationSettings.getInstance();
            AddRepositoryLocationDialog dialog = new AddRepositoryLocationDialog(this.myBrowserComponent.getProject(), settings.getTypedUrlsListCopy());
            dialog.show();
            if (dialog.getExitCode() == 0 && (url = dialog.getSelected()) != null && url.length() > 0) {
                settings.addTypedUrl(url);
                settings.addCheckoutURL(url);
                this.myBrowserComponent.addURL(url);
            }
        }
    }

    public static class RefreshAction
    extends AnAction {
        private final RepositoryBrowserComponent myBrowserComponent;

        public RefreshAction(RepositoryBrowserComponent browserComponent) {
            super(SvnBundle.message("action.name.refresh", new Object[0]), SvnBundle.message("repository.browser.refresh.action", new Object[0]), AllIcons.Actions.Refresh);
            this.myBrowserComponent = browserComponent;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(SvnBundle.message("action.name.refresh", new Object[0]));
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.refresh.action", new Object[0]));
            e.getPresentation().setIcon(AllIcons.Actions.Refresh);
            e.getPresentation().setEnabled(this.myBrowserComponent.getSelectedNode() != null);
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode selectedNode = this.myBrowserComponent.getSelectedNode();
            if (selectedNode != null) {
                selectedNode.reload(true);
            }
        }
    }

    protected class HistoryAction
    extends AnAction {
        protected HistoryAction() {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(SvnBundle.message("repository.browser.history.action", new Object[0]));
            e.getPresentation().setDescription(SvnBundle.message("repository.browser.history.action", new Object[0]));
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getRepositoryBrowser().getSelectedNode();
            e.getPresentation().setEnabled(node != null && node.getURL() != null && !RepositoryBrowserDialog.this.myProject.isDefault());
        }

        public void actionPerformed(AnActionEvent e) {
            RepositoryTreeNode node = RepositoryBrowserDialog.this.getSelectedNode();
            if (node == null) {
                return;
            }
            boolean isDirectory = node.getUserObject() instanceof SVNURL || node.getSVNDirEntry() != null && node.getSVNDirEntry().getKind() == SVNNodeKind.DIR;
            String url = node.getURL().toDecodedString();
            AbstractVcsHelper.getInstance((Project)RepositoryBrowserDialog.this.myProject).showFileHistory(RepositoryBrowserDialog.this.myVCS.getVcsHistoryProvider(), VcsUtil.getFilePathOnNonLocal((String)url, (boolean)isDirectory), (AbstractVcs)RepositoryBrowserDialog.this.myVCS, url);
            node.reload(false);
        }
    }
}

