/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairConsumer;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.TreeStructureNode;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

class LoadRecentBranchRevisions
extends TaskDescriptor {
    public static final String PROP_BUNCH_SIZE = "idea.svn.quick.merge.bunch.size";
    private static final int BUNCH_SIZE = 100;
    private int myBunchSize;
    private long myFirst;
    private boolean myLastLoaded;
    private OneShotMergeInfoHelper myHelper;
    private List<CommittedChangeList> myCommittedChangeLists;
    private final WCInfo myWcInfo;
    private final SvnVcs myVcs;
    private final String mySourceUrl;
    private final Integer myTestBunchSize;

    LoadRecentBranchRevisions(String branchName, long first, WCInfo info, SvnVcs vcs, String url) {
        this(branchName, first, info, vcs, url, -1);
    }

    LoadRecentBranchRevisions(String branchName, long first, WCInfo info, SvnVcs vcs, String url, int bunchSize) {
        super("Loading recent " + branchName + " revisions", Where.POOLED);
        this.myFirst = first;
        this.myWcInfo = info;
        this.myVcs = vcs;
        this.mySourceUrl = url;
        this.myTestBunchSize = Integer.getInteger(PROP_BUNCH_SIZE);
        this.myBunchSize = this.myTestBunchSize != null ? this.myTestBunchSize : (bunchSize > 0 ? bunchSize : 100);
    }

    public boolean isLastLoaded() {
        return this.myLastLoaded;
    }

    public void run(ContinuationContext context) {
        String local;
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        SvnCommittedChangesProvider committedChangesProvider = (SvnCommittedChangesProvider)this.myVcs.getCommittedChangesProvider();
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        if (this.myFirst > 0L) {
            settings.CHANGE_BEFORE = String.valueOf(this.myFirst);
            settings.USE_CHANGE_BEFORE_FILTER = true;
        }
        String relativeLocal = (local = SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.myWcInfo.getRootUrl())).startsWith("/") ? local : "/" + local;
        String relativeBranch = SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.mySourceUrl);
        relativeBranch = relativeBranch.startsWith("/") ? relativeBranch : "/" + relativeBranch;
        ProgressManager.progress2((String)SvnBundle.message("progress.text2.collecting.history", this.mySourceUrl + (this.myFirst > 0L ? "@" + this.myFirst : "")));
        final ArrayList list = new ArrayList();
        try {
            committedChangesProvider.getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.mySourceUrl), this.myBunchSize + (this.myFirst > 0L ? 2 : 1), new PairConsumer<SvnChangeList, TreeStructureNode<SVNLogEntry>>(){

                public void consume(SvnChangeList svnList, TreeStructureNode<SVNLogEntry> tree) {
                    indicator.setText2(SvnBundle.message("progress.text2.processing.revision", svnList.getNumber()));
                    list.add(new Pair((Object)svnList, tree));
                }
            });
        }
        catch (VcsException e) {
            context.handleException((Exception)((Object)e), true);
            return;
        }
        this.myCommittedChangeLists = new ArrayList<CommittedChangeList>();
        for (Pair pair : list) {
            if (this.myFirst > 0L && this.myFirst == ((SvnChangeList)pair.getFirst()).getNumber()) continue;
            this.myCommittedChangeLists.add((CommittedChangeList)pair.getFirst());
        }
        try {
            this.myHelper = new OneShotMergeInfoHelper(this.myVcs.getProject(), this.myWcInfo, this.mySourceUrl);
            ProgressManager.progress2((String)"Calculating not merged revisions");
            this.myHelper.prepare();
        }
        catch (VcsException e) {
            context.handleException((Exception)((Object)e), true);
        }
        boolean bl = this.myLastLoaded = this.myCommittedChangeLists.size() < this.myBunchSize + 1;
        if (this.myCommittedChangeLists.size() > this.myBunchSize) {
            this.myCommittedChangeLists = this.myCommittedChangeLists.subList(0, this.myBunchSize);
        }
    }

    public OneShotMergeInfoHelper getHelper() {
        return this.myHelper;
    }

    public List<CommittedChangeList> getCommittedChangeLists() {
        return this.myCommittedChangeLists;
    }
}

