/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.content;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.content.FileTooBigRuntimeException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdContentClient
extends BaseSvnClient
implements ContentClient {
    @Override
    public byte[] getContent(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException, FileTooBigRuntimeException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/content/CmdContentClient", "getContent"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target.getPathOrUrlString(), pegRevision);
        CommandUtil.put(parameters, revision);
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.cat, parameters, null);
        ByteArrayOutputStream output = command.getBinaryOutput();
        byte[] bytes = output != null ? output.toByteArray() : CharsetToolkit.getUtf8Bytes((String)command.getOutput());
        ContentRevisionCache.checkContentsSize((String)target.getPathOrUrlString(), (long)bytes.length);
        return bytes;
    }
}

