/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;

public class TerminalProcessHandler
extends OSProcessHandler {
    private static final String NON_CSI_ESCAPE_CODE = "\u001b.[@-_]";
    private static final String CSI_ESCAPE_CODE = "\u001b\\[(.*?)[@-~]";
    private final List<InteractiveCommandListener> myInteractiveListeners;
    private final CapturingProcessAdapter terminalOutputCapturer;
    private final StringBuilder outputLine;
    private final StringBuilder errorLine;

    public TerminalProcessHandler(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "<init>"));
        }
        super(process);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.terminalOutputCapturer = new CapturingProcessAdapter();
        this.outputLine = new StringBuilder();
        this.errorLine = new StringBuilder();
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "addInteractiveListener"));
        }
        this.myInteractiveListeners.add(listener);
    }

    protected boolean processHasSeparateErrorStream() {
        return false;
    }

    protected void destroyProcessImpl() {
        Process process = this.getProcess();
        process.destroy();
    }

    public void notifyTextAvailable(String text, Key outputType) {
        this.terminalOutputCapturer.onTextAvailable(new ProcessEvent((ProcessHandler)this, text), outputType);
        text = TerminalProcessHandler.filterText(text);
        if (!StringUtil.isEmpty((String)text)) {
            StringBuilder lastLine = this.getLastLineFor(outputType);
            String currentLine = lastLine.append(text).toString();
            lastLine.setLength(0);
            currentLine = TerminalProcessHandler.filterCombinedText(currentLine);
            boolean handled = false;
            for (InteractiveCommandListener listener : this.myInteractiveListeners) {
                handled |= listener.handlePrompt(currentLine, outputType);
            }
            if (!handled) {
                this.notify(currentLine, outputType, lastLine);
            }
        }
    }

    private static String filterCombinedText(@NotNull String currentLine) {
        if (currentLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterCombinedText"));
        }
        if (SystemInfo.isWindows) {
            currentLine = TerminalProcessHandler.removeAllBeforeCaretReturn(currentLine);
        }
        return currentLine;
    }

    private static String filterText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterText"));
        }
        if (SystemInfo.isWindows) {
            text = text.replaceAll(CSI_ESCAPE_CODE, "").replaceAll(NON_CSI_ESCAPE_CODE, "");
            text = StringUtil.trimLeading((String)text, (char)'\r');
        }
        return text;
    }

    private void notify(@NotNull String text, @NotNull Key outputType, @NotNull StringBuilder lastLine) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (lastLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            super.notifyTextAvailable(text, TerminalProcessHandler.resolveOutputType(text, outputType));
        } else {
            lastLine.append(text);
        }
    }

    private static String removeAllBeforeCaretReturn(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "removeAllBeforeCaretReturn"));
        }
        int caretReturn = line.lastIndexOf("\r");
        while (caretReturn >= 0) {
            if (caretReturn + 1 < line.length() && line.charAt(caretReturn + 1) != '\n') {
                line = line.substring(caretReturn + 1);
                break;
            }
            caretReturn = line.lastIndexOf("\r", caretReturn - 1);
        }
        return line;
    }

    private static Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "resolveOutputType"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "resolveOutputType"));
        }
        Key result = outputType;
        if (!ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            Matcher errorMatcher = SvnUtil.ERROR_PATTERN.matcher(line);
            Matcher warningMatcher = SvnUtil.WARNING_PATTERN.matcher(line);
            result = errorMatcher.find() || warningMatcher.find() ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        }
        return result;
    }

    @NotNull
    private StringBuilder getLastLineFor(Key outputType) {
        if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.errorLine;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "getLastLineFor"));
            }
            return stringBuilder;
        }
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.outputLine;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "getLastLineFor"));
            }
            return stringBuilder;
        }
        throw new IllegalArgumentException("Unknown process output type " + outputType);
    }

    public String getTerminalOutput() {
        return this.terminalOutputCapturer.getOutput().getStdout();
    }
}

