/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;

public class TerminalExecutor
extends CommandExecutor {
    private static final int TERMINAL_WINDOW_MAX_COLUMNS = 480;
    private final List<InteractiveCommandListener> myInteractiveListeners;

    public TerminalExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "<init>"));
        }
        super(exePath, command);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "addInteractiveListener"));
        }
        this.myInteractiveListeners.add(listener);
    }

    @Override
    protected void startHandlingStreams() {
        for (InteractiveCommandListener listener : this.myInteractiveListeners) {
            ((TerminalProcessHandler)this.myHandler).addInteractiveListener(listener);
        }
        super.startHandlingStreams();
    }

    @Override
    @NotNull
    protected OSProcessHandler createProcessHandler() {
        TerminalProcessHandler terminalProcessHandler = new TerminalProcessHandler(this.myProcess);
        if (terminalProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcessHandler"));
        }
        return terminalProcessHandler;
    }

    @Override
    @NotNull
    protected Process createProcess() throws ExecutionException {
        PtyProcess ptyProcess;
        List<String> parameters = TerminalExecutor.escapeArguments(CommandLineUtil.toCommandLine((String)this.myCommandLine.getExePath(), (List)this.myCommandLine.getParametersList().getList()));
        try {
            ptyProcess = PtyProcess.exec((String[])ArrayUtil.toStringArray(parameters), (Map)this.myCommandLine.getEnvironment(), (String)this.myCommandLine.getWorkDirectory().getAbsolutePath());
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (ptyProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalExecutor", "createProcess"));
        }
        return ptyProcess;
    }

    @Override
    public void logCommand() {
        super.logCommand();
        LOG.info("Terminal output " + ((TerminalProcessHandler)this.myHandler).getTerminalOutput());
    }

    private static List<String> escapeArguments(List<String> collection) {
        return ContainerUtil.map(collection, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.contains(" ") ? "\"" + s + "\"" : s;
            }
        });
    }

    static {
        if (SystemInfo.isWindows) {
            System.setProperty("win.pty.cols", String.valueOf(480));
        }
    }
}

