/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.SVNLockWrapper;
import org.jetbrains.idea.svn.portable.IdeaSVNInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.xml.sax.SAXException;

public class SvnInfoStructure {
    private static final Map<String, SVNConflictAction> ourConflictActions = ContainerUtil.newHashMap();
    private static final Map<String, SVNConflictReason> ourConflictReasons = ContainerUtil.newHashMap();
    @Nullable
    public File myFile;
    public String relativeUrl;
    public SVNURL myUrl;
    public SVNURL myRootURL;
    public long myRevision;
    public SVNNodeKind myKind;
    public String myUuid;
    public long myCommittedRevision;
    public Date myCommittedDate;
    public String myAuthor;
    public String mySchedule;
    public SVNURL myCopyFromURL;
    public long myCopyFromRevision;
    public Date myTextTime;
    public String myPropTime;
    public String myChecksum;
    public String myConflictOld;
    public String myConflictNew;
    public String myConflictWorking;
    public String myPropRejectFile;
    public SVNLockWrapper myLockWrapper;
    public SVNDepth myDepth;
    public String myChangelistName;
    public long myWcSize;
    public Date myCorrectCommittedDate;
    public Date myCorrectTextDate;
    public TreeConflictDescription myTreeConflict;

    public SVNInfo convert() throws SAXException, SVNException {
        return new IdeaSVNInfo(this.myFile, this.myUrl, this.myRootURL, this.myRevision, this.myKind, this.myUuid, this.myCommittedRevision, this.myCommittedDate, this.myAuthor, this.mySchedule, this.myCopyFromURL, this.myCopyFromRevision, this.myTextTime, this.myPropTime, this.myChecksum, this.myConflictOld, this.myConflictNew, this.myConflictWorking, this.myPropRejectFile, this.getLock(), this.myDepth, this.myChangelistName, this.myWcSize, this.createTreeConflict());
    }

    private SVNLock getLock() {
        SVNLock lock = null;
        if (this.myLockWrapper != null) {
            this.myLockWrapper.setPath(this.relativeUrl);
            lock = this.myLockWrapper.create();
        }
        return lock;
    }

    private SVNTreeConflictDescription createTreeConflict() throws SAXException, SVNException {
        if (this.myTreeConflict == null) {
            return null;
        }
        assert (this.myFile != null);
        SVNConflictAction action = this.parseConflictAction(this.myTreeConflict.myAction);
        SVNConflictReason reason = this.parseConflictReason(this.myTreeConflict.myReason);
        SVNOperation operation = SVNOperation.fromString((String)this.myTreeConflict.myOperation);
        operation = operation == null ? SVNOperation.NONE : operation;
        return new SVNTreeConflictDescription(this.myFile, this.myKind, action, reason, operation, this.createVersion(this.myTreeConflict.mySourceLeft), this.createVersion(this.myTreeConflict.mySourceRight));
    }

    private SVNConflictAction parseConflictAction(@NotNull String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnInfoStructure", "parseConflictAction"));
        }
        SVNConflictAction action = SVNConflictAction.fromString((String)actionName);
        SVNConflictAction sVNConflictAction = action = action != null ? action : ourConflictActions.get(actionName);
        if (action == null) {
            throw new IllegalArgumentException("Unknown conflict action " + actionName);
        }
        return action;
    }

    private SVNConflictReason parseConflictReason(@NotNull String reasonName) throws SAXException {
        if (reasonName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnInfoStructure", "parseConflictReason"));
        }
        SVNConflictReason reason = SVNConflictReason.fromString((String)reasonName);
        SVNConflictReason sVNConflictReason = reason = reason != null ? reason : ourConflictReasons.get(reasonName);
        if (reason == null) {
            throw new SAXException("Can not parse conflict reason: " + reasonName);
        }
        return reason;
    }

    private SVNConflictVersion createVersion(ConflictVersion version) throws SVNException, SAXException {
        return version == null ? null : new SVNConflictVersion(SVNURL.parseURIEncoded((String)version.myRepoUrl), version.myPathInRepo, this.parseRevision(version.myRevision), SVNNodeKind.parseKind((String)version.myKind));
    }

    private long parseRevision(String revision) throws SAXException {
        try {
            return Long.parseLong(revision);
        }
        catch (NumberFormatException e) {
            throw new SAXException(e);
        }
    }

    static {
        ourConflictActions.put("add", SVNConflictAction.ADD);
        ourConflictActions.put("edit", SVNConflictAction.EDIT);
        ourConflictActions.put("delete", SVNConflictAction.DELETE);
        ourConflictActions.put("replace", SVNConflictAction.REPLACE);
        ourConflictReasons.put("edit", SVNConflictReason.EDITED);
        ourConflictReasons.put("obstruct", SVNConflictReason.OBSTRUCTED);
        ourConflictReasons.put("delete", SVNConflictReason.DELETED);
        ourConflictReasons.put("miss", SVNConflictReason.MISSING);
        ourConflictReasons.put("unversion", SVNConflictReason.UNVERSIONED);
        ourConflictReasons.put("add", SVNConflictReason.ADDED);
        ourConflictReasons.put("replace", SVNConflictReason.REPLACED);
    }

    public static class ConflictVersion {
        public String myKind;
        public String myPathInRepo;
        public String myRepoUrl;
        public String myRevision;
    }

    public static class TreeConflictDescription {
        public String myOperation;
        public String myKind;
        public String myReason;
        public String myVictim;
        public String myAction;
        public ConflictVersion mySourceLeft;
        public ConflictVersion mySourceRight;
    }
}

