/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SVNLockWrapper;
import org.jetbrains.idea.svn.commandLine.SvnInfoStructure;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvnInfoHandler
extends DefaultHandler {
    @Nullable
    private final File myBase;
    private final Consumer<SVNInfo> myInfoConsumer;
    private Map<File, SVNInfo> myResultsMap;
    private SvnInfoStructure myPending;
    private final Map<String, Getter<ElementHandlerBase>> myElementsMap;
    private final List<ElementHandlerBase> myParseStack;
    private final StringBuilder mySb;

    public SvnInfoHandler(@Nullable File base, Consumer<SVNInfo> infoConsumer) {
        this.myBase = base;
        this.myInfoConsumer = infoConsumer;
        this.myPending = this.createPending();
        this.myElementsMap = new HashMap<String, Getter<ElementHandlerBase>>();
        this.fillElements();
        this.myParseStack = new ArrayList<ElementHandlerBase>();
        this.myParseStack.add(new Fake());
        this.myResultsMap = new HashMap<File, SVNInfo>();
        this.mySb = new StringBuilder();
    }

    private void switchPending() throws SAXException {
        SVNInfo info;
        try {
            info = this.myPending.convert();
        }
        catch (SVNException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (this.myInfoConsumer != null) {
            this.myInfoConsumer.consume((Object)info);
        }
        this.myResultsMap.put(info.getFile(), info);
        this.myPending = this.createPending();
    }

    private SvnInfoStructure createPending() {
        SvnInfoStructure pending = new SvnInfoStructure();
        pending.myDepth = SVNDepth.INFINITY;
        return pending;
    }

    @Override
    public void endDocument() throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        for (int i = this.myParseStack.size() - 1; i >= 0; --i) {
            ElementHandlerBase current = this.myParseStack.get(i);
            if (!(current instanceof Entry)) continue;
            this.switchPending();
            break;
        }
        this.myParseStack.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        ElementHandlerBase current = this.myParseStack.get(this.myParseStack.size() - 1);
        while (true) {
            boolean createNewChild;
            if (createNewChild = current.startElement(uri, localName, qName, attributes)) {
                SvnInfoHandler.assertSAX(this.myElementsMap.containsKey(qName));
                ElementHandlerBase newChild = (ElementHandlerBase)this.myElementsMap.get(qName).get();
                newChild.setParent(current);
                newChild.updateInfo(attributes, this.myPending);
                this.myParseStack.add(newChild);
                return;
            }
            if (current instanceof Entry) {
                this.switchPending();
            }
            this.myParseStack.remove(this.myParseStack.size() - 1);
            SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
            current = this.myParseStack.get(this.myParseStack.size() - 1);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandlerBase current = this.myParseStack.get(this.myParseStack.size() - 1);
        String value = this.mySb.toString().trim();
        if (!StringUtil.isEmpty((String)value)) {
            current.characters(value, this.myPending);
        }
        this.mySb.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        this.mySb.append(ch, start, length);
    }

    public Map<String, Getter<ElementHandlerBase>> getElementsMap() {
        return this.myElementsMap;
    }

    private void fillElements() {
        this.myElementsMap.put("copy-from-url", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new CopyFromUrl();
            }
        });
        this.myElementsMap.put("copy-from-rev", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new CopyFromRev();
            }
        });
        this.myElementsMap.put("changelist", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new ChangeList();
            }
        });
        this.myElementsMap.put("author", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Author();
            }
        });
        this.myElementsMap.put("checksum", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Checksum();
            }
        });
        this.myElementsMap.put("commit", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Commit();
            }
        });
        this.myElementsMap.put("conflict", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Conflict();
            }
        });
        this.myElementsMap.put("cur-base-file", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new CurBase();
            }
        });
        this.myElementsMap.put("date", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Date();
            }
        });
        this.myElementsMap.put("depth", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Depth();
            }
        });
        this.myElementsMap.put("entry", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Entry(SvnInfoHandler.this.myBase);
            }
        });
        this.myElementsMap.put("info", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Info();
            }
        });
        this.myElementsMap.put("prev-base-file", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new PrevBase();
            }
        });
        this.myElementsMap.put("prev-wc-file", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new PrevWc();
            }
        });
        this.myElementsMap.put("prop-file", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new PropFile();
            }
        });
        this.myElementsMap.put("repository", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Repository();
            }
        });
        this.myElementsMap.put("root", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Root();
            }
        });
        this.myElementsMap.put("schedule", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Schedule();
            }
        });
        this.myElementsMap.put("text-updated", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new TextUpdated();
            }
        });
        this.myElementsMap.put("tree-conflict", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new TreeConflict();
            }
        });
        this.myElementsMap.put("url", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Url();
            }
        });
        this.myElementsMap.put("relative-url", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new RelativeUrl();
            }
        });
        this.myElementsMap.put("lock", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Lock();
            }
        });
        this.myElementsMap.put("token", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockToken();
            }
        });
        this.myElementsMap.put("owner", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockOwner();
            }
        });
        this.myElementsMap.put("comment", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockComment();
            }
        });
        this.myElementsMap.put("created", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new LockCreated();
            }
        });
        this.myElementsMap.put("uuid", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Uuid();
            }
        });
        this.myElementsMap.put("version", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new Version();
            }
        });
        this.myElementsMap.put("wc-info", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new WcInfo();
            }
        });
        this.myElementsMap.put("moved-to", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new MovedPath();
            }
        });
        this.myElementsMap.put("moved-from", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new MovedPath();
            }
        });
        this.myElementsMap.put("wcroot-abspath", new Getter<ElementHandlerBase>(){

            public ElementHandlerBase get() {
                return new WcRoot();
            }
        });
    }

    public Map<File, SVNInfo> getResultsMap() {
        return this.myResultsMap;
    }

    private static void assertSAX(boolean shouldBeTrue) throws SAXException {
        if (!shouldBeTrue) {
            throw new SAXException("can not parse output");
        }
    }

    private static abstract class ElementHandlerBase {
        private final Set<String> myAwaitedChildren;
        private final Set<String> myAwaitedChildrenMultiple;
        private ElementHandlerBase parent;

        ElementHandlerBase(String[] awaitedChildren, String[] awaitedChildrenMultiple) {
            this.myAwaitedChildren = new HashSet<String>(Arrays.asList(awaitedChildren));
            this.myAwaitedChildrenMultiple = new HashSet<String>(Arrays.asList(awaitedChildrenMultiple));
        }

        @NotNull
        public ElementHandlerBase getParent() {
            ElementHandlerBase elementHandlerBase = this.parent;
            if (elementHandlerBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SvnInfoHandler$ElementHandlerBase", "getParent"));
            }
            return elementHandlerBase;
        }

        public void setParent(@NotNull ElementHandlerBase parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/SvnInfoHandler$ElementHandlerBase", "setParent"));
            }
            this.parent = parent;
        }

        protected abstract void updateInfo(Attributes var1, SvnInfoStructure var2) throws SAXException;

        public boolean startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.myAwaitedChildrenMultiple.contains(qName)) {
                return true;
            }
            return this.myAwaitedChildren.remove(qName);
        }

        public abstract void characters(String var1, SvnInfoStructure var2) throws SAXException;
    }

    private static class Fake
    extends ElementHandlerBase {
        private Fake() {
            super(new String[]{"info"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Info
    extends ElementHandlerBase {
        private Info() {
            super(new String[0], new String[]{"entry"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Entry
    extends ElementHandlerBase {
        @Nullable
        private final File myBase;

        private Entry(@Nullable File base) {
            super(new String[]{"url", "relative-url", "lock", "repository", "wc-info", "commit", "conflict", "tree-conflict"}, new String[0]);
            this.myBase = base;
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            String revision;
            String kind = attributes.getValue("kind");
            SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)kind));
            structure.myKind = SVNNodeKind.parseKind((String)kind);
            if (this.myBase != null) {
                String path = attributes.getValue("path");
                SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)path));
                structure.myFile = CommandUtil.resolvePath(this.myBase, path);
            }
            SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)(revision = attributes.getValue("revision"))));
            try {
                long number;
                structure.myRevision = number = Long.parseLong(revision);
            }
            catch (NumberFormatException e) {
                structure.myRevision = -1L;
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class LockCreated
    extends ElementHandlerBase {
        private LockCreated() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myLockWrapper.setCreationDate((java.util.Date)SVNDate.parseDate((String)s));
        }
    }

    private static class LockComment
    extends ElementHandlerBase {
        private LockComment() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myLockWrapper.setComment(s);
        }
    }

    private static class LockOwner
    extends ElementHandlerBase {
        private LockOwner() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myLockWrapper.setOwner(s);
        }
    }

    private static class LockToken
    extends ElementHandlerBase {
        private LockToken() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myLockWrapper.setID(s);
        }
    }

    private static class Lock
    extends ElementHandlerBase {
        private Lock() {
            super(new String[]{"token", "owner", "comment", "created"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            structure.myLockWrapper = new SVNLockWrapper();
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class RelativeUrl
    extends Url {
        private RelativeUrl() {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.relativeUrl = s;
        }
    }

    private static class Url
    extends ElementHandlerBase {
        private Url() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myUrl = SVNURL.parseURIEncoded((String)s);
            }
            catch (SVNException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class Repository
    extends ElementHandlerBase {
        private Repository() {
            super(new String[]{"root", "uuid"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class Root
    extends ElementHandlerBase {
        private Root() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myRootURL = SVNURL.parseURIEncoded((String)s);
            }
            catch (SVNException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class Uuid
    extends ElementHandlerBase {
        private Uuid() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myUuid = s;
        }
    }

    private static class WcInfo
    extends ElementHandlerBase {
        private WcInfo() {
            super(new String[]{"wcroot-abspath", "schedule", "depth", "text-updated", "checksum", "changelist", "copy-from-url", "copy-from-rev", "moved-to", "moved-from"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class CopyFromRev
    extends ElementHandlerBase {
        private CopyFromRev() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                long number;
                structure.myCopyFromRevision = number = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class CopyFromUrl
    extends ElementHandlerBase {
        private CopyFromUrl() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myCopyFromURL = SVNURL.parseURIEncoded((String)s);
            }
            catch (SVNException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class ChangeList
    extends ElementHandlerBase {
        private ChangeList() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myChangelistName = s;
        }
    }

    private static class WcRoot
    extends ElementHandlerBase {
        private WcRoot() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class Schedule
    extends ElementHandlerBase {
        private Schedule() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.mySchedule = s;
        }
    }

    private static class Depth
    extends ElementHandlerBase {
        private Depth() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myDepth = SVNDepth.fromString((String)s);
        }
    }

    private static class TextUpdated
    extends ElementHandlerBase {
        private TextUpdated() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            SVNDate date = SVNDate.parseDate((String)s);
            structure.myTextTime = date;
        }
    }

    private static class MovedPath
    extends ElementHandlerBase {
        private MovedPath() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class Checksum
    extends ElementHandlerBase {
        private Checksum() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myChecksum = s;
        }
    }

    private static class Commit
    extends ElementHandlerBase {
        private Commit() {
            super(new String[]{"author", "date"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            String revision = attributes.getValue("revision");
            try {
                long number;
                structure.myCommittedRevision = number = Long.parseLong(revision);
            }
            catch (NumberFormatException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class Author
    extends ElementHandlerBase {
        private Author() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myAuthor = s;
        }
    }

    private static class Date
    extends ElementHandlerBase {
        private Date() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            SVNDate date = SVNDate.parseDate((String)s);
            structure.myCommittedDate = date;
        }
    }

    private static class Conflict
    extends ElementHandlerBase {
        private Conflict() {
            super(new String[]{"prev-base-file", "prev-wc-file", "cur-base-file", "prop-file"}, new String[]{"version"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class PrevBase
    extends ElementHandlerBase {
        private PrevBase() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myConflictOld = new File(s).getName();
        }
    }

    private static class PrevWc
    extends ElementHandlerBase {
        private PrevWc() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myConflictWorking = new File(s).getName();
        }
    }

    private static class CurBase
    extends ElementHandlerBase {
        private CurBase() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myConflictNew = new File(s).getName();
        }
    }

    private static class PropFile
    extends ElementHandlerBase {
        private PropFile() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            structure.myPropRejectFile = s;
        }
    }

    private static class TreeConflict
    extends ElementHandlerBase {
        private TreeConflict() {
            super(new String[0], new String[]{"version"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            String action;
            String victim;
            String reason;
            String kind;
            SvnInfoStructure.TreeConflictDescription d;
            structure.myTreeConflict = d = new SvnInfoStructure.TreeConflictDescription();
            String operation = attributes.getValue("operation");
            if (!StringUtil.isEmptyOrSpaces((String)operation)) {
                d.myOperation = operation;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(kind = attributes.getValue("kind")))) {
                d.myKind = kind;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(reason = attributes.getValue("reason")))) {
                d.myReason = reason;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(victim = attributes.getValue("victim")))) {
                d.myVictim = victim;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(action = attributes.getValue("action")))) {
                d.myAction = action;
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }

    private static class Version
    extends ElementHandlerBase {
        private Version() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            if (this.getParent() instanceof Conflict) {
                return;
            }
            String side = attributes.getValue("side");
            if ("source-left".equals(side)) {
                SvnInfoStructure.ConflictVersion conflictVersion;
                structure.myTreeConflict.mySourceLeft = conflictVersion = new SvnInfoStructure.ConflictVersion();
                this.setConflictFields(attributes, conflictVersion);
            } else if ("source-right".equals(side)) {
                SvnInfoStructure.ConflictVersion conflictVersion;
                structure.myTreeConflict.mySourceRight = conflictVersion = new SvnInfoStructure.ConflictVersion();
                this.setConflictFields(attributes, conflictVersion);
            }
        }

        private void setConflictFields(Attributes attributes, SvnInfoStructure.ConflictVersion conflictVersion) {
            conflictVersion.myKind = attributes.getValue("kind");
            conflictVersion.myPathInRepo = attributes.getValue("path-in-repos");
            conflictVersion.myRepoUrl = attributes.getValue("repos-url");
            conflictVersion.myRevision = attributes.getValue("revision");
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
        }
    }
}

