/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.AuthenticationCallback;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class CredentialsCallback
extends AuthCallbackCase {
    private static final String AUTHENTICATION_REALM = "Authentication realm:";

    CredentialsCallback(@NotNull AuthenticationCallback callback, SVNURL url) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CredentialsCallback", "<init>"));
        }
        super(callback, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.startsWith(AUTHENTICATION_REALM);
    }

    @Override
    boolean getCredentials(String errText) throws SvnBindException {
        String realm = errText.startsWith(AUTHENTICATION_REALM) ? CredentialsCallback.cutFirstLine(errText).substring(AUTHENTICATION_REALM.length()).trim() : null;
        boolean isPassword = StringUtil.containsIgnoreCase((String)errText, (String)"password");
        if (this.myTried) {
            this.myAuthenticationCallback.clearPassiveCredentials(realm, this.myUrl, isPassword);
        }
        this.myTried = true;
        if (this.myAuthenticationCallback.authenticateFor(realm, this.myUrl, this.myAuthenticationCallback.getSpecialConfigDir() != null, isPassword)) {
            return true;
        }
        throw new SvnBindException("Authentication canceled for realm: " + realm);
    }

    private static String cutFirstLine(String text) {
        int idx = text.indexOf(10);
        if (idx == -1) {
            return text;
        }
        return text.substring(0, idx);
    }
}

