/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandOutputLogger;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.ResultBuilderNotifier;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNCancelException;

public class CommandExecutor {
    static final Logger LOG = Logger.getInstance((String)CommandExecutor.class.getName());
    private final AtomicReference<Integer> myExitCodeReference;
    @Nullable
    private String myMessage;
    @Nullable
    private File myMessageFile;
    private boolean myIsDestroyed;
    private boolean myNeedsDestroy;
    private volatile String myDestroyReason;
    private volatile boolean myWasCancelled;
    protected final GeneralCommandLine myCommandLine;
    protected Process myProcess;
    protected OSProcessHandler myHandler;
    private OutputStreamWriter myProcessWriter;
    private CapturingProcessAdapter outputAdapter;
    private final Object myLock;
    private final EventDispatcher<LineCommandListener> myListeners;
    private final AtomicBoolean myWasError;
    @Nullable
    private final LineCommandListener myResultBuilder;
    @NotNull
    private final Command myCommand;

    public CommandExecutor(@NotNull @NonNls String exePath, @NotNull Command command) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "<init>"));
        }
        this.myListeners = EventDispatcher.create(LineCommandListener.class);
        this.myWasError = new AtomicBoolean(false);
        this.myCommand = command;
        this.myResultBuilder = command.getResultBuilder();
        if (this.myResultBuilder != null) {
            this.myListeners.addListener((EventListener)((Object)this.myResultBuilder));
            this.myListeners.addListener((EventListener)((Object)new CommandCancelTracker()));
        }
        this.myLock = new Object();
        this.myCommandLine = new GeneralCommandLine();
        this.myCommandLine.setExePath(exePath);
        this.myCommandLine.setWorkDirectory(command.getWorkingDirectory());
        if (command.getConfigDir() != null) {
            this.myCommandLine.addParameters(new String[]{"--config-dir", command.getConfigDir().getPath()});
        }
        this.myCommandLine.addParameter(command.getName().getName());
        this.myCommandLine.addParameters(this.prepareParameters(command));
        this.myExitCodeReference = new AtomicReference();
    }

    @NotNull
    private List<String> prepareParameters(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "prepareParameters"));
        }
        List<String> parameters = command.getParameters();
        this.detectAndRemoveMessage(parameters);
        List<String> list = parameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "prepareParameters"));
        }
        return list;
    }

    private void detectAndRemoveMessage(@NotNull List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "detectAndRemoveMessage"));
        }
        int index = parameters.indexOf("-m");
        int n = index = index < 0 ? parameters.indexOf("--message") : index;
        if (index >= 0 && index + 1 < parameters.size()) {
            this.myMessage = parameters.get(index + 1);
            parameters.remove(index + 1);
            parameters.remove(index);
        }
    }

    public boolean isManuallyDestroyed() {
        return this.myIsDestroyed;
    }

    public String getDestroyReason() {
        return this.myDestroyReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SvnBindException {
        Object object = this.myLock;
        synchronized (object) {
            this.checkNotStarted();
            try {
                this.beforeCreateProcess();
                this.myProcess = this.createProcess();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.myCommandLine.toString());
                }
                this.myHandler = this.createProcessHandler();
                this.myProcessWriter = new OutputStreamWriter(this.myHandler.getProcessInput());
                this.startHandlingStreams();
            }
            catch (ExecutionException e) {
                this.listeners().startFailed(e);
                throw new SvnBindException(e);
            }
        }
    }

    protected void cleanup() {
        this.cleanupMessageFile();
    }

    protected void beforeCreateProcess() throws SvnBindException {
        EncodingEnvironmentUtil.fixDefaultEncodingIfMac((GeneralCommandLine)this.myCommandLine, null);
        this.ensureMessageFile();
    }

    private void ensureMessageFile() throws SvnBindException {
        if (this.myMessage != null) {
            try {
                File vcsFolder = new File(PathManager.getSystemPath(), "vcs");
                this.myMessageFile = FileUtil.createTempFile((File)new File(vcsFolder, "svn"), (String)"commit-message", (String)".txt");
                FileUtil.writeToFile((File)this.myMessageFile, (String)this.myMessage);
                this.myCommandLine.addParameters(new String[]{"-F", this.myMessageFile.getAbsolutePath()});
                this.myCommandLine.addParameters(new String[]{"--config-option", "config:miscellany:log-encoding=UTF-8"});
            }
            catch (IOException e) {
                throw new SvnBindException(e);
            }
        }
    }

    private void cleanupMessageFile() {
        boolean wasDeleted;
        if (this.myMessageFile != null && !(wasDeleted = FileUtil.delete((File)this.myMessageFile))) {
            LOG.info("Failed to delete temp commit message file " + this.myMessageFile.getAbsolutePath());
        }
    }

    @NotNull
    protected OSProcessHandler createProcessHandler() {
        OSProcessHandler oSProcessHandler = this.needsBinaryOutput() ? new BinaryOSProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString()) : new MyOSProcessHandler(this.myProcess, this.myCommandLine.getCommandLineString());
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "createProcessHandler"));
        }
        return oSProcessHandler;
    }

    private boolean needsBinaryOutput() {
        return SvnCommandName.cat.equals((Object)this.myCommand.getName());
    }

    @NotNull
    protected Process createProcess() throws ExecutionException {
        Process process = this.myCommandLine.createProcess();
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "createProcess"));
        }
        return process;
    }

    protected void startHandlingStreams() {
        this.outputAdapter = new CapturingProcessAdapter();
        this.myHandler.addProcessListener((ProcessListener)this.outputAdapter);
        this.myHandler.addProcessListener((ProcessListener)new ProcessTracker());
        this.myHandler.addProcessListener((ProcessListener)new ResultBuilderNotifier(this.listeners()));
        this.myHandler.addProcessListener((ProcessListener)new CommandOutputLogger());
        this.myHandler.startNotify();
    }

    public String getOutput() {
        return this.outputAdapter.getOutput().getStdout();
    }

    public String getErrorOutput() {
        return this.outputAdapter.getOutput().getStderr();
    }

    public ProcessOutput getProcessOutput() {
        return this.outputAdapter.getOutput();
    }

    @Nullable
    public ByteArrayOutputStream getBinaryOutput() {
        return this.myHandler instanceof BinaryOSProcessHandler ? ((BinaryOSProcessHandler)this.myHandler).myBinaryOutput : null;
    }

    @NotNull
    public Command getCommand() {
        Command command = this.myCommand;
        if (command == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandExecutor", "getCommand"));
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(int timeout) {
        OSProcessHandler handler;
        this.checkStarted();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return true;
            }
            handler = this.myHandler;
        }
        if (timeout == -1) {
            return handler.waitFor();
        }
        return handler.waitFor((long)timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.myLock;
        synchronized (object) {
            this.checkStarted();
            this.destroyProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SvnBindException {
        try {
            boolean finished;
            this.start();
            do {
                if ((finished = this.waitFor(500)) || !this.wasError().booleanValue() && !this.needsDestroy() && !this.checkCancelled()) continue;
                this.waitFor(1000);
                this.doDestroyProcess();
                break;
            } while (!finished);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int timeout) throws SvnBindException {
        try {
            this.start();
            boolean finished = this.waitFor(timeout);
            if (!finished) {
                this.outputAdapter.getOutput().setTimeout();
                this.doDestroyProcess();
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LineCommandListener listener) {
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.addListener((EventListener)((Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LineCommandListener listeners() {
        Object object = this.myLock;
        synchronized (object) {
            return (LineCommandListener)((Object)this.myListeners.getMulticaster());
        }
    }

    public boolean checkCancelled() {
        if (!this.myWasCancelled && this.myCommand.getCanceller() != null) {
            try {
                this.myCommand.getCanceller().checkCancelled();
            }
            catch (SVNCancelException e) {
                this.myWasCancelled = true;
            }
        }
        return this.myWasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess(@Nullable String destroyReason) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDestroyReason = destroyReason;
            this.myNeedsDestroy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroyProcess() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myIsDestroyed) {
                LOG.info("Destroying process by command: " + this.getCommandText());
                this.myIsDestroyed = true;
                this.myHandler.destroyProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsDestroy() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myNeedsDestroy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommandText() {
        Object object = this.myLock;
        synchronized (object) {
            return StringUtil.join((String[])new String[]{this.myCommandLine.getExePath(), " ", this.myCommand.getText()});
        }
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myProcess != null;
        }
    }

    public SvnCommandName getCommandName() {
        return this.myCommand.getName();
    }

    public Integer getExitCodeReference() {
        return this.myExitCodeReference.get();
    }

    public void setExitCodeReference(int value) {
        this.myExitCodeReference.set(value);
    }

    public Boolean wasError() {
        return this.myWasError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String value) throws SvnBindException {
        try {
            Object object = this.myLock;
            synchronized (object) {
                this.myProcessWriter.write(value);
                this.myProcessWriter.flush();
            }
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    public void logCommand() {
        LOG.info("Command text " + this.getCommandText());
        LOG.info("Command output " + this.getOutput());
    }

    private static class BinaryOSProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final ByteArrayOutputStream myBinaryOutput;

        public BinaryOSProcessHandler(@NotNull Process process, @Nullable String commandLine) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor$BinaryOSProcessHandler", "<init>"));
            }
            super(process, commandLine);
            this.myBinaryOutput = new ByteArrayOutputStream();
        }

        @NotNull
        protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
            SimpleBinaryOutputReader simpleBinaryOutputReader = new SimpleBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy);
            if (simpleBinaryOutputReader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/CommandExecutor$BinaryOSProcessHandler", "createOutputDataReader"));
            }
            return simpleBinaryOutputReader;
        }

        private class SimpleBinaryOutputReader
        extends BinaryOutputReader {
            public SimpleBinaryOutputReader(InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
                if (stream == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor$BinaryOSProcessHandler$SimpleBinaryOutputReader", "<init>"));
                }
                super(stream, sleepingPolicy);
                this.start();
            }

            protected void onBinaryAvailable(@NotNull byte[] data, int size) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor$BinaryOSProcessHandler$SimpleBinaryOutputReader", "onBinaryAvailable"));
                }
                BinaryOSProcessHandler.this.myBinaryOutput.write(data, 0, size);
            }

            protected Future<?> executeOnPooledThread(Runnable runnable) {
                return BinaryOSProcessHandler.this.executeOnPooledThread(runnable);
            }
        }
    }

    private class MyOSProcessHandler
    extends OSProcessHandler {
        public MyOSProcessHandler(@Nullable Process process, String commandLine) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CommandExecutor$MyOSProcessHandler", "<init>"));
            }
            super(process, commandLine);
        }

        protected Reader createProcessOutReader() {
            if (CommandExecutor.this.myCommand.getParameters().contains("--xml")) {
                return new InputStreamReader(this.myProcess.getInputStream(), CharsetToolkit.UTF8_CHARSET);
            }
            return super.createProcessOutReader();
        }
    }

    private class ProcessTracker
    extends ProcessAdapter {
        private ProcessTracker() {
        }

        public void processTerminated(ProcessEvent event) {
            CommandExecutor.this.setExitCodeReference(event.getExitCode());
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (ProcessOutputTypes.STDERR == outputType) {
                CommandExecutor.this.myWasError.set(true);
            }
        }
    }

    private class CommandCancelTracker
    extends LineCommandAdapter {
        private CommandCancelTracker() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (CommandExecutor.this.myResultBuilder != null && CommandExecutor.this.myResultBuilder.isCanceled()) {
                LOG.info("Cancelling command: " + CommandExecutor.this.getCommandText());
                CommandExecutor.this.destroyProcess();
            }
        }
    }
}

