/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.AuthenticationCallback;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class CertificateCallbackCase
extends AuthCallbackCase {
    private static final String CERTIFICATE_ERROR = "Error validating server certificate for";
    private static final String UNTRUSTED_SERVER_CERTIFICATE = "Server SSL certificate untrusted";
    private static final String CERTIFICATE_VERIFICATION_FAILED = "certificate verification failed";
    private boolean accepted;

    CertificateCallbackCase(@NotNull AuthenticationCallback callback, SVNURL url) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CertificateCallbackCase", "<init>"));
        }
        super(callback, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.startsWith(CERTIFICATE_ERROR) || error.contains(UNTRUSTED_SERVER_CERTIFICATE) || error.contains(CERTIFICATE_VERIFICATION_FAILED);
    }

    @Override
    public boolean getCredentials(String errText) throws SvnBindException {
        String realm = CertificateCallbackCase.getRealm(errText);
        if (!errText.startsWith(CERTIFICATE_ERROR)) {
            SVNURL serverUrl = this.getServerUrl(realm);
            String string = realm = serverUrl != null ? serverUrl.toString() : realm;
        }
        if (!this.myTried && this.myAuthenticationCallback.acceptSSLServerCertificate(this.myUrl, realm)) {
            this.accepted = true;
            this.myTried = true;
            return true;
        }
        throw new SvnBindException("Server SSL certificate rejected");
    }

    private static String getRealm(String errText) throws SvnBindException {
        String realm = errText;
        int idx1 = realm.indexOf(39);
        if (idx1 == -1) {
            throw new SvnBindException("Can not detect authentication realm name: " + errText);
        }
        int idx2 = realm.indexOf(39, idx1 + 1);
        if (idx2 == -1) {
            throw new SvnBindException("Can not detect authentication realm name: " + errText);
        }
        realm = realm.substring(idx1 + 1, idx2);
        return realm;
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/commandLine/CertificateCallbackCase", "updateParameters"));
        }
        if (this.accepted) {
            command.put("--trust-server-cert");
            command.put("--non-interactive");
        }
    }

    private SVNURL getServerUrl(String realm) {
        SVNURL result = this.parseUrl(realm);
        while (result != null && !StringUtil.isEmpty((String)result.getPath())) {
            try {
                result = result.removePathTail();
            }
            catch (SVNException e) {
                result = null;
            }
        }
        return result;
    }
}

