/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdCheckoutClient
extends BaseSvnClient
implements CheckoutClient {
    @Override
    public void checkout(@NotNull SvnTarget source, @NotNull File destination, @Nullable SVNRevision revision, @Nullable SVNDepth depth, boolean ignoreExternals, boolean force, @NotNull WorkingCopyFormat format, @Nullable ISVNEventHandler handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "checkout"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "checkout"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "checkout"));
        }
        this.validateFormat(format, this.getSupportedFormats());
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination, false);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, ignoreExternals, "--ignore-externals");
        CommandUtil.put(parameters, force, "--force");
        this.run(source, destination, handler, parameters);
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        Version version = this.myFactory.createVersionClient().getVersion();
        result.add(WorkingCopyFormat.from(version));
        return result;
    }

    private void run(@NotNull SvnTarget source, @NotNull File destination, @Nullable ISVNEventHandler handler, @NotNull List<String> parameters) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "run"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "run"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/checkout/CmdCheckoutClient", "run"));
        }
        BaseUpdateCommandListener listener = new BaseUpdateCommandListener(destination, handler);
        CommandUtil.execute(this.myVcs, source, SvnCommandName.checkout, parameters, listener);
        listener.throwWrappedIfException();
    }
}

