/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.AuthenticationCallback;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class IdeaSvnkitBasedAuthenticationCallback
implements AuthenticationCallback {
    private final SvnVcs myVcs;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.checkin.IdeaSvnkitBasedAuthenticationCallback");
    private File myTempDirectory;
    private boolean myProxyCredentialsWereReturned;
    private SvnConfiguration myConfiguration;
    private final Set<String> myRequestedCredentials;

    public IdeaSvnkitBasedAuthenticationCallback(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myConfiguration = SvnConfiguration.getInstance(this.myVcs.getProject());
        this.myRequestedCredentials = ContainerUtil.newHashSet();
    }

    @Override
    public boolean authenticateFor(String realm, SVNURL repositoryUrl, boolean previousFailed, boolean passwordRequest) {
        if (repositoryUrl == null) {
            return false;
        }
        return new CredentialsAuthenticator(this.myVcs).tryAuthenticate(realm, repositoryUrl, previousFailed, passwordRequest);
    }

    @Override
    @Nullable
    public SVNAuthentication requestCredentials(final SVNURL repositoryUrl, final String type) {
        SVNAuthentication authentication = null;
        if (repositoryUrl != null) {
            final String realm = repositoryUrl.toDecodedString();
            authentication = this.requestCredentials(realm, type, new Getter<Pair<SVNAuthentication, Boolean>>(){

                public Pair<SVNAuthentication, Boolean> get() {
                    SVNAuthentication result = IdeaSvnkitBasedAuthenticationCallback.this.myVcs.getSvnConfiguration().getInteractiveManager(IdeaSvnkitBasedAuthenticationCallback.this.myVcs).getInnerProvider().requestClientAuthentication(type, repositoryUrl, realm, null, null, true);
                    return new Pair((Object)result, (Object)true);
                }
            });
        }
        if (authentication == null) {
            LOG.warn("Could not get authentication. Type - " + type + ", Url - " + repositoryUrl);
        }
        return authentication;
    }

    @Nullable
    private <T> T requestCredentials(@NotNull String realm, @NotNull String type, @NotNull Getter<Pair<T, Boolean>> fromUserProvider) {
        Object result;
        if (realm == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestCredentials"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestCredentials"));
        }
        if (fromUserProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestCredentials"));
        }
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getData(type, realm);
        if (data != null && !this.myRequestedCredentials.contains(IdeaSvnkitBasedAuthenticationCallback.getKey(realm, type))) {
            result = data;
            this.myRequestedCredentials.add(IdeaSvnkitBasedAuthenticationCallback.getKey(realm, type));
        } else {
            Pair userData = (Pair)fromUserProvider.get();
            result = userData.first;
            if (result != null && ((Boolean)userData.second).booleanValue()) {
                this.myVcs.getSvnConfiguration().acknowledge(type, realm, result);
                this.myRequestedCredentials.add(IdeaSvnkitBasedAuthenticationCallback.getKey(realm, type));
            }
        }
        return (T)result;
    }

    @NotNull
    private static String getKey(@NotNull String realm, @NotNull String type) {
        if (realm == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "getKey"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "getKey"));
        }
        String string = type + "$" + realm;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "getKey"));
        }
        return string;
    }

    @Override
    @Nullable
    public String requestSshCredentials(final @NotNull String realm, final @NotNull SimpleCredentialsDialog.Mode mode, final @NotNull String key) {
        if (realm == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestSshCredentials"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestSshCredentials"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "requestSshCredentials"));
        }
        return this.requestCredentials(realm, "svn.ssh", new Getter<Pair<String, Boolean>>(){

            public Pair<String, Boolean> get() {
                final Ref answer = new Ref();
                final Ref save = new Ref();
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(IdeaSvnkitBasedAuthenticationCallback.this.myVcs.getProject());
                        dialog.setup(mode, realm, key, true);
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                        dialog.show();
                        if (dialog.isOK()) {
                            answer.set((Object)dialog.getPassword());
                            save.set((Object)dialog.isSaveAllowed());
                        }
                    }
                };
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command);
                return new Pair(answer.get(), (Object)(!save.isNull() && (Boolean)save.get() != false ? 1 : 0));
            }
        });
    }

    @Override
    public boolean acceptSSLServerCertificate(SVNURL repositoryUrl, String realm) {
        if (repositoryUrl == null) {
            return false;
        }
        return new SSLServerCertificateAuthenticator(this.myVcs).tryAuthenticate(repositoryUrl, realm);
    }

    @Override
    public void clearPassiveCredentials(String realm, SVNURL repositoryUrl, boolean password) {
        if (repositoryUrl == null) {
            return;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
        List<String> kinds = IdeaSvnkitBasedAuthenticationCallback.getKinds(repositoryUrl, password);
        for (String kind : kinds) {
            configuration.clearCredentials(kind, realm);
        }
    }

    @Override
    public boolean haveDataForTmpConfig() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        return SvnConfiguration.getInstance(this.myVcs.getProject()).isIsUseDefaultProxy() && (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC);
    }

    @Override
    public boolean persistDataToTmpConfig(SVNURL repositoryUrl) throws IOException {
        if (repositoryUrl == null) {
            return false;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
        this.initTmpDir(configuration);
        Proxy proxy = IdeaSvnkitBasedAuthenticationCallback.getIdeaDefinedProxy(repositoryUrl);
        if (proxy != null) {
            IdeaSVNConfigFile.putProxyIntoServersFile(this.myTempDirectory, repositoryUrl.getHost(), proxy);
        }
        return true;
    }

    @Nullable
    public static Proxy getIdeaDefinedProxy(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "getIdeaDefinedProxy"));
        }
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        List proxies = CommonProxy.getInstance().select(URI.create(url.toString()));
        if (proxies != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                return proxy;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PasswordAuthentication getProxyAuthentication(@NotNull SVNURL repositoryUrl) {
        PasswordAuthentication authentication;
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/checkin/IdeaSvnkitBasedAuthenticationCallback", "getProxyAuthentication"));
        }
        Proxy proxy = IdeaSvnkitBasedAuthenticationCallback.getIdeaDefinedProxy(repositoryUrl);
        if (proxy == null) {
            return null;
        }
        if (this.myProxyCredentialsWereReturned) {
            HttpConfigurable instance = HttpConfigurable.getInstance();
            if (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC) {
                PopupUtil.showBalloonForActiveComponent((String)"Failed to authenticate to proxy. You can change proxy credentials in HTTP proxy settings.", (MessageType)MessageType.ERROR);
            } else {
                PopupUtil.showBalloonForActiveComponent((String)"Failed to authenticate to proxy.", (MessageType)MessageType.ERROR);
            }
            return null;
        }
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        try {
            authentication = Authenticator.requestPasswordAuthentication(repositoryUrl.getHost(), address.getAddress(), repositoryUrl.getPort(), repositoryUrl.getProtocol(), repositoryUrl.getHost(), repositoryUrl.getProtocol(), new URL(repositoryUrl.toString()), Authenticator.RequestorType.PROXY);
        }
        catch (MalformedURLException e) {
            LOG.info((Throwable)e);
            return null;
        }
        if (authentication != null) {
            this.myProxyCredentialsWereReturned = true;
        }
        return authentication;
    }

    @Override
    public boolean askProxyCredentials(SVNURL repositoryUrl) {
        if (repositoryUrl == null) {
            return false;
        }
        PasswordAuthentication authentication = this.getProxyAuthentication(repositoryUrl);
        if (authentication != null) {
            try {
                this.initTmpDir(SvnConfiguration.getInstance(this.myVcs.getProject()));
            }
            catch (IOException e) {
                PopupUtil.showBalloonForActiveComponent((String)("Failed to authenticate to proxy: " + e.getMessage()), (MessageType)MessageType.ERROR);
                return false;
            }
            return IdeaSVNConfigFile.putProxyCredentialsIntoServerFile(this.myTempDirectory, repositoryUrl.getHost(), authentication);
        }
        return false;
    }

    @Override
    public void reset() {
        if (this.myTempDirectory != null) {
            FileUtil.delete((File)this.myTempDirectory);
        }
    }

    private void initTmpDir(SvnConfiguration configuration) throws IOException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = FileUtil.createTempDirectory((String)"tmp", (String)"Subversion");
            FileUtil.copyDir((File)new File(configuration.getConfigurationDirectory()), (File)this.myTempDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithSubscribeToAuthProvider(SvnAuthenticationManager.ISVNAuthenticationProviderListener listener, ThrowableRunnable<SVNException> runnable) throws SVNException {
        MessageBusConnection connection = null;
        try {
            Project project = this.myVcs.getProject();
            connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(SvnAuthenticationManager.AUTHENTICATION_PROVIDER_LISTENER, (Object)listener);
            runnable.run();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private boolean storeCredentials(SvnAuthenticationManager manager, SVNAuthentication authentication, String realm) throws SVNException {
        try {
            String kind = this.getFromType(authentication);
            if (!this.acknowledgeSSL(manager, authentication)) {
                manager.acknowledgeAuthentication(true, kind, realm, null, authentication, authentication.getURL());
            }
        }
        catch (SvnAuthenticationManager.CredentialsSavedException e) {
            return e.isSuccess();
        }
        return true;
    }

    private boolean acknowledgeSSL(SvnAuthenticationManager manager, SVNAuthentication svnAuthentication) throws SVNException {
        if (svnAuthentication instanceof SVNSSLAuthentication && ((SVNSSLAuthentication)svnAuthentication).getCertificateFile() != null) {
            manager.acknowledgeForSSL(true, this.getFromType(svnAuthentication), ((SVNSSLAuthentication)svnAuthentication).getCertificateFile().getPath(), null, svnAuthentication);
            manager.acknowledgeAuthentication(true, this.getFromType(svnAuthentication), ((SVNSSLAuthentication)svnAuthentication).getCertificateFile().getPath(), null, svnAuthentication, svnAuthentication.getURL());
            return true;
        }
        return false;
    }

    private static List<String> getKinds(SVNURL url, boolean passwordRequest) {
        if (passwordRequest || "http".equals(url.getProtocol())) {
            return Collections.singletonList("svn.simple");
        }
        if ("https".equals(url.getProtocol())) {
            return Collections.singletonList("svn.ssl.client-passphrase");
        }
        if ("svn".equals(url.getProtocol())) {
            return Collections.singletonList("svn.simple");
        }
        if (url.getProtocol().contains("svn+")) {
            return Arrays.asList("svn.ssh", "svn.username");
        }
        if ("file".equals(url.getProtocol())) {
            return Collections.singletonList("svn.username");
        }
        return Collections.singletonList("svn.username");
    }

    @Override
    @Nullable
    public File getSpecialConfigDir() {
        return this.myTempDirectory != null ? this.myTempDirectory : new File(this.myConfiguration.getConfigurationDirectory());
    }

    private String getFromType(SVNAuthentication authentication) {
        if (authentication instanceof SVNPasswordAuthentication) {
            return "svn.simple";
        }
        if (authentication instanceof SVNSSHAuthentication) {
            return "svn.ssh";
        }
        if (authentication instanceof SVNSSLAuthentication) {
            return "svn.ssl.client-passphrase";
        }
        if (authentication instanceof SVNUserNameAuthentication) {
            return "svn.username";
        }
        throw new IllegalArgumentException();
    }

    private class CredentialsAuthenticator
    extends AbstractAuthenticator<SVNAuthentication> {
        private String myKind;
        private String myRealm;
        private String myRealm2;
        private SVNURL myUrl;
        private SVNAuthentication myAuthentication;

        protected CredentialsAuthenticator(SvnVcs vcs) {
            super(vcs);
        }

        public boolean tryAuthenticate(String realm, SVNURL url, boolean previousFailed, boolean passwordRequest) {
            this.myRealm = realm = realm == null ? url.getHost() : realm;
            this.myUrl = url;
            List kinds = IdeaSvnkitBasedAuthenticationCallback.getKinds(url, passwordRequest);
            Iterator i$ = kinds.iterator();
            while (i$.hasNext()) {
                String kind;
                this.myKind = kind = (String)i$.next();
                if (this.tryAuthenticate()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected SVNAuthentication getWithPassive(SvnAuthenticationManager passive) throws SVNException {
            SVNAuthentication impl = this.getWithPassiveImpl(passive);
            if (impl != null && !this.checkAuthOk(impl)) {
                IdeaSvnkitBasedAuthenticationCallback.this.clearPassiveCredentials(this.myRealm, this.myUrl, impl instanceof SVNPasswordAuthentication);
                return null;
            }
            return impl;
        }

        private SVNAuthentication getWithPassiveImpl(SvnAuthenticationManager passive) throws SVNException {
            try {
                return passive.getFirstAuthentication(this.myKind, this.myRealm, this.myUrl);
            }
            catch (SVNCancelException e) {
                return null;
            }
        }

        private boolean checkAuthOk(SVNAuthentication authentication) {
            if (authentication instanceof SVNPasswordAuthentication && StringUtil.isEmptyOrSpaces((String)authentication.getUserName())) {
                return false;
            }
            return !(authentication instanceof SVNSSLAuthentication) || !StringUtil.isEmptyOrSpaces((String)((SVNSSLAuthentication)authentication).getPassword());
        }

        @Override
        protected SVNAuthentication getWithActive(final SvnAuthenticationManager active) throws SVNException {
            if ("svn.ssl.client-passphrase".equals(this.myKind)) {
                IdeaSvnkitBasedAuthenticationCallback.this.doWithSubscribeToAuthProvider(new SvnAuthenticationManager.ISVNAuthenticationProviderListener(){

                    @Override
                    public void requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored, SVNAuthentication authentication) {
                        if (!CredentialsAuthenticator.this.myUrl.equals((Object)url)) {
                            return;
                        }
                        CredentialsAuthenticator.this.myAuthentication = authentication;
                        CredentialsAuthenticator.this.myRealm2 = realm;
                        CredentialsAuthenticator.this.myStoreInUsual = CredentialsAuthenticator.this.myAuthentication != null && CredentialsAuthenticator.this.myAuthentication.isStorageAllowed();
                    }

                    @Override
                    public void acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored, int accepted) {
                    }
                }, (ThrowableRunnable<SVNException>)((ThrowableRunnable)new ThrowableRunnable<SVNException>(){

                    public void run() throws SVNException {
                        CredentialsAuthenticator.this.myVcs.createWCClient((ISVNAuthenticationManager)active).doInfo(CredentialsAuthenticator.this.myUrl, SVNRevision.UNDEFINED, SVNRevision.HEAD);
                    }
                }));
                if (this.myAuthentication != null) {
                    return this.myAuthentication;
                }
            }
            this.myAuthentication = active.getProvider().requestClientAuthentication(this.myKind, this.myUrl, this.myRealm, null, null, true);
            this.myStoreInUsual = IdeaSvnkitBasedAuthenticationCallback.this.myTempDirectory == null && this.myAuthentication != null && this.myAuthentication.isStorageAllowed();
            return this.myAuthentication;
        }

        @Override
        protected boolean acknowledge(SvnAuthenticationManager manager, SVNAuthentication svnAuthentication) throws SVNException {
            if (!StringUtil.isEmptyOrSpaces((String)this.myRealm2) && !this.myRealm2.equals(this.myRealm)) {
                IdeaSvnkitBasedAuthenticationCallback.this.storeCredentials(manager, svnAuthentication, this.myRealm2);
            }
            return IdeaSvnkitBasedAuthenticationCallback.this.storeCredentials(manager, svnAuthentication, this.myRealm);
        }
    }

    private class SSLServerCertificateAuthenticator
    extends AbstractAuthenticator<Boolean> {
        private SVNURL myUrl;
        private String myRealm;
        private String myCertificateRealm;
        private String myCredentialsRealm;
        private Object myCertificate;
        private int myResult;
        private SVNAuthentication myAuthentication;

        protected SSLServerCertificateAuthenticator(SvnVcs vcs) {
            super(vcs);
        }

        public boolean tryAuthenticate(SVNURL url, String realm) {
            this.myUrl = url;
            this.myRealm = realm;
            this.myResult = 1;
            this.myStoreInUsual = false;
            return this.tryAuthenticate();
        }

        @Override
        protected Boolean getWithPassive(SvnAuthenticationManager passive) throws SVNException {
            String stored = (String)passive.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm);
            if (stored == null) {
                return null;
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                byte[] buffer = new byte[stored.length()];
                SVNBase64.base64ToByteArray((StringBuffer)new StringBuffer(stored), (byte[])buffer);
                this.myCertificate = cf.generateCertificate(new ByteArrayInputStream(buffer));
            }
            catch (CertificateException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (Throwable)e));
            }
            this.myCertificateRealm = this.myRealm;
            return this.myCertificate != null ? Boolean.valueOf(true) : null;
        }

        @Override
        protected Boolean getWithActive(final SvnAuthenticationManager active) throws SVNException {
            IdeaSvnkitBasedAuthenticationCallback.this.doWithSubscribeToAuthProvider(new SvnAuthenticationManager.ISVNAuthenticationProviderListener(){

                @Override
                public void requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored, SVNAuthentication authentication) {
                    if (!SSLServerCertificateAuthenticator.this.myUrl.equals((Object)url)) {
                        return;
                    }
                    SSLServerCertificateAuthenticator.this.myCredentialsRealm = realm;
                    SSLServerCertificateAuthenticator.this.myAuthentication = authentication;
                    if (SSLServerCertificateAuthenticator.this.myAuthentication != null) {
                        SSLServerCertificateAuthenticator.this.myStoreInUsual &= SSLServerCertificateAuthenticator.this.myAuthentication.isStorageAllowed();
                    }
                }

                @Override
                public void acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored, int accepted) {
                    if (!SSLServerCertificateAuthenticator.this.myUrl.equals((Object)url)) {
                        return;
                    }
                    SSLServerCertificateAuthenticator.this.myCertificateRealm = realm;
                    SSLServerCertificateAuthenticator.this.myCertificate = certificate;
                    SSLServerCertificateAuthenticator.this.myResult = accepted;
                }
            }, (ThrowableRunnable<SVNException>)((ThrowableRunnable)new ThrowableRunnable<SVNException>(){

                public void run() throws SVNException {
                    SSLServerCertificateAuthenticator.this.myVcs.createWCClient((ISVNAuthenticationManager)active).doInfo(SSLServerCertificateAuthenticator.this.myUrl, SVNRevision.UNDEFINED, SVNRevision.HEAD);
                }
            }));
            this.myStoreInUsual &= this.myCertificate != null && 2 == this.myResult;
            return 0 != this.myResult && this.myCertificate != null;
        }

        @Override
        protected boolean acknowledge(SvnAuthenticationManager manager, Boolean svnAuthentication) throws SVNException {
            if (this.myCertificate == null) {
                String stored = (String)manager.getRuntimeAuthStorage().getData("svn.ssl.server", this.myRealm);
                if (StringUtil.isEmptyOrSpaces((String)stored)) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"No stored server certificate was found in runtime"));
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    byte[] buffer = new byte[stored.length()];
                    SVNBase64.base64ToByteArray((StringBuffer)new StringBuffer(stored), (byte[])buffer);
                    this.myCertificate = cf.generateCertificate(new ByteArrayInputStream(buffer));
                }
                catch (CertificateException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (Throwable)e));
                }
                this.myCertificateRealm = this.myRealm;
            }
            if (IdeaSvnkitBasedAuthenticationCallback.this.myTempDirectory != null && this.myCertificate != null) {
                String stored;
                if (!(this.myCertificate instanceof X509Certificate)) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)("Can not store server certificate: " + this.myCertificate)));
                }
                X509Certificate x509Certificate = (X509Certificate)this.myCertificate;
                try {
                    stored = SVNBase64.byteArrayToBase64((byte[])x509Certificate.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e));
                }
                int failures = SVNSSLUtil.getServerCertificateFailures((X509Certificate)x509Certificate, (String)this.myUrl.getHost());
                this.storeServerCertificate(IdeaSvnkitBasedAuthenticationCallback.this.myTempDirectory, this.myCertificateRealm, stored, failures);
                if (this.myAuthentication != null) {
                    String realm = this.myCredentialsRealm == null ? this.myCertificateRealm : this.myCredentialsRealm;
                    return IdeaSvnkitBasedAuthenticationCallback.this.storeCredentials(manager, this.myAuthentication, realm);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeServerCertificate(File configDir, String realm, String data, int failures) throws SVNException {
            configDir.mkdirs();
            File file = new File(configDir, "auth/svn.ssl.server/" + SVNFileUtil.computeChecksum((String)realm));
            SVNHashMap map = new SVNHashMap();
            map.put((Object)"ascii_cert", (Object)data);
            map.put((Object)"svn:realmstring", (Object)realm);
            map.put((Object)"failures", (Object)Integer.toString(failures));
            SVNFileUtil.deleteFile((File)file);
            File tmpFile = SVNFileUtil.createUniqueFile((File)configDir, (String)"auth", (String)".tmp", (boolean)true);
            try {
                SVNWCProperties.setProperties((SVNProperties)SVNProperties.wrap((Map)map), (File)file, (File)tmpFile, (String)"END");
            }
            finally {
                SVNFileUtil.deleteFile((File)tmpFile);
            }
        }
    }

    private abstract class AbstractAuthenticator<T> {
        protected final SvnVcs myVcs;
        protected boolean myStoreInUsual;
        protected SvnAuthenticationManager myTmpDirManager;

        protected AbstractAuthenticator(SvnVcs vcs) {
            this.myVcs = vcs;
        }

        protected boolean tryAuthenticate() {
            SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
            SvnAuthenticationManager passive = configuration.getPassiveAuthenticationManager(this.myVcs.getProject());
            SvnAuthenticationManager manager = configuration.getAuthenticationManager(this.myVcs);
            try {
                T svnAuthentication = this.getWithPassive(passive);
                if (svnAuthentication == null) {
                    svnAuthentication = this.getWithActive(manager);
                }
                if (svnAuthentication == null) {
                    return false;
                }
                if (this.myStoreInUsual) {
                    manager.setArtificialSaving(true);
                    return this.acknowledge(manager, svnAuthentication);
                }
                if (this.myTmpDirManager == null) {
                    IdeaSvnkitBasedAuthenticationCallback.this.initTmpDir(configuration);
                    this.myTmpDirManager = this.createTmpManager();
                }
                this.myTmpDirManager.setArtificialSaving(true);
                return this.acknowledge(this.myTmpDirManager, svnAuthentication);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                return false;
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                return false;
            }
        }

        protected SvnAuthenticationManager createTmpManager() {
            SvnAuthenticationManager interactive = new SvnAuthenticationManager(this.myVcs.getProject(), IdeaSvnkitBasedAuthenticationCallback.this.myTempDirectory);
            interactive.setRuntimeStorage(SvnConfiguration.RUNTIME_AUTH_CACHE);
            interactive.setAuthenticationProvider(new SvnInteractiveAuthenticationProvider(this.myVcs, interactive));
            return interactive;
        }

        protected abstract T getWithPassive(SvnAuthenticationManager var1) throws SVNException;

        protected abstract T getWithActive(SvnAuthenticationManager var1) throws SVNException;

        protected abstract boolean acknowledge(SvnAuthenticationManager var1, T var2) throws SVNException;
    }
}

