/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNDirEntryHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "list"));
        }
        this.assertUrl(target);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.list, parameters, null);
        try {
            CmdBrowseClient.parseOutput(target.getURL(), command, handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static void parseOutput(@NotNull SVNURL url, @NotNull CommandExecutor command, @Nullable ISVNDirEntryHandler handler) throws VcsException, SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "parseOutput"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/browse/CmdBrowseClient", "parseOutput"));
        }
        try {
            TargetLists lists = CommandUtil.parse(command.getOutput(), TargetLists.class);
            if (handler != null && lists != null) {
                for (TargetList list : lists.lists) {
                    for (Entry entry : list.entries) {
                        handler.handleDirEntry(entry.toDirEntry(url));
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
    }

    public static class Lock {
        @XmlElement(name="token")
        public String token;
        @XmlElement(name="owner")
        public String owner;
        @XmlElement(name="comment")
        public String comment;
        @XmlElement(name="created")
        public Date created;
        @XmlElement(name="expires")
        public Date expires;

        public SVNLock toLock(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/CmdBrowseClient$Lock", "toLock"));
            }
            return new SVNLock(path, this.token, this.owner, this.comment, this.created, this.expires);
        }
    }

    public static class Commit {
        @XmlAttribute(name="revision")
        public long revision;
        @XmlElement(name="author")
        public String author;
        @XmlElement(name="date")
        public Date date;
    }

    public static class Entry {
        @XmlAttribute(name="kind")
        public String kind;
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="size")
        public long size;
        @XmlElement(name="commit")
        public Commit commit;
        @XmlElement(name="lock")
        public Lock lock;

        public long revision() {
            return this.commit != null ? this.commit.revision : 0L;
        }

        public String author() {
            return this.commit != null ? this.commit.author : "";
        }

        public Date date() {
            return this.commit != null ? this.commit.date : null;
        }

        public SVNDirEntry toDirEntry(@NotNull SVNURL url) throws SVNException {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/browse/CmdBrowseClient$Entry", "toDirEntry"));
            }
            SVNDirEntry entry = new SVNDirEntry(url.appendPath(this.name, false), null, PathUtil.getFileName((String)this.name), SVNNodeKind.parseKind((String)this.kind), this.size, false, this.revision(), this.date(), this.author());
            entry.setRelativePath(this.name);
            entry.setLock(this.lock != null ? this.lock.toLock(entry.getRelativePath()) : null);
            return entry;
        }
    }

    public static class TargetList {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="entry")
        public List<Entry> entries = new ArrayList<Entry>();
    }

    @XmlRootElement(name="lists")
    public static class TargetLists {
        @XmlElement(name="list")
        public List<TargetList> lists = new ArrayList<TargetList>();
    }
}

