/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.CmdAddClient;
import org.jetbrains.idea.svn.annotate.CmdAnnotateClient;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.browse.CmdBrowseClient;
import org.jetbrains.idea.svn.change.CmdChangeListClient;
import org.jetbrains.idea.svn.checkin.CmdImportClient;
import org.jetbrains.idea.svn.checkout.CmdCheckoutClient;
import org.jetbrains.idea.svn.checkout.CmdExportClient;
import org.jetbrains.idea.svn.cleanup.CmdCleanupClient;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineInfoClient;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineStatusClient;
import org.jetbrains.idea.svn.conflict.CmdConflictClient;
import org.jetbrains.idea.svn.content.CmdContentClient;
import org.jetbrains.idea.svn.copy.CmdCopyMoveClient;
import org.jetbrains.idea.svn.delete.CmdDeleteClient;
import org.jetbrains.idea.svn.diff.CmdDiffClient;
import org.jetbrains.idea.svn.history.CmdHistoryClient;
import org.jetbrains.idea.svn.integrate.CmdMergeClient;
import org.jetbrains.idea.svn.lock.CmdLockClient;
import org.jetbrains.idea.svn.properties.CmdPropertyClient;
import org.jetbrains.idea.svn.revert.CmdRevertClient;
import org.jetbrains.idea.svn.update.CmdRelocateClient;
import org.jetbrains.idea.svn.update.CmdUpdateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.CmdUpgradeClient;

public class CmdClientFactory
extends ClientFactory {
    public CmdClientFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/api/CmdClientFactory", "<init>"));
        }
        super(vcs);
    }

    @Override
    protected void setup() {
        this.addClient = new CmdAddClient();
        this.annotateClient = new CmdAnnotateClient();
        this.contentClient = new CmdContentClient();
        this.historyClient = new CmdHistoryClient();
        this.revertClient = new CmdRevertClient();
        this.deleteClient = new CmdDeleteClient();
        this.copyMoveClient = new CmdCopyMoveClient();
        this.conflictClient = new CmdConflictClient();
        this.propertyClient = new CmdPropertyClient();
        this.mergeClient = new CmdMergeClient();
        this.changeListClient = new CmdChangeListClient();
        this.checkoutClient = new CmdCheckoutClient();
        this.myLockClient = new CmdLockClient();
        this.myCleanupClient = new CmdCleanupClient();
        this.myRelocateClient = new CmdRelocateClient();
        this.myVersionClient = new CmdVersionClient();
        this.myImportClient = new CmdImportClient();
        this.myExportClient = new CmdExportClient();
        this.myUpgradeClient = new CmdUpgradeClient();
        this.myBrowseClient = new CmdBrowseClient();
        this.myDiffClient = new CmdDiffClient();
        this.statusClient = new SvnCommandLineStatusClient(this.myVcs);
        this.infoClient = new SvnCommandLineInfoClient(this.myVcs);
    }

    @Override
    @NotNull
    public UpdateClient createUpdateClient() {
        UpdateClient updateClient = this.prepare(new CmdUpdateClient());
        if (updateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/CmdClientFactory", "createUpdateClient"));
        }
        return updateClient;
    }
}

