/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, @Nullable SVNRevision pegRevision, boolean includeMergedRevisions, @Nullable SVNDiffOptions diffOptions, @Nullable ISVNAnnotateHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "annotate"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target.getPathOrUrlString(), pegRevision);
        parameters.add("--revision");
        parameters.add(startRevision + ":" + endRevision);
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        CommandUtil.put(parameters, diffOptions);
        parameters.add("--xml");
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.blame, parameters, null);
        this.parseOutput(command.getOutput(), handler);
    }

    public void parseOutput(@NotNull String output, @Nullable ISVNAnnotateHandler handler) throws VcsException {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/annotate/CmdAnnotateClient", "parseOutput"));
        }
        try {
            BlameInfo info = CommandUtil.parse(output, BlameInfo.class);
            if (handler != null && info != null && info.target != null && info.target.lineEntries != null) {
                for (LineEntry entry : info.target.lineEntries) {
                    CmdAnnotateClient.invokeHandler(handler, entry);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(ISVNAnnotateHandler handler, LineEntry entry) throws SVNException {
        handler.handleLine(entry.date(), entry.revision(), entry.author(), null, entry.mergedDate(), entry.mergedRevision(), entry.mergedAuthor(), entry.mergedPath(), entry.lineNumber - 1);
    }

    public static class MergedEntry {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="commit")
        public CommitEntry commit;
    }

    public static class CommitEntry {
        @XmlAttribute(name="revision")
        public long revision;
        @XmlElement(name="author")
        public String author;
        @XmlElement(name="date")
        public Date date;
    }

    public static class LineEntry {
        @XmlAttribute(name="line-number")
        public int lineNumber;
        @XmlElement(name="commit")
        public CommitEntry commit;
        @XmlElement(name="merged")
        public MergedEntry merged;

        public long revision() {
            return LineEntry.revision(this.commit);
        }

        @Nullable
        public String author() {
            return LineEntry.author(this.commit);
        }

        @Nullable
        public Date date() {
            return LineEntry.date(this.commit);
        }

        @Nullable
        public String mergedPath() {
            return this.merged != null ? this.merged.path : null;
        }

        public long mergedRevision() {
            return this.merged != null ? LineEntry.revision(this.merged.commit) : 0L;
        }

        @Nullable
        public String mergedAuthor() {
            return this.merged != null ? LineEntry.author(this.merged.commit) : null;
        }

        @Nullable
        public Date mergedDate() {
            return this.merged != null ? LineEntry.date(this.merged.commit) : null;
        }

        private static long revision(@Nullable CommitEntry commit) {
            return commit != null ? commit.revision : 0L;
        }

        @Nullable
        private static String author(@Nullable CommitEntry commit) {
            return commit != null ? commit.author : null;
        }

        @Nullable
        private static Date date(@Nullable CommitEntry commit) {
            return commit != null ? commit.date : null;
        }
    }

    public static class TargetEntry {
        @XmlElement(name="entry")
        List<LineEntry> lineEntries;
    }

    @XmlRootElement(name="blame")
    public static class BlameInfo {
        @XmlElement(name="target")
        public TargetEntry target;
    }
}

