/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNDepth;

public class SvnExcludingIgnoredOperation {
    private final Operation myImportAction;
    private final SVNDepth myDepth;
    private final Filter myFilter;

    public SvnExcludingIgnoredOperation(Project project, Operation importAction, SVNDepth depth) {
        this.myImportAction = importAction;
        this.myDepth = depth;
        this.myFilter = new Filter(project);
    }

    private boolean operation(VirtualFile file) throws VcsException {
        if (!this.myFilter.accept(file)) {
            return false;
        }
        this.myImportAction.doOperation(file);
        return true;
    }

    private void executeDown(VirtualFile file) throws VcsException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/SvnExcludingIgnoredOperation$1", "visitFile"));
                }
                try {
                    return SvnExcludingIgnoredOperation.this.operation(file);
                }
                catch (VcsException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, VcsException.class);
    }

    public void execute(VirtualFile file) throws VcsException {
        if (SVNDepth.INFINITY.equals((Object)this.myDepth)) {
            this.executeDown(file);
            return;
        }
        if (!this.operation(file)) {
            return;
        }
        if (SVNDepth.EMPTY.equals((Object)this.myDepth)) {
            return;
        }
        for (VirtualFile child : file.getChildren()) {
            if (SVNDepth.FILES.equals((Object)this.myDepth) && child.isDirectory()) continue;
            this.operation(child);
        }
    }

    public static interface Operation {
        public void doOperation(VirtualFile var1) throws VcsException;
    }

    public static class Filter {
        private final Project myProject;
        private final FileIndexFacade myIndex;
        private final ChangeListManager myClManager;

        public Filter(Project project) {
            this.myProject = project;
            if (!project.isDefault()) {
                this.myIndex = (FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(project, FileIndexFacade.class);
                this.myClManager = ChangeListManager.getInstance((Project)project);
            } else {
                this.myIndex = null;
                this.myClManager = null;
            }
        }

        public boolean accept(VirtualFile file) {
            if (!this.myProject.isDefault()) {
                if (this.isExcluded(file)) {
                    return false;
                }
                if (this.myClManager.isIgnoredFile(file)) {
                    return false;
                }
            }
            return true;
        }

        private boolean isExcluded(final VirtualFile file) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return Filter.this.myIndex.isExcludedFile(file);
                }
            });
        }
    }
}

