/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.SetPropertyDialog;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNPropertyValue;

public class SetPropertyAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.name.set.property", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file == null || project == null || vcs == null) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file);
        return !FileStatus.IGNORED.equals(status) && !FileStatus.UNKNOWN.equals(status);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
        File[] ioFiles = new File[file.length];
        for (int i = 0; i < ioFiles.length; ++i) {
            ioFiles[i] = new File(file[i].getPath());
        }
        SetPropertyDialog dialog = new SetPropertyDialog(project, ioFiles, null, true);
        dialog.show();
        if (dialog.isOK()) {
            int i;
            String name = dialog.getPropertyName();
            String value = dialog.getPropertyValue();
            boolean recursive = dialog.isRecursive();
            for (i = 0; i < ioFiles.length; ++i) {
                File ioFile = ioFiles[i];
                PropertyClient client = activeVcs.getFactory(ioFile).createPropertyClient();
                client.setProperty(ioFile, name, SVNPropertyValue.create((String)value), SVNDepth.fromRecurse((boolean)recursive), false);
            }
            for (i = 0; i < file.length; ++i) {
                if (recursive && file[i].isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file[i], true);
                    continue;
                }
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file[i]);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

