/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.dialogs.CreateBranchOrTagDialog;
import org.jetbrains.idea.svn.update.AutoSvnUpdater;
import org.jetbrains.idea.svn.update.SingleRootSwitcher;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CreateBranchOrTagAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.Subversion.Copy.text", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file == null) {
            return false;
        }
        return SvnStatusUtil.isUnderControl(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(final Project project, final SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        CreateBranchOrTagDialog dialog = new CreateBranchOrTagDialog(project, true, new File(file.getPath()));
        dialog.show();
        if (dialog.isOK()) {
            SVNURL parentUrl;
            SVNURL dstSvnUrl;
            SVNURL srcUrl;
            final String dstURL = dialog.getToURL();
            final SVNRevision revision = dialog.getRevision();
            final String comment = dialog.getComment();
            final Ref exception = new Ref();
            final boolean isSrcFile = dialog.isCopyFromWorkingCopy();
            final File srcFile = new File(dialog.getCopyFromPath());
            try {
                int rc;
                srcUrl = SVNURL.parseURIEncoded((String)dialog.getCopyFromUrl());
                dstSvnUrl = SVNURL.parseURIEncoded((String)dstURL);
                parentUrl = dstSvnUrl.removePathTail();
                if (!CreateBranchOrTagAction.dirExists(activeVcs, project, parentUrl) && (rc = Messages.showYesNoDialog((Project)project, (String)("The repository path '" + parentUrl + "' does not exist. Would you like to create it?"), (String)"Branch or Tag", (Icon)Messages.getQuestionIcon())) == 1) {
                    return;
                }
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            Runnable copyCommand = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                        IdeaCommitHandler handler = null;
                        if (progress != null) {
                            progress.setText(SvnBundle.message("progress.text.copy.to", dstURL));
                            handler = new IdeaCommitHandler(progress);
                        }
                        CreateBranchOrTagAction.checkCreateDir(parentUrl, activeVcs, comment);
                        SvnTarget source = isSrcFile ? SvnTarget.fromFile((File)srcFile, (SVNRevision)revision) : SvnTarget.fromURL((SVNURL)srcUrl, (SVNRevision)revision);
                        long newRevision = activeVcs.getFactory(source).createCopyMoveClient().copy(source, SvnTarget.fromURL((SVNURL)dstSvnUrl), revision, true, comment, handler);
                        CreateBranchOrTagAction.this.updateStatusBar(newRevision, project);
                    }
                    catch (Exception e) {
                        exception.set((Object)e);
                    }
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(copyCommand, SvnBundle.message("progress.title.copy", new Object[0]), false, project);
            if (!exception.isNull()) {
                throw new VcsException((Throwable)exception.get());
            }
            if (dialog.isCopyFromWorkingCopy() && dialog.isSwitchOnCreate()) {
                SingleRootSwitcher switcher = new SingleRootSwitcher(project, VcsUtil.getFilePath((File)srcFile, (boolean)srcFile.isDirectory()), dstSvnUrl.toDecodedString());
                AutoSvnUpdater.run(switcher, SvnBundle.message("action.name.switch", new Object[0]));
            }
        }
    }

    private void updateStatusBar(long revision, Project project) {
        StatusBar statusBar;
        if (revision > 0L && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(SvnBundle.message("status.text.comitted.revision", revision));
        }
    }

    private static void checkCreateDir(@NotNull SVNURL url, @NotNull SvnVcs activeVcs, @NotNull String comment) throws SVNException, VcsException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "checkCreateDir"));
        }
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "checkCreateDir"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "checkCreateDir"));
        }
        SVNURL baseUrl = url;
        ArrayList<SVNURL> dirsToCreate = new ArrayList<SVNURL>();
        while (!CreateBranchOrTagAction.dirExists(activeVcs, activeVcs.getProject(), url)) {
            dirsToCreate.add(0, url);
            if ((url = url.removePathTail()).getPath().length() != 0) continue;
            throw new VcsException("Invalid repository root path for " + baseUrl);
        }
        if (!dirsToCreate.isEmpty()) {
            SVNCommitClient commitClient = activeVcs.createCommitClient();
            commitClient.doMkDir(dirsToCreate.toArray(new SVNURL[dirsToCreate.size()]), comment);
        }
    }

    private static boolean dirExists(final @NotNull SvnVcs vcs, @NotNull Project project, final @NotNull SVNURL url) throws SVNException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "dirExists"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "dirExists"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/actions/CreateBranchOrTagAction", "dirExists"));
        }
        final Ref excRef = new Ref();
        final Ref resultRef = new Ref((Object)Boolean.TRUE);
        Runnable taskImpl = new Runnable(){

            @Override
            public void run() {
                try {
                    vcs.getInfo(url, SVNRevision.HEAD);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode().equals((Object)SVNErrorCode.RA_ILLEGAL_URL)) {
                        resultRef.set((Object)Boolean.FALSE);
                    }
                    excRef.set((Object)e);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(taskImpl, "Checking target folder", true, project);
        } else {
            taskImpl.run();
        }
        if (!excRef.isNull()) {
            throw (SVNException)((Object)excRef.get());
        }
        return (Boolean)resultRef.get();
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

