/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public abstract class AbstractShowPropertiesDiffAction
extends AnAction
implements DumbAware {
    private static final String ourPropertiesDelimiter = "\n";

    protected AbstractShowPropertiesDiffAction(String name) {
        super(name);
    }

    protected abstract DataKey<Change[]> getChangesKey();

    @Nullable
    protected abstract SVNRevision getBeforeRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    @Nullable
    protected abstract SVNRevision getAfterRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Presentation presentation = e.getPresentation();
        Change[] data = (Change[])VcsDataKeys.CHANGES.getData(dataContext);
        boolean showAction = this.checkThatChangesAreUnderSvn(data);
        presentation.setVisible(data != null && showAction);
        presentation.setEnabled(showAction);
    }

    private boolean checkThatChangesAreUnderSvn(Change[] data) {
        boolean showAction = false;
        if (data != null) {
            for (Change change : data) {
                ContentRevision after;
                ContentRevision before = change.getBeforeRevision();
                if (before != null) {
                    boolean bl = showAction = showAction || before instanceof MarkerVcsContentRevision && SvnVcs.getKey().equals((Object)((MarkerVcsContentRevision)before).getVcsKey());
                }
                if ((after = change.getAfterRevision()) != null) {
                    boolean bl = showAction = showAction || after instanceof MarkerVcsContentRevision && SvnVcs.getKey().equals((Object)((MarkerVcsContentRevision)after).getVcsKey());
                }
                if (showAction) break;
            }
        }
        return showAction;
    }

    private boolean enabled(Project project, Change[] changes) {
        ContentRevision revision;
        boolean noChange;
        boolean bl = noChange = project == null || changes == null || changes.length != 1;
        if (noChange) {
            return false;
        }
        Change change = changes[0];
        ContentRevision contentRevision = revision = change.getBeforeRevision() != null ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null || !(revision.getRevisionNumber() instanceof SvnRevisionNumber)) {
            return false;
        }
        return this.checkVcs(project, change);
    }

    protected boolean checkVcs(Project project, Change change) {
        VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)virtualFile, (Project)project);
        return vcs != null && "svn".equals(vcs.getName());
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Change[] changes = (Change[])e.getData(this.getChangesKey());
        if (!this.checkThatChangesAreUnderSvn(changes)) {
            return;
        }
        Change change = changes[0];
        CalculateAndShow worker = new CalculateAndShow(project, change, e.getPresentation().getText());
        ProgressManager.getInstance().run((Task)worker);
    }

    private String getDiffWindowTitle(Change change) {
        if (change.isMoved() || change.isRenamed()) {
            FilePath beforeFilePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterFilePath = ChangesUtil.getAfterPath((Change)change);
            String beforePath = beforeFilePath == null ? "" : beforeFilePath.getIOFile().getAbsolutePath();
            String afterPath = afterFilePath == null ? "" : afterFilePath.getIOFile().getAbsolutePath();
            return SvnBundle.message("action.Subversion.properties.difference.diff.for.move.title", beforePath, afterPath);
        }
        return SvnBundle.message("action.Subversion.properties.difference.diff.title", ChangesUtil.getFilePath((Change)change).getIOFile().getAbsolutePath());
    }

    private int compareRevisions(@NonNls SVNRevision revision1, @NonNls SVNRevision revision2) {
        if (revision1.equals((Object)revision2)) {
            return 0;
        }
        if (SVNRevision.WORKING.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.WORKING.equals((Object)revision2)) {
            return -1;
        }
        if (SVNRevision.HEAD.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.HEAD.equals((Object)revision2)) {
            return -1;
        }
        return revision1.getNumber() > revision2.getNumber() ? 1 : -1;
    }

    private String revisionToString(SVNRevision revision) {
        if (revision == null) {
            return "not exists";
        }
        return revision.toString();
    }

    private static String getPropertyList(@NotNull SvnVcs vcs, @Nullable ContentRevision contentRevision, @Nullable SVNRevision revision) throws SVNException, VcsException {
        SvnTarget target;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (contentRevision == null) {
            return "";
        }
        if (contentRevision instanceof SvnRepositoryContentRevision) {
            SvnRepositoryContentRevision svnRevision = (SvnRepositoryContentRevision)contentRevision;
            target = SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)svnRevision.getFullPath()), (SVNRevision)revision);
        } else {
            File ioFile = contentRevision.getFile().getIOFile();
            target = SvnTarget.fromFile((File)ioFile, (SVNRevision)revision);
        }
        return AbstractShowPropertiesDiffAction.getPropertyList(vcs, target, revision);
    }

    public static String getPropertyList(@NotNull SvnVcs vcs, @NotNull SVNURL url, @Nullable SVNRevision revision) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        return AbstractShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromURL((SVNURL)url, (SVNRevision)revision), revision);
    }

    public static String getPropertyList(@NotNull SvnVcs vcs, @NotNull File ioFile, @Nullable SVNRevision revision) throws SVNException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        try {
            return AbstractShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromFile((File)ioFile, (SVNRevision)revision), revision);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (Throwable)e), (Throwable)e);
        }
    }

    private static String getPropertyList(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        ArrayList<SVNPropertyData> lines = new ArrayList<SVNPropertyData>();
        ISVNPropertyHandler propertyHandler = AbstractShowPropertiesDiffAction.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, SVNDepth.EMPTY, propertyHandler);
        return AbstractShowPropertiesDiffAction.toSortedStringPresentation(lines);
    }

    private static ISVNPropertyHandler createHandler(SVNRevision revision, final List<SVNPropertyData> lines) {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        return new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }

            private void registerProperty(@NotNull SVNPropertyData property) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction$1", "registerProperty"));
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }
        };
    }

    private static String toSortedStringPresentation(List<SVNPropertyData> lines) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(lines, new Comparator<SVNPropertyData>(){

            @Override
            public int compare(SVNPropertyData o1, SVNPropertyData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (SVNPropertyData line : lines) {
            AbstractShowPropertiesDiffAction.addPropertyPresentation(line, sb);
        }
        return sb.toString();
    }

    private static void addPropertyPresentation(SVNPropertyData property, StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(property.getValue() == null ? "" : SVNPropertyValue.getPropertyAsString((SVNPropertyValue)property.getValue()));
    }

    private class CalculateAndShow
    extends Task.Backgroundable {
        private final Change myChange;
        private String myBeforeContent;
        private String myAfterContent;
        private SVNRevision myBeforeRevisionValue;
        private SVNRevision myAfterRevision;
        private Exception myException;
        private final String myErrorTitle;

        private CalculateAndShow(Project project, Change change, String errorTitle) {
            super(project, SvnBundle.message("fetching.properties.contents.progress.title", new Object[0]), true, Task.Backgroundable.DEAF);
            this.myChange = change;
            this.myErrorTitle = errorTitle;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction$CalculateAndShow", "run"));
            }
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            try {
                this.myBeforeRevisionValue = AbstractShowPropertiesDiffAction.this.getBeforeRevisionValue(this.myChange, vcs);
                this.myAfterRevision = AbstractShowPropertiesDiffAction.this.getAfterRevisionValue(this.myChange, vcs);
                this.myBeforeContent = AbstractShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getBeforeRevision(), this.myBeforeRevisionValue);
                indicator.checkCanceled();
                this.myAfterContent = AbstractShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getAfterRevision(), this.myAfterRevision);
            }
            catch (SVNException exc) {
                this.myException = exc;
            }
            catch (VcsException exc) {
                this.myException = exc;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CalculateAndShow.this.myException != null) {
                        Messages.showErrorDialog((String)CalculateAndShow.this.myException.getMessage(), (String)CalculateAndShow.this.myErrorTitle);
                        return;
                    }
                    if (CalculateAndShow.this.myBeforeContent != null && CalculateAndShow.this.myAfterContent != null && CalculateAndShow.this.myBeforeRevisionValue != null && CalculateAndShow.this.myAfterRevision != null) {
                        SimpleDiffRequest diffRequest = new SimpleDiffRequest(CalculateAndShow.this.myProject, AbstractShowPropertiesDiffAction.this.getDiffWindowTitle(CalculateAndShow.this.myChange));
                        if (AbstractShowPropertiesDiffAction.this.compareRevisions(CalculateAndShow.this.myBeforeRevisionValue, CalculateAndShow.this.myAfterRevision) >= 0) {
                            diffRequest.setContents((DiffContent)new SimpleContent(CalculateAndShow.this.myAfterContent), (DiffContent)new SimpleContent(CalculateAndShow.this.myBeforeContent));
                            diffRequest.setContentTitles(AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myAfterRevision), AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myBeforeRevisionValue));
                        } else {
                            diffRequest.setContents((DiffContent)new SimpleContent(CalculateAndShow.this.myBeforeContent), (DiffContent)new SimpleContent(CalculateAndShow.this.myAfterContent));
                            diffRequest.setContentTitles(AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myBeforeRevisionValue), AbstractShowPropertiesDiffAction.this.revisionToString(CalculateAndShow.this.myAfterRevision));
                        }
                        DiffManager.getInstance().getDiffTool().show((DiffRequest)diffRequest);
                    }
                }
            });
        }
    }
}

