/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.idea.RareLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NativeLogReader;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SSLExceptionsHelper;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopiesRefreshManager;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnHttpAuthMethodsDefaultChecker;
import org.jetbrains.idea.svn.SvnLoadedBrachesStorage;
import org.jetbrains.idea.svn.SvnNativeLogParser;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffWithLocalAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdClientFactory;
import org.jetbrains.idea.svn.api.SvnKitClientFactory;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnExecutableChecker;
import org.jetbrains.idea.svn.dialogs.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.lowLevel.PrimitivePool;
import org.jetbrains.idea.svn.networking.SSLProtocolExceptionParser;
import org.jetbrains.idea.svn.portable.SvnWcClientI;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnVcs
extends AbstractVcs<CommittedChangeList> {
    private static final String DO_NOT_LISTEN_TO_WC_DB = "svn.do.not.listen.to.wc.db";
    private static final String KEEP_CONNECTIONS_KEY = "svn.keep.connections";
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    public static boolean ourListenToWcDb = true;
    private static final int ourLogUsualInterval = 20000;
    private static final int ourLogRareInterval = 30000;
    private static final Set<SVNErrorCode> ourLogRarely = new HashSet<SVNErrorCode>(Arrays.asList(SVNErrorCode.WC_UNSUPPORTED_FORMAT, SVNErrorCode.WC_CORRUPT, SVNErrorCode.WC_CORRUPT_TEXT_BASE, SVNErrorCode.WC_NOT_FILE, SVNErrorCode.WC_NOT_DIRECTORY, SVNErrorCode.WC_PATH_NOT_FOUND));
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance((String)"org.jetbrains.idea.svn.SvnVcs"));
    @NonNls
    public static final String VCS_NAME = "svn";
    public static final String VCS_DISPLAY_NAME = "Subversion";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    private final Map<String, Map<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>>> myPropertyCache = new SoftHashMap();
    private final SvnConfiguration myConfiguration;
    private final SvnEntriesFileListener myEntriesFileListener;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private VcsHistoryProvider mySvnHistoryProvider;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final WorkingCopiesContent myWorkingCopiesContent;
    @NonNls
    public static final String LOG_PARAMETER_NAME = "javasvn.log";
    @NonNls
    public static final String TRACE_NATIVE_CALLS = "javasvn.log.native";
    public static final String pathToEntries = SvnUtil.SVN_ADMIN_DIR_NAME + File.separatorChar + "entries";
    public static final String pathToDirProps = SvnUtil.SVN_ADMIN_DIR_NAME + File.separatorChar + "dir-props";
    private final SvnChangelistListener myChangeListListener;
    private SvnCopiesRefreshManager myCopiesRefreshManager;
    private SvnFileUrlMappingImpl myMapping;
    private final MyFrameStateListener myFrameStateListener;
    public static final Topic<Consumer> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Consumer.class);
    private VcsListener myVcsListener;
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final SvnAuthenticationNotifier myAuthNotifier;
    private static RareLogger.LogFilter[] ourLogFilters;
    private final SvnLoadedBrachesStorage myLoadedBranchesStorage;
    public static final String SVNKIT_HTTP_SSL_PROTOCOLS = "svnkit.http.sslProtocols";
    private static boolean ourSSLProtocolsExplicitlySet;
    private final SvnExecutableChecker myChecker;
    public static final Processor<Exception> ourBusyExceptionProcessor;
    private SvnCheckoutProvider myCheckoutProvider;
    @NotNull
    private final ClientFactory cmdClientFactory = new CmdClientFactory(this);
    @NotNull
    private final ClientFactory svnKitClientFactory = new SvnKitClientFactory(this);
    private final boolean myLogExceptions;

    public static boolean isSSLProtocolExplicitlySet() {
        return ourSSLProtocolsExplicitlySet;
    }

    public SvnVcs(Project project, MessageBus bus, SvnConfiguration svnConfiguration, SvnLoadedBrachesStorage storage) {
        super(project, VCS_NAME);
        this.myLoadedBranchesStorage = storage;
        this.myRootsToWorkingCopies = new RootsToWorkingCopies(this);
        this.myConfiguration = svnConfiguration;
        this.myAuthNotifier = new SvnAuthenticationNotifier(this);
        this.dumpFileStatus(FileStatus.ADDED);
        this.dumpFileStatus(FileStatus.DELETED);
        this.dumpFileStatus(FileStatus.MERGE);
        this.dumpFileStatus(FileStatus.MODIFIED);
        this.dumpFileStatus(FileStatus.NOT_CHANGED);
        this.dumpFileStatus(FileStatus.UNKNOWN);
        this.dumpFileStatus(SvnFileStatus.REPLACED);
        this.dumpFileStatus(SvnFileStatus.EXTERNAL);
        this.dumpFileStatus(SvnFileStatus.OBSTRUCTED);
        this.refreshSSLProperty();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
            this.myEntriesFileListener = null;
        } else {
            this.myEntriesFileListener = new SvnEntriesFileListener(project);
            this.upgradeIfNeeded(bus);
            this.myChangeListListener = new SvnChangelistListener(this.myProject, this);
            this.myVcsListener = new VcsListener(){

                public void directoryMappingChanged() {
                    SvnVcs.this.invokeRefreshSvnRoots();
                }
            };
        }
        this.myFrameStateListener = project.isDefault() ? null : new MyFrameStateListener(ChangeListManager.getInstance((Project)project), VcsDirtyScopeManager.getInstance((Project)project));
        this.myWorkingCopiesContent = new WorkingCopiesContent(this);
        this.correctNotificationIds();
        this.myChecker = new SvnExecutableChecker(this.myProject);
        Application app = ApplicationManager.getApplication();
        this.myLogExceptions = app != null && (app.isInternal() || app.isUnitTestMode());
    }

    private void correctNotificationIds() {
        boolean notEmpty;
        boolean bl = notEmpty = NotificationsConfigurationImpl.getNotificationsConfigurationImpl().isRegistered("SVN_NO_JNA") || NotificationsConfigurationImpl.getNotificationsConfigurationImpl().isRegistered("SVN_NO_CRYPT32") || NotificationsConfigurationImpl.getNotificationsConfigurationImpl().isRegistered("SubversionId");
        if (notEmpty) {
            NotificationsConfigurationImpl.remove((String[])new String[]{"SVN_NO_JNA", "SVN_NO_CRYPT32", "SubversionId"});
            NotificationsConfiguration.getNotificationsConfiguration().register(this.getDisplayName(), NotificationDisplayType.BALLOON);
        }
    }

    public void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myCopiesRefreshManager = new SvnCopiesRefreshManager((SvnFileUrlMappingImpl)this.getSvnFileUrlMapping());
        if (!this.myConfiguration.isCleanupRun()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnVcs.this.cleanup17copies();
                    SvnVcs.this.myConfiguration.setCleanupRun(true);
                }
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.invokeRefreshSvnRoots();
        }
        this.myWorkingCopiesContent.activate();
    }

    private void cleanup17copies() {
        final Runnable callCleanupWorker = new Runnable(){

            @Override
            public void run() {
                if (SvnVcs.this.myProject.isDisposed()) {
                    return;
                }
                new CleanupWorker(new VirtualFile[0], SvnVcs.this.myProject, "action.Subversion.cleanup.progress.title"){

                    @Override
                    protected void chanceToFillRoots() {
                        List<WCInfo> infos = SvnVcs.this.getAllWcInfos();
                        LocalFileSystem lfs = LocalFileSystem.getInstance();
                        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(infos.size());
                        for (WCInfo info : infos) {
                            if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat())) continue;
                            VirtualFile file = lfs.refreshAndFindFileByIoFile(new File(info.getPath()));
                            if (file == null) {
                                LOG.info("Wasn't able to find virtual file for wc root: " + info.getPath());
                                continue;
                            }
                            roots.add(file);
                        }
                        this.myRoots = roots.toArray(new VirtualFile[roots.size()]);
                    }
                }.execute();
            }
        };
        this.myCopiesRefreshManager.waitRefresh(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(callCleanupWorker, ModalityState.any());
            }
        });
    }

    public boolean checkCommandLineVersion() {
        boolean isValid = true;
        if (!this.isProject16() && (this.myConfiguration.isCommandLine() || this.isProject18())) {
            isValid = this.myChecker.checkExecutableAndNotifyIfNeeded();
        }
        return isValid;
    }

    public void invokeRefreshSvnRoots() {
        if (REFRESH_LOG.isDebugEnabled()) {
            REFRESH_LOG.debug("refresh: ", new Throwable());
        }
        if (this.myCopiesRefreshManager != null) {
            this.myCopiesRefreshManager.asynchRequest();
        }
    }

    public boolean checkImmediateParentsBeforeCommit() {
        return true;
    }

    private void upgradeIfNeeded(MessageBus bus) {
        final MessageBusConnection connection = bus.connect();
        connection.subscribe(ChangeListManagerImpl.LISTS_LOADED, (Object)new LocalChangeListsLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processLoadedLists(List<LocalChangeList> lists) {
                if (lists.isEmpty()) {
                    return;
                }
                try {
                    ChangeListManager.getInstance((Project)SvnVcs.this.myProject).setReadOnly(SvnChangeProvider.ourDefaultListName, true);
                    if (!SvnVcs.this.myConfiguration.changeListsSynchronized()) {
                        SvnVcs.this.processChangeLists(lists);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    SvnVcs.this.myConfiguration.upgrade();
                }
                connection.disconnect();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeLists(List<LocalChangeList> lists) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject);
        plVcsManager.startBackgroundVcsOperation();
        try {
            for (LocalChangeList list : lists) {
                if (list.isDefault()) continue;
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    this.correctListForRevision(plVcsManager, change.getBeforeRevision(), list.getName());
                    this.correctListForRevision(plVcsManager, change.getAfterRevision(), list.getName());
                }
            }
        }
        catch (Throwable throwable) {
            Application appManager = ApplicationManager.getApplication();
            if (appManager.isDispatchThread()) {
                appManager.executeOnPooledThread(new Runnable(plVcsManager){
                    final /* synthetic */ ProjectLevelVcsManager val$plVcsManager;
                    {
                        this.val$plVcsManager = projectLevelVcsManager;
                    }

                    @Override
                    public void run() {
                        this.val$plVcsManager.stopBackgroundVcsOperation();
                    }
                });
            } else {
                plVcsManager.stopBackgroundVcsOperation();
            }
            throw throwable;
        }
        Application appManager = ApplicationManager.getApplication();
        if (appManager.isDispatchThread()) {
            appManager.executeOnPooledThread(new /* invalid duplicate definition of identical inner class */);
        } else {
            plVcsManager.stopBackgroundVcsOperation();
        }
    }

    private void correctListForRevision(@NotNull ProjectLevelVcsManager plVcsManager, @Nullable ContentRevision revision, @NotNull String name) {
        FilePath path;
        AbstractVcs vcs;
        if (plVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "correctListForRevision"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/SvnVcs", "correctListForRevision"));
        }
        if (revision != null && (vcs = plVcsManager.getVcsFor(path = revision.getFile())) != null && VCS_NAME.equals(vcs.getName())) {
            try {
                this.getFactory(path.getIOFile()).createChangeListClient().add(name, path.getIOFile(), null);
            }
            catch (VcsException e) {
                // empty catch block
            }
        }
    }

    public void activate() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangeListListener);
            vcsManager.addVcsListener(this.myVcsListener);
        }
        SvnApplicationSettings.getInstance().svnActivated();
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        LoadedRevisionsCache.getInstance(this.myProject);
        FrameStateManager.getInstance().addListener((FrameStateListener)this.myFrameStateListener);
        this.myAuthNotifier.init();
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this.myProject);
        this.mySvnBranchPointsCalculator.activate();
        if (SystemInfo.isWindows) {
            if (!SVNJNAUtil.isJNAPresent()) {
                Notifications.Bus.notify((Notification)new Notification(this.getDisplayName(), "Subversion plugin: no JNA", "A problem with JNA initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            } else if (!SVNJNAUtil.isWinCryptEnabled()) {
                Notifications.Bus.notify((Notification)new Notification(this.getDisplayName(), "Subversion plugin: no encryption", "A problem with encryption module (Crypt32.dll) initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            }
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.checkCommandLineVersion();
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                SvnVcs.this.postStartup();
            }
        });
        vcsManager.addVcsListener((VcsListener)this.myRootsToWorkingCopies);
        this.myLoadedBranchesStorage.activate();
    }

    private static void initLogFilters() {
        if (ourLogFilters != null) {
            return;
        }
        ourLogFilters = new RareLogger.LogFilter[]{new RareLogger.LogFilter(){

            public Object getKey(@NotNull org.apache.log4j.Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
                if (level == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs$9", "getKey"));
                }
                SVNException svnExc = null;
                if (t instanceof SVNException) {
                    svnExc = (SVNException)t;
                } else if (t instanceof VcsException && t.getCause() instanceof SVNException) {
                    svnExc = (SVNException)t.getCause();
                }
                if (svnExc != null && ourLogRarely.contains(svnExc.getErrorMessage().getErrorCode())) {
                    return svnExc.getErrorMessage().getErrorCode();
                }
                return null;
            }

            @NotNull
            public Integer getAllowedLoggingInterval(org.apache.log4j.Level level, String message, Throwable t, String[] details) {
                SVNException svnExc = null;
                if (t instanceof SVNException) {
                    svnExc = (SVNException)t;
                } else if (t instanceof VcsException && t.getCause() instanceof SVNException) {
                    svnExc = (SVNException)t.getCause();
                }
                if (svnExc != null) {
                    if (ourLogRarely.contains(svnExc.getErrorMessage().getErrorCode())) {
                        Integer n = 30000;
                        if (n == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs$9", "getAllowedLoggingInterval"));
                        }
                        return n;
                    }
                    Integer n = 20000;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs$9", "getAllowedLoggingInterval"));
                    }
                    return n;
                }
                Integer n = 0;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs$9", "getAllowedLoggingInterval"));
                }
                return n;
            }
        }};
    }

    public static Logger wrapLogger(Logger logger) {
        SvnVcs.initLogFilters();
        return RareLogger.wrap((Logger)logger, (boolean)Boolean.getBoolean("svn.logger.fairsynch"), (RareLogger.LogFilter[])ourLogFilters);
    }

    public RootsToWorkingCopies getRootsToWorkingCopies() {
        return this.myRootsToWorkingCopies;
    }

    public SvnAuthenticationNotifier getAuthNotifier() {
        return this.myAuthNotifier;
    }

    public void deactivate() {
        FrameStateManager.getInstance().removeListener((FrameStateListener)this.myFrameStateListener);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.myVcsListener != null) {
            vcsManager.removeVcsListener(this.myVcsListener);
        }
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        SvnApplicationSettings.getInstance().svnDeactivated();
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        if (this.myChangeListListener != null && !this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangeListListener);
        }
        vcsManager.removeVcsListener((VcsListener)this.myRootsToWorkingCopies);
        this.myRootsToWorkingCopies.clear();
        this.myAuthNotifier.stop();
        this.myAuthNotifier.clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        this.myWorkingCopiesContent.deactivate();
        this.myLoadedBranchesStorage.deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        ChangeProvider changeProvider = this.myChangeProvider;
        if (changeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getChangeProvider"));
        }
        return changeProvider;
    }

    public SVNRepository createRepository(String url) throws SVNException {
        SVNRepository repos = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
        repos.setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        repos.setTunnelProvider((ISVNTunnelProvider)this.myConfiguration.getOptions(this.myProject));
        return repos;
    }

    public SVNRepository createRepository(SVNURL url) throws SVNException {
        SVNRepository repos = SVNRepositoryFactory.create((SVNURL)url);
        repos.setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        repos.setTunnelProvider((ISVNTunnelProvider)this.myConfiguration.getOptions(this.myProject));
        return repos;
    }

    @NotNull
    private ISVNRepositoryPool getPool() {
        ISVNRepositoryPool iSVNRepositoryPool = this.getPool((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        if (iSVNRepositoryPool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getPool"));
        }
        return iSVNRepositoryPool;
    }

    @NotNull
    private ISVNRepositoryPool getPool(ISVNAuthenticationManager manager) {
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PrimitivePool primitivePool = new PrimitivePool(manager, (ISVNTunnelProvider)this.myConfiguration.getOptions(this.myProject));
        if (primitivePool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getPool"));
        }
        return primitivePool;
    }

    public SVNUpdateClient createUpdateClient() {
        SVNUpdateClient client = new SVNUpdateClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNUpdateClient createUpdateClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "createUpdateClient"));
        }
        SVNUpdateClient client = new SVNUpdateClient(this.getPool(manager), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager(manager);
        return client;
    }

    public SVNStatusClient createStatusClient() {
        SVNStatusClient client = new SVNStatusClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        client.setIgnoreExternals(false);
        return client;
    }

    public SVNWCClient createWCClient() {
        SVNWCClient client = new SVNWCClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNWCClient createWCClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "createWCClient"));
        }
        SVNWCClient client = new SVNWCClient(this.getPool(manager), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager(manager);
        return client;
    }

    public SVNCopyClient createCopyClient() {
        SVNCopyClient client = new SVNCopyClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNMoveClient createMoveClient() {
        SVNMoveClient client = new SVNMoveClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNLogClient createLogClient() {
        SVNLogClient client = new SVNLogClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNLogClient createLogClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "createLogClient"));
        }
        SVNLogClient client = new SVNLogClient(this.getPool(manager), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager(manager);
        return client;
    }

    public SVNCommitClient createCommitClient() {
        SVNCommitClient client = new SVNCommitClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNDiffClient createDiffClient() {
        SVNDiffClient client = new SVNDiffClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public SVNChangelistClient createChangelistClient() {
        SVNChangelistClient client = new SVNChangelistClient(this.getPool(), this.myConfiguration.getOptions(this.myProject));
        client.getOperationsFactory().setAuthenticationManager((ISVNAuthenticationManager)this.myConfiguration.getAuthenticationManager(this));
        return client;
    }

    public ISVNOptions getSvnOptions() {
        return this.myConfiguration.getOptions(this.myProject);
    }

    public ISVNAuthenticationManager getSvnAuthenticationManager() {
        return this.myConfiguration.getAuthenticationManager(this);
    }

    void dumpFileStatus(FileStatus fs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("FileStatus:" + fs.getText() + " " + fs.getColor() + " " + " " + fs.getClass().getName());
        }
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    public String getDisplayName() {
        LOG.debug("getDisplayName");
        return VCS_DISPLAY_NAME;
    }

    public Configurable getConfigurable() {
        LOG.debug("createConfigurable");
        return new SvnConfigurable(this.myProject);
    }

    public SvnConfiguration getSvnConfiguration() {
        return this.myConfiguration;
    }

    public static SvnVcs getInstance(Project project) {
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "createCheckinEnvironment"));
        }
        return checkinEnvironment;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "createRollbackEnvironment"));
        }
        return rollbackEnvironment;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return this.myAnnotationProvider;
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    private static Trinity<Long, Long, Long> getTimestampForPropertiesChange(File ioFile, boolean isDir) {
        File dir = isDir ? ioFile : ioFile.getParentFile();
        String relPath = SVNAdminUtil.getPropPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathBase = SVNAdminUtil.getPropBasePath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathRevert = SVNAdminUtil.getPropRevertPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        return new Trinity((Object)new File(dir, relPath).lastModified(), (Object)new File(dir, relPathBase).lastModified(), (Object)new File(dir, relPathRevert).lastModified());
    }

    private static boolean trinitiesEqual(Trinity<Long, Long, Long> t1, Trinity<Long, Long, Long> t2) {
        if ((Long)t2.first == 0L && (Long)t2.second == 0L && (Long)t2.third == 0L) {
            return false;
        }
        return t1.equals(t2);
    }

    @Nullable
    public SVNPropertyValue getPropertyWithCaching(VirtualFile file, String propName) throws VcsException {
        SVNPropertyValue propValue;
        Map<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>> cachedMap = this.myPropertyCache.get(SvnVcs.keyForVf(file));
        Pair<SVNPropertyValue, Trinity<Long, Long, Long>> cachedValue = cachedMap == null ? null : cachedMap.get(propName);
        File ioFile = new File(file.getPath());
        Trinity<Long, Long, Long> tsTrinity = SvnVcs.getTimestampForPropertiesChange(ioFile, file.isDirectory());
        if (cachedValue != null && SvnVcs.trinitiesEqual((Trinity<Long, Long, Long>)((Trinity)cachedValue.getSecond()), tsTrinity)) {
            return (SVNPropertyValue)cachedValue.getFirst();
        }
        PropertyClient client = this.getFactory(ioFile).createPropertyClient();
        SVNPropertyData value = client.getProperty(SvnTarget.fromFile((File)ioFile, (SVNRevision)SVNRevision.WORKING), propName, false, SVNRevision.WORKING);
        SVNPropertyValue sVNPropertyValue = propValue = value == null ? null : value.getValue();
        if (cachedMap == null) {
            cachedMap = new HashMap<String, Pair<SVNPropertyValue, Trinity<Long, Long, Long>>>();
            this.myPropertyCache.put(SvnVcs.keyForVf(file), cachedMap);
        }
        cachedMap.put(propName, (Pair<SVNPropertyValue, Trinity<Long, Long, Long>>)new Pair((Object)propValue, tsTrinity));
        return propValue;
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            SVNStatus status = this.getFactory(file).createStatusClient().doStatus(file, false);
            if (status != null) {
                if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_ADDED)) {
                    return status.isCopied();
                }
                return !SvnVcs.svnStatusIsUnversioned(status) && !SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_IGNORED) && !SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_OBSTRUCTED);
            }
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
        }
        return false;
    }

    public static boolean svnStatusIsUnversioned(SVNStatus status) {
        return SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_UNVERSIONED);
    }

    public static boolean svnStatusIs(SVNStatus status, @NotNull SVNStatusType value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnVcs", "svnStatusIs"));
        }
        return value.equals(status.getNodeStatus()) || value.equals(status.getContentsStatus());
    }

    public boolean fileIsUnderVcs(FilePath path) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        VirtualFile file = path.getVirtualFile();
        if (file == null) {
            return false;
        }
        return !SvnStatusUtil.isIgnoredInAnySense(clManager, file) && !clManager.isUnversioned(file);
    }

    private static File getEntriesFile(File file) {
        return file.isDirectory() ? new File(file, pathToEntries) : new File(file.getParentFile(), pathToEntries);
    }

    private static File getDirPropsFile(File file) {
        return new File(file, pathToDirProps);
    }

    @Nullable
    public SVNInfo getInfo(@NotNull SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getFactory().createInfoClient().doInfo(url, pegRevision, revision);
    }

    @Nullable
    public SVNInfo getInfo(@NotNull SVNURL url, SVNRevision revision) throws SVNException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(url, SVNRevision.UNDEFINED, revision);
    }

    @Nullable
    public SVNInfo getInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(new File(file.getPath()));
    }

    @Nullable
    public SVNInfo getInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(new File(path));
    }

    @Nullable
    public SVNInfo getInfo(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        SVNInfo result = null;
        SvnWcClientI client = this.getFactory(ioFile).createInfoClient();
        try {
            SVNInfo localInfo = result = client.doInfo(ioFile, SVNRevision.UNDEFINED);
            if (result == null || result.getRepositoryRootURL() == null) {
                LOG.info("Failed to get local info for " + ioFile + ". Trying to get HEAD info.");
                result = client.doInfo(ioFile, SVNRevision.HEAD);
                if (result != null) {
                    LOG.info("Local info was " + localInfo + ", HEAD info was " + result);
                }
            }
        }
        catch (SVNException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    public void collectInfo(@NotNull Collection<File> files, @Nullable ISVNInfoHandler handler) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "collectInfo"));
        }
        File first = (File)ContainerUtil.getFirstItem(files);
        if (first != null) {
            ClientFactory factory = this.getFactory(first);
            try {
                if (factory instanceof CmdClientFactory) {
                    factory.createInfoClient().doInfo(files, handler);
                } else {
                    for (File file : files) {
                        SVNInfo info = this.getInfo(file);
                        if (handler == null) continue;
                        handler.handleInfo(info);
                    }
                }
            }
            catch (SVNException e) {
                this.handleInfoException(e);
            }
        }
    }

    @Nullable
    public SVNInfo getInfo(@NotNull File ioFile, @NotNull SVNRevision revision) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        SVNInfo result = null;
        try {
            result = this.getFactory(ioFile).createInfoClient().doInfo(ioFile, revision);
        }
        catch (SVNException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    private void handleInfoException(SVNException e) {
        SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
        if (!this.myLogExceptions || SvnUtil.isUnversionedOrNotFound(errorCode) || SVNErrorCode.WC_UNSUPPORTED_FORMAT.equals((Object)errorCode) || SVNErrorCode.WC_UPGRADE_REQUIRED.equals((Object)errorCode)) {
            LOG.debug((Throwable)e);
        } else {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        WorkingCopyFormat workingCopyFormat = this.getWorkingCopyFormat(ioFile, true);
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile, boolean useMapping) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        WorkingCopyFormat format = WorkingCopyFormat.UNKNOWN;
        if (useMapping) {
            RootUrlInfo rootInfo = this.getSvnFileUrlMapping().getWcRootForFilePath(ioFile);
            format = rootInfo != null ? rootInfo.getFormat() : WorkingCopyFormat.UNKNOWN;
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.findRootAndGetFormat(ioFile) : format;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    public void refreshSSLProperty() {
        if (ourSSLProtocolsExplicitlySet) {
            return;
        }
        if (SvnConfiguration.SSLProtocols.all.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.clearProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
        } else if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "SSLv3");
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "TLSv1");
        }
    }

    public boolean isWcRoot(FilePath filePath) {
        boolean isWcRoot = false;
        WorkingCopy wcRoot = this.myRootsToWorkingCopies.getWcRoot(filePath.getVirtualFile());
        if (wcRoot != null) {
            isWcRoot = wcRoot.getFile().getAbsolutePath().equals(filePath.getIOFile().getAbsolutePath());
        }
        return isWcRoot;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this.myProject);
        }
        SvnCommittedChangesProvider svnCommittedChangesProvider = this.myCommittedChangesProvider;
        if (svnCommittedChangesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getCommittedChangesProvider"));
        }
        return svnCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        SVNRevision revision = SVNRevision.parse((String)revisionNumberString);
        if (revision.equals((Object)SVNRevision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        if (this.myMapping == null) {
            this.myMapping = SvnFileUrlMappingImpl.getInstance(this.myProject);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = this.myMapping;
        if (svnFileUrlMappingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getSvnFileUrlMapping"));
        }
        return svnFileUrlMappingImpl;
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info : infoList) {
            File file = info.getIoFile();
            infos.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this, file)));
        }
        return infos;
    }

    public List<WCInfo> getWcInfosWithErrors() {
        ArrayList<WCInfo> result = new ArrayList<WCInfo>(this.getAllWcInfos());
        for (RootUrlInfo info : this.getSvnFileUrlMapping().getErrorRoots()) {
            result.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(info.getIoFile()), SVNDepth.UNKNOWN));
        }
        return result;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.getSvnFileUrlMapping();
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    public List<AnAction> getAdditionalActionsForLocalChange() {
        return Arrays.asList(new AnAction[]{new ShowPropertiesDiffWithLocalAction()});
    }

    private static String keyForVf(VirtualFile vf) {
        return vf.getUrl();
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        if (in.size() <= 1) {
            return in;
        }
        ArrayList infos = new ArrayList(in.size());
        SvnFileUrlMappingImpl mapping = (SvnFileUrlMappingImpl)this.getSvnFileUrlMapping();
        LinkedList<S> notMatched = new LinkedList<S>();
        for (S s : in) {
            VirtualFile vf = (VirtualFile)convertor.convert(s);
            if (vf == null) continue;
            File ioFile = new File(vf.getPath());
            SVNURL url = mapping.getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(this, ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair(vf, url.toString(), s));
        }
        List filtered = new UniqueRootsFilter().filter(infos);
        List converted = ObjectsConvertor.convert(filtered, (Convertor)new Convertor<MyPair<S>, S>(){

            public S convert(MyPair<S> o) {
                return o.getSrc();
            }
        });
        if (!notMatched.isEmpty()) {
            converted.addAll(notMatched);
        }
        return converted;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(VirtualFile root) {
        ClientFactory factory = this.getFactory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        return factory == this.cmdClientFactory || ThreeState.YES.equals((Object)this.myAuthNotifier.isAuthenticatedFor(root));
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public CheckoutProvider getCheckoutProvider() {
        if (this.myCheckoutProvider == null) {
            this.myCheckoutProvider = new SvnCheckoutProvider();
        }
        return this.myCheckoutProvider;
    }

    public boolean isProject18() {
        return WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)this.getProjectRootFormat());
    }

    public boolean isProject16() {
        return WorkingCopyFormat.ONE_DOT_SIX.equals((Object)this.getProjectRootFormat());
    }

    private WorkingCopyFormat getProjectRootFormat() {
        return !this.getProject().isDefault() ? this.getWorkingCopyFormat(new File(this.getProject().getBaseDir().getPath())) : WorkingCopyFormat.UNKNOWN;
    }

    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.getFactory(this.getProjectRootFormat(), false);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    public ClientFactory getSvnKitFactory() {
        return this.svnKitClientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = this.getFactory(file, true);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file, boolean useMapping) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = this.getFactory(this.getWorkingCopyFormat(file, useMapping), true);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    private ClientFactory getFactory(@NotNull WorkingCopyFormat format, boolean useProjectRootForUnknown) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        boolean is18 = WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format);
        boolean is16 = WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format);
        boolean isUnknown = WorkingCopyFormat.UNKNOWN.equals((Object)format);
        ClientFactory clientFactory = is18 ? this.cmdClientFactory : (is16 ? this.svnKitClientFactory : (useProjectRootForUnknown && isUnknown ? this.getFactory() : this.getFactoryFromSettings()));
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = target.isFile() ? this.getFactory(target.getFile()) : this.getFactory();
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactoryFromSettings() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.cmdClientFactory : this.svnKitClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactoryFromSettings"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        ClientFactory clientFactory = factory.equals(this.cmdClientFactory) ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getCommandLineFactory() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getCommandLineFactory"));
        }
        return clientFactory;
    }

    static {
        ourSSLProtocolsExplicitlySet = false;
        ourBusyExceptionProcessor = new Processor<Exception>(){

            public boolean process(Exception e) {
                if (e instanceof SVNException) {
                    Throwable cause;
                    SVNErrorCode errorCode = ((SVNException)((Object)e)).getErrorMessage().getErrorCode();
                    if (SVNErrorCode.WC_LOCKED.equals((Object)errorCode)) {
                        return true;
                    }
                    if (SVNErrorCode.SQLITE_ERROR.equals((Object)errorCode) && (cause = ((SVNException)((Object)e)).getErrorMessage().getCause()) instanceof SqlJetException) {
                        return SqlJetErrorCode.BUSY.equals((Object)((SqlJetException)cause).getErrorCode());
                    }
                }
                return false;
            }
        };
        System.setProperty("svnkit.log.native.calls", "true");
        if (Boolean.getBoolean(DO_NOT_LISTEN_TO_WC_DB)) {
            ourListenToWcDb = false;
        }
        JavaSVNDebugLogger logger = new JavaSVNDebugLogger(Boolean.getBoolean(LOG_PARAMETER_NAME), Boolean.getBoolean(TRACE_NATIVE_CALLS), LOG);
        SVNDebugLog.setDefaultLog((ISVNDebugLog)logger);
        SVNJNAUtil.setJNAEnabled((boolean)true);
        SvnHttpAuthMethodsDefaultChecker.check();
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnFormatSelector());
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (SystemInfo.isWindows) {
            SVNAdminArea14.setOptimizedWritingEnabled((boolean)true);
        }
        if (!SVNJNAUtil.isJNAPresent()) {
            LOG.warn("JNA is not found by svnkit library");
        }
        SvnVcs.initLogFilters();
        ourSSLProtocolsExplicitlySet = System.getProperty(SVNKIT_HTTP_SSL_PROTOCOLS) != null;
    }

    private static class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static class MyPair<T>
    implements RootUrlPair {
        private final VirtualFile myFile;
        private final String myUrl;
        private final T mySrc;

        private MyPair(VirtualFile file, String url, T src) {
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }
    }

    private static class JavaSVNDebugLogger
    extends SVNDebugLogAdapter {
        private final boolean myLoggingEnabled;
        private final boolean myLogNative;
        private final Logger myLog;
        private static final long ourErrorNotificationInterval = TimeUnit.MINUTES.toMillis(2L);
        private long myPreviousTime = 0L;

        public JavaSVNDebugLogger(boolean loggingEnabled, boolean logNative, Logger log) {
            this.myLoggingEnabled = loggingEnabled;
            this.myLogNative = logNative;
            this.myLog = log;
        }

        private boolean shouldLog(SVNLogType logType) {
            return this.myLoggingEnabled || this.myLogNative && SVNLogType.NATIVE_CALL.equals(logType);
        }

        public void log(SVNLogType logType, Throwable th, Level logLevel) {
            this.handleSpecificSSLExceptions(th);
            if (this.shouldLog(logType)) {
                this.myLog.info(th);
            }
        }

        private void handleSpecificSSLExceptions(Throwable th) {
            String message;
            long time = System.currentTimeMillis();
            if (time - this.myPreviousTime <= ourErrorNotificationInterval) {
                return;
            }
            if (th instanceof SSLHandshakeException) {
                if (th.getCause() instanceof SVNSSLUtil.CertificateNotTrustedException) {
                    LOG.info(th);
                    return;
                }
                this.myPreviousTime = time;
                String info = SSLExceptionsHelper.getAddInfo();
                String string = info = info == null ? "" : " (" + info + ") ";
                if (th.getCause() instanceof CertificateException) {
                    PopupUtil.showBalloonForActiveFrame((String)("Subversion: " + info + th.getCause().getMessage()), (MessageType)MessageType.ERROR);
                } else {
                    String postMessage = "\nPlease check Subversion SSL settings (Settings | Version Control | Subversion | Network)\nMaybe you should specify SSL protocol manually - SSLv3 or TLSv1";
                    PopupUtil.showBalloonForActiveFrame((String)("Subversion: " + info + th.getMessage() + "\nPlease check Subversion SSL settings (Settings | Version Control | Subversion | Network)\nMaybe you should specify SSL protocol manually - SSLv3 or TLSv1"), (MessageType)MessageType.ERROR);
                }
            } else if (th instanceof SSLProtocolException && !StringUtil.isEmptyOrSpaces((String)(message = th.getMessage()))) {
                this.myPreviousTime = time;
                String info = SSLExceptionsHelper.getAddInfo();
                info = info == null ? "" : " (" + info + ") ";
                SSLProtocolExceptionParser parser = new SSLProtocolExceptionParser(message);
                parser.parse();
                String errMessage = "Subversion: " + info + parser.getParsedMessage();
                PopupUtil.showBalloonForActiveFrame((String)errMessage, (MessageType)MessageType.ERROR);
            }
        }

        public void log(SVNLogType logType, String message, Level logLevel) {
            if (SVNLogType.NATIVE_CALL.equals(logType)) {
                JavaSVNDebugLogger.logNative(message);
            }
            if (this.shouldLog(logType)) {
                this.myLog.info(message);
            }
        }

        private static void logNative(String message) {
            if (message == null) {
                return;
            }
            NativeLogReader.CallInfo callInfo = SvnNativeLogParser.parse(message);
            if (callInfo == null) {
                return;
            }
            NativeLogReader.putInfo(callInfo);
        }

        public void log(SVNLogType logType, String message, byte[] data) {
            if (this.shouldLog(logType)) {
                if (data != null) {
                    try {
                        this.myLog.info(message + "\n" + new String(data, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.myLog.info(message + "\n" + new String(data));
                    }
                } else {
                    this.myLog.info(message);
                }
            }
        }
    }
}

