/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.nio.channels.NonWritableChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.LockDialog;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnUtil {
    @NonNls
    public static final String SVN_ADMIN_DIR_NAME = SVNFileUtil.getAdminDirectoryName();
    @NonNls
    public static final String ENTRIES_FILE_NAME = "entries";
    @NonNls
    public static final String WC_DB_FILE_NAME = "wc.db";
    @NonNls
    public static final String DIR_PROPS_FILE_NAME = "dir-props";
    @NonNls
    public static final String PATH_TO_LOCK_FILE = SVN_ADMIN_DIR_NAME + "/lock";
    public static final int DEFAULT_PORT_INDICATOR = -1;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnUtil");
    public static final Pattern ERROR_PATTERN = Pattern.compile("^svn: (E(\\d+)): (.*)$", 8);
    public static final Pattern WARNING_PATTERN = Pattern.compile("^svn: warning: (W(\\d+)): (.*)$", 8);

    private SvnUtil() {
    }

    @Nullable
    public static SVNErrorMessage parseWarning(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "parseWarning"));
        }
        Matcher matcher = WARNING_PATTERN.matcher(text);
        SVNErrorMessage error = null;
        if (matcher.find()) {
            error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)Integer.parseInt(matcher.group(2))), (String)matcher.group(3), (int)1);
        }
        return error;
    }

    public static boolean isSvnVersioned(Project project, File parent) {
        return SvnUtil.isSvnVersioned(SvnVcs.getInstance(project), parent);
    }

    public static boolean isSvnVersioned(@NotNull SvnVcs vcs, File parent) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "isSvnVersioned"));
        }
        SVNInfo info = vcs.getInfo(parent);
        return info != null;
    }

    public static List<File> toFiles(Iterable<String> paths) {
        ArrayList result = ContainerUtil.newArrayList();
        for (String path : paths) {
            result.add(new File(path));
        }
        return result;
    }

    public static Collection<VirtualFile> crawlWCRoots(Project project, File path, SvnWCRootCrawler callback, ProgressIndicator progress) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vf = lfs.findFileByIoFile(path);
        if (vf == null) {
            vf = lfs.refreshAndFindFileByIoFile(path);
        }
        if (vf == null) {
            return Collections.emptyList();
        }
        return SvnUtil.crawlWCRoots(project, vf, callback, progress);
    }

    private static Collection<VirtualFile> crawlWCRoots(Project project, VirtualFile vf, SvnWCRootCrawler callback, ProgressIndicator progress) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        boolean isDirectory = vf.isDirectory();
        VirtualFile parent = !isDirectory || !vf.exists() ? vf.getParent() : vf;
        File parentIo = new File(parent.getPath());
        if (SvnUtil.isSvnVersioned(project, parentIo)) {
            SvnUtil.checkCanceled(progress);
            File ioFile = new File(vf.getPath());
            callback.handleWorkingCopyRoot(ioFile, progress);
            SvnUtil.checkCanceled(progress);
            result.add(parent);
        } else if (isDirectory) {
            VirtualFile[] childrenVF;
            SvnUtil.checkCanceled(progress);
            for (VirtualFile file : childrenVF = parent.getChildren()) {
                SvnUtil.checkCanceled(progress);
                if (!file.isDirectory()) continue;
                result.addAll(SvnUtil.crawlWCRoots(project, file, callback, progress));
            }
        }
        return result;
    }

    private static void checkCanceled(ProgressIndicator progress) {
        if (progress != null && progress.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    public static String getExactLocation(SvnVcs vcs, File path) {
        SVNInfo info = vcs.getInfo(path);
        return info != null && info.getURL() != null ? info.getURL().toString() : null;
    }

    public static void doLockFiles(Project project, final SvnVcs activeVcs, final @NotNull File[] ioFiles) throws VcsException {
        boolean force;
        String lockMessage;
        if (ioFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/SvnUtil", "doLockFiles"));
        }
        if (activeVcs.getCheckoutOptions().getValue()) {
            LockDialog dialog = new LockDialog(project, true, ioFiles.length > 1);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            lockMessage = dialog.getComment();
            force = dialog.isForce();
        } else {
            lockMessage = "";
            force = false;
        }
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedLocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ISVNEventHandler eventHandler = new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) {
                if (event.getAction() == SVNEventAction.LOCK_FAILED) {
                    failedLocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.locking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().lock(ioFile, force, lockMessage, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.lock.files", new Object[0]), false, project);
        if (!failedLocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedLocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.locking.file.failed", file)));
            }
            StringBuilder sb = new StringBuilder(SvnBundle.message("message.text.files.lock.failed", failedFiles.length == 1 ? 0 : 1));
            for (VcsException vcsException : exceptions) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(vcsException.getMessage());
            }
            throw new VcsException(sb.toString());
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.locked", count[0]));
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static void doUnlockFiles(Project project, final SvnVcs activeVcs, final File[] ioFiles) throws VcsException {
        boolean force = true;
        final VcsException[] exception = new VcsException[1];
        final ArrayList failedUnlocks = new ArrayList();
        final int[] count = new int[]{ioFiles.length};
        final ISVNEventHandler eventHandler = new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) {
                if (event.getAction() == SVNEventAction.UNLOCK_FAILED) {
                    failedUnlocks.add(event.getErrorMessage() != null ? event.getErrorMessage().getFullMessage() : event.getFile().getAbsolutePath());
                    count[0] = count[0] - 1;
                }
            }

            public void checkCancelled() {
            }
        };
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.unlocking.files", new Object[0]));
                    }
                    for (File ioFile : ioFiles) {
                        if (progress != null) {
                            progress.checkCanceled();
                        }
                        if (progress != null) {
                            progress.setText2(SvnBundle.message("progress.text2.processing.file", ioFile.getName()));
                        }
                        activeVcs.getFactory(ioFile).createLockClient().unlock(ioFile, true, eventHandler);
                    }
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("progress.title.unlock.files", new Object[0]), false, project);
        if (!failedUnlocks.isEmpty()) {
            String[] failedFiles = ArrayUtil.toStringArray(failedUnlocks);
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            for (String file : failedFiles) {
                exceptions.add(new VcsException(SvnBundle.message("exception.text.failed.to.unlock.file", file)));
            }
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, SvnBundle.message("message.title.unlock.failures", new Object[0]));
        }
        StatusBarUtil.setStatusBarInfo((Project)project, (String)SvnBundle.message("message.text.files.unlocked", count[0]));
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
    }

    public static String formatRepresentation(WorkingCopyFormat format) {
        if (WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version18.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version17.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version16.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_FIVE.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version15.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_FOUR.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version14.text", new Object[0]);
        }
        if (WorkingCopyFormat.ONE_DOT_THREE.equals((Object)format)) {
            return SvnBundle.message("dialog.show.svn.map.table.version13.text", new Object[0]);
        }
        return "";
    }

    public static Collection<List<Change>> splitChangesIntoWc(SvnVcs vcs, List<Change> changes) {
        return SvnUtil.splitIntoRepositories(vcs, changes, new Convertor<Change, File>(){

            public File convert(Change o) {
                return ChangesUtil.getFilePath((Change)o).getIOFile();
            }
        });
    }

    public static Collection<List<File>> splitFilesIntoRepositories(SvnVcs vcs, List<File> committables) {
        return SvnUtil.splitIntoRepositories(vcs, committables, Convertor.SELF);
    }

    public static <T> Collection<List<T>> splitIntoRepositories(SvnVcs vcs, List<T> committables, Convertor<T, File> convertor) {
        if (committables.size() == 1) {
            return Collections.singletonList(committables);
        }
        MultiMap<Pair<SVNURL, WorkingCopyFormat>, T> result = SvnUtil.splitIntoRepositoriesMap(vcs, committables, convertor);
        if (result.size() == 1) {
            return Collections.singletonList(committables);
        }
        ArrayList<List<T>> result2 = new ArrayList<List<T>>();
        for (Map.Entry entry : result.entrySet()) {
            result2.add((List)entry.getValue());
        }
        return result2;
    }

    public static <T> MultiMap<Pair<SVNURL, WorkingCopyFormat>, T> splitIntoRepositoriesMap(SvnVcs vcs, List<T> committables, Convertor<T, File> convertor) {
        MultiMap result = MultiMap.create();
        for (T committable : committables) {
            RootUrlInfo path = vcs.getSvnFileUrlMapping().getWcRootForFilePath((File)convertor.convert(committable));
            if (path == null) {
                result.putValue((Object)new Pair(null, null), committable);
                continue;
            }
            result.putValue((Object)new Pair((Object)path.getRepositoryUrlUrl(), (Object)path.getFormat()), committable);
        }
        return result;
    }

    @NotNull
    public static WorkingCopyFormat getFormat(File path) {
        WorkingCopyFormat result = null;
        File dbFile = SvnUtil.resolveDatabase(path);
        if (dbFile != null && (result = (WorkingCopyFormat)((Object)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new WorkingCopyFormatOperation(dbFile)))) == null) {
            SvnUtil.notifyDatabaseError();
        }
        WorkingCopyFormat workingCopyFormat = result != null ? result : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnUtil", "getFormat"));
        }
        return workingCopyFormat;
    }

    private static void close(@Nullable SqlJetDb db) {
        if (db != null) {
            try {
                db.close();
            }
            catch (SqlJetException e) {
                SvnUtil.notifyDatabaseError();
            }
        }
    }

    private static void notifyDatabaseError() {
        VcsBalloonProblemNotifier.NOTIFICATION_GROUP.createNotification("Some errors occurred while accessing svn working copy database.", NotificationType.ERROR).notify(null);
    }

    private static File resolveDatabase(File path) {
        File dbFile = SvnUtil.getWcDb(path);
        File result = null;
        try {
            if (dbFile.exists() && dbFile.isFile()) {
                result = dbFile;
            }
        }
        catch (SecurityException e) {
            LOG.error("Failed to access working copy database", (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, File file) {
        SVNInfo info = vcs.getInfo(file);
        return info != null ? info.getRepositoryUUID() : null;
    }

    @Nullable
    public static String getRepositoryUUID(SvnVcs vcs, SVNURL url) {
        try {
            SVNInfo info = vcs.getInfo(url, SVNRevision.UNDEFINED);
            return info == null ? null : info.getRepositoryUUID();
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, File file) {
        SVNInfo info = vcs.getInfo(file);
        return info != null ? info.getRepositoryRootURL() : null;
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, String url) {
        try {
            return SvnUtil.getRepositoryRoot(vcs, SVNURL.parseURIEncoded((String)url));
        }
        catch (SVNException e) {
            return null;
        }
    }

    @Nullable
    public static SVNURL getRepositoryRoot(SvnVcs vcs, SVNURL url) throws SVNException {
        SVNInfo info = vcs.getInfo(url, SVNRevision.HEAD);
        return info == null ? null : info.getRepositoryRootURL();
    }

    public static boolean isWorkingCopyRoot(File file) {
        return FileUtil.filesEqual((File)file, (File)SvnUtil.getWorkingCopyRootNew(file));
    }

    @Nullable
    public static File getWorkingCopyRoot(File inFile) {
        File file;
        for (file = inFile; file != null && (file.isFile() || !file.exists()); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        File workingCopyRoot = null;
        try {
            workingCopyRoot = SVNWCUtil.getWorkingCopyRoot((File)file, (boolean)true);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (workingCopyRoot == null) {
            workingCopyRoot = SvnUtil.getWcCopyRootIf17(file, null);
        }
        return workingCopyRoot;
    }

    public static File fileFromUrl(File baseDir, String baseUrl, String fullUrl) throws SVNException {
        assert (fullUrl.startsWith(baseUrl));
        String part = fullUrl.substring(baseUrl.length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return new File(baseDir, part);
    }

    public static VirtualFile getVirtualFile(String filePath) {
        final String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return VirtualFileManager.getInstance().findFileByUrl(path);
            }
        });
    }

    @Nullable
    public static SVNURL getBranchForUrl(SvnVcs vcs, VirtualFile vcsRoot, String urlPath) {
        try {
            SVNURL url = SVNURL.parseURIEncoded((String)urlPath);
            SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(vcs.getProject()).get(vcsRoot);
            return configuration == null ? null : configuration.getWorkingBranch(url);
        }
        catch (SVNException e) {
            return null;
        }
        catch (VcsException e1) {
            return null;
        }
    }

    @Nullable
    public static String getPathForProgress(SVNEvent event) {
        if (event.getFile() != null) {
            return event.getFile().getName();
        }
        if (event.getURL() != null) {
            return event.getURL().toString();
        }
        return null;
    }

    @Nullable
    public static VirtualFile correctRoot(Project project, VirtualFile file) {
        if (file.getPath().length() == 0) {
            return project.getBaseDir();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkRepositoryVersion15(SvnVcs vcs, String url) {
        if (!Registry.is((String)"svn.check.repository.supports.merge.info")) {
            return true;
        }
        SVNRepository repository = null;
        try {
            repository = vcs.createRepository(url);
            boolean bl = repository.hasCapability(SVNCapability.MERGE_INFO);
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    @Nullable
    public static SVNStatus getStatus(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "getStatus"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "getStatus"));
        }
        try {
            return vcs.getFactory(file).createStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public static SVNDepth getDepth(SvnVcs vcs, File file) {
        SVNInfo info = vcs.getInfo(file);
        return info != null && info.getDepth() != null ? info.getDepth() : SVNDepth.UNKNOWN;
    }

    public static boolean seemsLikeVersionedDir(VirtualFile file) {
        String adminName = SVNFileUtil.getAdminDirectoryName();
        VirtualFile child = file.findChild(adminName);
        return child != null && child.isDirectory();
    }

    public static boolean isAdminDirectory(VirtualFile file) {
        return SvnUtil.isAdminDirectory(file.getParent(), file.getName());
    }

    public static boolean isAdminDirectory(VirtualFile parent, String name) {
        if (name.equals(SVN_ADMIN_DIR_NAME)) {
            return true;
        }
        if (parent != null) {
            if (parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
            if ((parent = parent.getParent()) != null && parent.getName().equals(SVN_ADMIN_DIR_NAME)) {
                return true;
            }
        }
        return false;
    }

    public static SVNURL getCommittedURL(SvnVcs vcs, File file) {
        File root = SvnUtil.getWorkingCopyRootNew(file);
        return root == null ? null : SvnUtil.getUrl(vcs, root);
    }

    @Nullable
    public static SVNURL getUrl(SvnVcs vcs, File file) {
        SVNInfo info = vcs.getInfo(file);
        return info == null ? null : info.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remoteFolderIsEmpty(SvnVcs vcs, String url) throws SVNException {
        SVNRepository repository = null;
        try {
            repository = vcs.createRepository(url);
            final Ref result = new Ref((Object)true);
            repository.getDir("", -1L, null, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    if (dirEntry != null) {
                        result.set((Object)false);
                    }
                }
            });
            boolean bl = (Boolean)result.get();
            return bl;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    public static File getWcDb(File file) {
        return new File(file, SVN_ADMIN_DIR_NAME + "/wc.db");
    }

    @Nullable
    public static File getWcCopyRootIf17(File file, @Nullable File upperBound) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return null;
        }
        while (current != null) {
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)current, (boolean)false);
                if (SvnWcGeneration.V17.equals((Object)svnWcGeneration)) {
                    return current;
                }
                if (SvnWcGeneration.V16.equals((Object)svnWcGeneration)) {
                    return null;
                }
                if (upperBound != null && FileUtil.filesEqual((File)upperBound, (File)current)) {
                    return null;
                }
                current = current.getParentFile();
            }
            catch (SVNException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static File getWorkingCopyRootNew(File file) {
        File current = SvnUtil.getParentWithDb(file);
        if (current == null) {
            return SvnUtil.getWorkingCopyRoot(file);
        }
        WorkingCopyFormat format = SvnUtil.getFormat(current);
        return WorkingCopyFormat.ONE_DOT_EIGHT.equals((Object)format) || WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format) ? current : SvnUtil.getWorkingCopyRoot(file);
    }

    private static File getParentWithDb(File file) {
        File current;
        boolean wcDbFound = false;
        for (current = file; current != null; current = current.getParentFile()) {
            File wcDb = SvnUtil.getWcDb(current);
            if (!wcDb.exists() || wcDb.isDirectory()) continue;
            wcDbFound = true;
            break;
        }
        if (!wcDbFound) {
            return null;
        }
        return current;
    }

    public static boolean is17CopyPart(File file) {
        try {
            return SvnWcGeneration.V17.equals((Object)SvnOperationFactory.detectWcGeneration((File)file, (boolean)true));
        }
        catch (SVNException e) {
            return false;
        }
    }

    public static String getRelativeUrl(@NotNull String parentUrl, @NotNull String childUrl) {
        if (parentUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "getRelativeUrl"));
        }
        if (childUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "getRelativeUrl"));
        }
        return FileUtilRt.getRelativePath((String)parentUrl, (String)childUrl, (char)'/', (boolean)true);
    }

    public static String getRelativePath(@NotNull String parentPath, @NotNull String childPath) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "getRelativePath"));
        }
        if (childPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "getRelativePath"));
        }
        return FileUtilRt.getRelativePath((String)FileUtil.toSystemIndependentName((String)parentPath), (String)FileUtil.toSystemIndependentName((String)childPath), (char)'/');
    }

    public static String ensureStartSlash(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "ensureStartSlash"));
        }
        return StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path : '/' + path;
    }

    @NotNull
    public static String join(String ... parts) {
        if (parts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "join"));
        }
        String string = StringUtil.join((String[])parts, (String)"/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnUtil", "join"));
        }
        return string;
    }

    public static String appendMultiParts(@NotNull String base, @NotNull String subPath) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "appendMultiParts"));
        }
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "appendMultiParts"));
        }
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        String result = base;
        for (String part : parts) {
            result = SVNPathUtil.append((String)result, (String)part);
        }
        return result;
    }

    public static SVNURL appendMultiParts(@NotNull SVNURL base, @NotNull String subPath) throws SVNException {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "appendMultiParts"));
        }
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "appendMultiParts"));
        }
        if (StringUtil.isEmpty((String)subPath)) {
            return base;
        }
        List parts = StringUtil.split((String)subPath.replace('\\', '/'), (String)"/", (boolean)true);
        SVNURL result = base;
        for (String part : parts) {
            result = result.appendPath(part, false);
        }
        return result;
    }

    public static byte[] getFileContents(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNRevision pegRevision) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "getFileContents"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnUtil", "getFileContents"));
        }
        return vcs.getFactory(target).createContentClient().getContent(target, revision, pegRevision);
    }

    public static boolean hasDefaultPort(@NotNull SVNURL result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "hasDefaultPort"));
        }
        return !result.hasPort() || SVNURL.getDefaultPortNumber((String)result.getProtocol()) == result.getPort();
    }

    public static int resolvePort(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "resolvePort"));
        }
        return !SvnUtil.hasDefaultPort(url) ? url.getPort() : -1;
    }

    @NotNull
    public static SVNURL createUrl(@NotNull String url) throws SvnBindException {
        SVNURL sVNURL;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "createUrl"));
        }
        try {
            SVNURL result = SVNURL.parseURIEncoded((String)url);
            if (result.hasPort() && SvnUtil.hasDefaultPort(result)) {
                result = SVNURL.create((String)result.getProtocol(), (String)result.getUserInfo(), (String)result.getHost(), (int)-1, (String)result.getURIEncodedPath(), (boolean)true);
            }
            sVNURL = result;
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnUtil", "createUrl"));
        }
        return sVNURL;
    }

    public static SVNURL parseUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "parseUrl"));
        }
        try {
            return SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            throw SvnUtil.createIllegalArgument(e);
        }
    }

    public static SVNURL append(@NotNull SVNURL parent, String child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "append"));
        }
        try {
            return parent.appendPath(child, false);
        }
        catch (SVNException e) {
            throw SvnUtil.createIllegalArgument(e);
        }
    }

    public static IllegalArgumentException createIllegalArgument(SVNException e) {
        IllegalArgumentException runtimeException = new IllegalArgumentException();
        runtimeException.initCause(e);
        return runtimeException;
    }

    @Nullable
    public static String getChangelistName(@NotNull SVNStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "getChangelistName"));
        }
        return SVNNodeKind.FILE.equals(status.getKind()) ? status.getChangelistName() : null;
    }

    public static boolean isUnversionedOrNotFound(@NotNull SVNErrorCode code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil", "isUnversionedOrNotFound"));
        }
        return SVNErrorCode.WC_PATH_NOT_FOUND.equals((Object)code) || SVNErrorCode.UNVERSIONED_RESOURCE.equals((Object)code) || SVNErrorCode.WC_NOT_WORKING_COPY.equals((Object)code) || SVNErrorCode.ILLEGAL_TARGET.equals((Object)code);
    }

    private static class WorkingCopyFormatOperation
    implements FileUtilRt.RepeatableIOOperation<WorkingCopyFormat, RuntimeException> {
        @NotNull
        private final File myDbFile;

        public WorkingCopyFormatOperation(@NotNull File dbFile) {
            if (dbFile == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnUtil$WorkingCopyFormatOperation", "<init>"));
            }
            this.myDbFile = dbFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Nullable
        public WorkingCopyFormat execute(boolean lastAttempt) {
            SqlJetDb db = null;
            WorkingCopyFormat result = null;
            try {
                db = SqlJetDb.open((File)this.myDbFile, (boolean)true);
                result = WorkingCopyFormat.getInstance(db.getOptions().getUserVersion());
            }
            catch (NonWritableChannelException e) {
                LOG.info((Throwable)e);
                SvnUtil.close(db);
            }
            catch (SqlJetException e2) {
                LOG.info((Throwable)e2);
                {
                    catch (Throwable throwable) {
                        SvnUtil.close(db);
                        throw throwable;
                    }
                }
                SvnUtil.close(db);
            }
            SvnUtil.close(db);
            return result;
        }
    }
}

