/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SvnScopeZipper
implements Runnable {
    private final VcsDirtyScope myIn;
    private final List<FilePath> myRecursiveDirs;
    private final Map<String, MyDirNonRecursive> myNonRecursiveDirs;
    private final List<FilePath> mySingleFiles;

    public SvnScopeZipper(VcsDirtyScope in) {
        this.myIn = in;
        this.myRecursiveDirs = new ArrayList<FilePath>(in.getRecursivelyDirtyDirectories());
        this.myNonRecursiveDirs = new HashMap<String, MyDirNonRecursive>();
        this.mySingleFiles = new ArrayList<FilePath>();
    }

    @Override
    public void run() {
        Set files = this.myIn.getDirtyFilesNoExpand();
        for (FilePath file : files) {
            FilePath parent;
            if (file.isDirectory()) {
                VirtualFile vFile = file.getVirtualFile();
                MyDirNonRecursive me = this.createOrGet(file);
                me.setInterestedInParent(true);
                if (vFile != null && vFile.isValid()) {
                    for (VirtualFile child : vFile.getChildren()) {
                        me.add((FilePath)new FilePathImpl(child));
                    }
                }
            }
            if ((parent = file.getParentPath()) == null) continue;
            MyDirNonRecursive item = this.createOrGet(parent);
            item.add(file);
        }
    }

    private MyDirNonRecursive createOrGet(FilePath parent) {
        String key = SvnScopeZipper.getKey(parent);
        MyDirNonRecursive result = this.myNonRecursiveDirs.get(key);
        if (result != null) {
            return result;
        }
        MyDirNonRecursive newItem = new MyDirNonRecursive(parent);
        this.myNonRecursiveDirs.put(key, newItem);
        return newItem;
    }

    public List<FilePath> getRecursiveDirs() {
        return this.myRecursiveDirs;
    }

    public Map<String, MyDirNonRecursive> getNonRecursiveDirs() {
        return this.myNonRecursiveDirs;
    }

    public List<FilePath> getSingleFiles() {
        return this.mySingleFiles;
    }

    public static String getKey(FilePath path) {
        return path.getPresentableUrl();
    }

    static class MyDirNonRecursive {
        private boolean myInterestedInParent;
        private final FilePath myDir;
        private final Map<String, FilePath> myChildren;

        private MyDirNonRecursive(FilePath dir) {
            this.myDir = dir;
            this.myChildren = new HashMap<String, FilePath>();
        }

        public boolean isInterestedInParent() {
            return this.myInterestedInParent;
        }

        public void setInterestedInParent(boolean interestedInParent) {
            this.myInterestedInParent = interestedInParent;
        }

        public void add(FilePath path) {
            this.myChildren.put(SvnScopeZipper.getKey(path), path);
        }

        public Collection<FilePath> getChildrenList() {
            return this.myChildren.values();
        }

        public FilePath getDir() {
            return this.myDir;
        }
    }
}

