/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnFormatSelector
implements ISVNAdminAreaFactorySelector {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnFormatSelector");

    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return factories;
        }
        if (!writeAccess) {
            return factories;
        }
        Collection result = null;
        WorkingCopyFormat presetFormat = SvnWorkingCopyFormatHolder.getPresetFormat();
        if (presetFormat != null) {
            result = SvnFormatSelector.format2Factories(presetFormat, factories);
        }
        if (result == null) {
            WorkingCopyFormat format = SvnFormatSelector.getWorkingCopyFormat(path);
            result = SvnFormatSelector.format2Factories(format, factories);
        }
        if (result == null) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY));
        }
        return result;
    }

    @Nullable
    static Collection format2Factories(WorkingCopyFormat format, Collection factories) {
        if (WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)format)) {
            return factories;
        }
        if (WorkingCopyFormat.ONE_DOT_SIX.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor16(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_FIVE.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor15(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_FOUR.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor14(factories);
        }
        if (WorkingCopyFormat.ONE_DOT_THREE.equals((Object)format)) {
            return SvnFormatSelector.factoriesFor13(factories);
        }
        return null;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor13(Collection factories) {
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            return Collections.singletonList(factory);
        }
        return Collections.emptyList();
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor14(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor15(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_FIVE.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    private static Collection<SVNAdminAreaFactory> factoriesFor16(Collection factories) {
        ArrayList<SVNAdminAreaFactory> result = new ArrayList<SVNAdminAreaFactory>(2);
        for (SVNAdminAreaFactory factory : factories) {
            int supportedVersion = factory.getSupportedVersion();
            if (WorkingCopyFormat.ONE_DOT_FOUR.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_THREE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_FIVE.getFormat() != supportedVersion && WorkingCopyFormat.ONE_DOT_SIX.getFormat() != supportedVersion) continue;
            result.add(factory);
        }
        return result;
    }

    @NotNull
    public static WorkingCopyFormat findRootAndGetFormat(File path) {
        File root = SvnUtil.getWorkingCopyRootNew(path);
        WorkingCopyFormat workingCopyFormat = root != null ? SvnFormatSelector.getWorkingCopyFormat(root) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "findRootAndGetFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public static WorkingCopyFormat getWorkingCopyFormat(File path) {
        WorkingCopyFormat format = SvnUtil.getFormat(path);
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.detectWithSvnKit(path) : format;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    private static WorkingCopyFormat detectWithSvnKit(File path) {
        block9: {
            WorkingCopyFormat workingCopyFormat;
            try {
                SvnWcGeneration svnWcGeneration = SvnOperationFactory.detectWcGeneration((File)path, (boolean)true);
                if (!SvnWcGeneration.V17.equals((Object)svnWcGeneration)) break block9;
                workingCopyFormat = WorkingCopyFormat.ONE_DOT_SEVEN;
            }
            catch (SVNException e) {
                // empty catch block
            }
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "detectWithSvnKit"));
            }
            return workingCopyFormat;
        }
        int format = 0;
        try {
            format = SVNAdminAreaFactory.checkWC((File)path, (boolean)false);
        }
        catch (SVNException e) {
            // empty catch block
        }
        try {
            if (format == 0 && path.getParentFile() != null) {
                format = SVNAdminAreaFactory.checkWC((File)path.getParentFile(), (boolean)false);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.getInstance(format);
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnFormatSelector", "detectWithSvnKit"));
        }
        return workingCopyFormat;
    }
}

