/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnEntriesFileListener
extends VirtualFileAdapter {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnEntriesFileListener");
    private VcsDirtyScopeManager myDirtyScopeManager;

    public SvnEntriesFileListener(Project project) {
        this.myProject = project;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnEntriesFileListener", "fileCreated"));
        }
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (SvnUtil.SVN_ADMIN_DIR_NAME.equals(file.getName()) && event.getParent() != null) {
            VirtualFile parent = event.getParent();
            this.fireFileStatusesChanged(parent);
            this.refreshAnnotationsUnder(parent);
        }
    }

    private void refreshAnnotationsUnder(VirtualFile parent) {
        ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirtyUnder(parent);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        VirtualFile grandParent;
        VirtualFile parent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnEntriesFileListener", "contentsChanged"));
        }
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (SvnEntriesFileListener.isWcDbFile(file) && SvnVcs.ourListenToWcDb) {
            VirtualFile parent2;
            LOG.debug("wc.db had changed");
            VirtualFile parentWcDb = file.getParent();
            if (parentWcDb != null && SvnUtil.isAdminDirectory(parentWcDb) && (parent2 = parentWcDb.getParent()) != null) {
                this.myDirtyScopeManager.dirDirtyRecursively(parent2);
                this.refreshAnnotationsUnder(parent2);
            }
            return;
        }
        if (SvnEntriesFileListener.isEntriesFile(file) && file.getParent() != null && (parent = file.getParent()) != null && (grandParent = parent.getParent()) != null) {
            this.fireFileStatusesChanged(grandParent);
            this.refreshAnnotationsUnder(grandParent);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnEntriesFileListener", "fileDeleted"));
        }
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (SvnUtil.SVN_ADMIN_DIR_NAME.equals(file.getName())) {
            if (event.getParent() != null) {
                VirtualFile parent = event.getParent();
                this.fireFileStatusesChanged(parent);
                this.refreshAnnotationsUnder(parent);
            }
            return;
        }
    }

    private void fireFileStatusesChanged(VirtualFile parent) {
        VirtualFile[] children = parent.getChildren();
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(children.length + 1);
        files.add(parent);
        Collections.addAll(files, children);
        this.myDirtyScopeManager.filesDirty(files, null);
    }

    private static boolean isEntriesFile(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return !file.isDirectory() && "entries".equals(file.getName()) && parent != null && SvnUtil.SVN_ADMIN_DIR_NAME.equals(parent.getName());
    }

    private static boolean isWcDbFile(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return !file.isDirectory() && "wc.db".equals(file.getName()) && parent != null && SvnUtil.SVN_ADMIN_DIR_NAME.equals(parent.getName());
    }
}

