/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnEditFileProvider
implements EditFileProvider {
    private final SvnVcs myVCS;

    public SvnEditFileProvider(SvnVcs vcs) {
        this.myVCS = vcs;
    }

    public void editFiles(VirtualFile[] files) throws VcsException {
        File[] ioFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            ioFiles[i] = new File(files[i].getPath());
            PropertyClient client = this.myVCS.getFactory(ioFiles[i]).createPropertyClient();
            SVNPropertyData property = client.getProperty(SvnTarget.fromFile((File)ioFiles[i], (SVNRevision)SVNRevision.WORKING), "svn:needs-lock", false, SVNRevision.WORKING);
            if (property != null && property.getValue() != null) continue;
            throw new VcsException(SvnBundle.message("exception.text.file.miss.svn", ioFiles[i].getName()));
        }
        SvnUtil.doLockFiles(this.myVCS.getProject(), this.myVCS, ioFiles);
    }

    public String getRequestText() {
        return SvnBundle.message("confirmation.text.edit.file", new Object[0]);
    }
}

