/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBinaryContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnContentRevision
implements ContentRevision,
MarkerVcsContentRevision {
    private final SvnVcs myVcs;
    protected final FilePath myFile;
    private final SVNRevision myRevision;
    private final boolean myUseBaseRevision;

    protected SvnContentRevision(SvnVcs vcs, @NotNull FilePath file, SVNRevision revision, boolean useBaseRevision) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnContentRevision", "<init>"));
        }
        this.myVcs = vcs;
        this.myRevision = revision;
        this.myUseBaseRevision = useBaseRevision;
        this.myFile = file;
    }

    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, SVNStatus status) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnContentRevision", "createBaseRevision"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnContentRevision", "createBaseRevision"));
        }
        SVNRevision revision = status.getRevision().isValid() ? status.getRevision() : status.getCommittedRevision();
        return SvnContentRevision.createBaseRevision(vcs, file, revision);
    }

    public static SvnContentRevision createBaseRevision(SvnVcs vcs, FilePath file, SVNRevision revision) {
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, true);
        }
        return new SvnContentRevision(vcs, file, revision, true);
    }

    public static SvnContentRevision createRemote(@NotNull SvnVcs vcs, @NotNull FilePath file, SVNRevision revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnContentRevision", "createRemote"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/SvnContentRevision", "createRemote"));
        }
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, false);
        }
        return new SvnContentRevision(vcs, file, revision, false);
    }

    @Nullable
    public String getContent() throws VcsException {
        try {
            if (this.myUseBaseRevision) {
                return (String)ContentRevisionCache.getOrLoadCurrentAsString((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsKey)this.myVcs.getKeyInstanceMethod(), (CurrentRevisionProvider)new CurrentRevisionProvider(){

                    public VcsRevisionNumber getCurrentRevision() throws VcsException {
                        return SvnContentRevision.this.getRevisionNumber();
                    }

                    public Pair<VcsRevisionNumber, byte[]> get() throws VcsException, IOException {
                        return new Pair((Object)SvnContentRevision.this.getRevisionNumber(), (Object)SvnContentRevision.this.getUpToDateBinaryContent());
                    }
                }).getSecond();
            }
            return ContentRevisionCache.getOrLoadAsString((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

                public byte[] compute() throws VcsException, IOException {
                    return SvnContentRevision.this.getUpToDateBinaryContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    protected byte[] getUpToDateBinaryContent() throws VcsException {
        File file = this.myFile.getIOFile();
        File lock = new File(file.getParentFile(), SvnUtil.PATH_TO_LOCK_FILE);
        if (lock.exists()) {
            throw new VcsException("Can not access file base revision contents: administrative area is locked");
        }
        return SvnUtil.getFileContents(this.myVcs, SvnTarget.fromFile((File)file), this.myUseBaseRevision ? SVNRevision.BASE : this.myRevision, SVNRevision.UNDEFINED);
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = new SvnRevisionNumber(this.myRevision);
        if (svnRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnContentRevision", "getRevisionNumber"));
        }
        return svnRevisionNumber;
    }

    @NonNls
    public String toString() {
        return this.myFile.getPath();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }
}

