/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.AbstractShowPropertiesDiffAction;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    private final ChangelistBuilder myChangelistBuilder;
    private final SVNStatusClient myStatusClient;
    private List<SvnChangedFile> myCopiedFiles = null;
    private final List<SvnChangedFile> myDeletedFiles = new ArrayList<SvnChangedFile>();
    private final Map<String, SVNStatus> myTreeConflicted;
    private Map<FilePath, String> myCopyFromURLs = null;
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    private final ProgressIndicator myProgress;

    public SvnChangeProviderContext(SvnVcs vcs, ChangelistBuilder changelistBuilder, ProgressIndicator progress) {
        this.myVcs = vcs;
        this.myStatusClient = vcs.createStatusClient();
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myTreeConflicted = new HashMap<String, SVNStatus>();
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, SVNStatus status) throws SVNException {
        this.processStatusFirstPass(path, status);
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
    }

    public ChangelistBuilder getBuilder() {
        return this.myChangelistBuilder;
    }

    public SVNStatusClient getClient() {
        return this.myStatusClient;
    }

    public void reportTreeConflict(SVNStatus status) {
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public SVNStatus getTreeConflictStatus(File file) {
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        if (this.myCopiedFiles == null) {
            List<SvnChangedFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getCopiedFiles"));
            }
            return list;
        }
        List<SvnChangedFile> list = this.myCopiedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangeProviderContext", "getCopiedFiles"));
        }
        return list;
    }

    public List<SvnChangedFile> getDeletedFiles() {
        return this.myDeletedFiles;
    }

    public boolean isDeleted(FilePath path) {
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public boolean isCanceled() {
        return this.myProgress != null && this.myProgress.isCanceled();
    }

    @Nullable
    public String getParentCopyFromURL(FilePath filePath) {
        if (this.myCopyFromURLs == null) {
            return null;
        }
        StringBuilder relPathBuilder = new StringBuilder();
        while (filePath != null) {
            String copyFromURL = this.myCopyFromURLs.get(filePath);
            if (copyFromURL != null) {
                return copyFromURL + relPathBuilder.toString();
            }
            relPathBuilder.insert(0, "/" + filePath.getName());
            filePath = filePath.getParentPath();
        }
        return null;
    }

    public void addCopiedFile(FilePath filePath, SVNStatus status, String copyFromURL) {
        if (this.myCopiedFiles == null) {
            this.myCopiedFiles = new ArrayList<SvnChangedFile>();
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        String url = status.getCopyFromURL();
        if (url != null) {
            this.addCopyFromURL(filePath, url);
        }
    }

    public void addCopyFromURL(FilePath filePath, String url) {
        if (this.myCopyFromURLs == null) {
            this.myCopyFromURLs = new HashMap<FilePath, String>();
        }
        this.myCopyFromURLs.put(filePath, url);
    }

    void processStatusFirstPass(FilePath filePath, SVNStatus status) throws SVNException {
        SVNLock lock;
        if (status == null) {
            return;
        }
        if (status.getRemoteLock() != null) {
            lock = status.getRemoteLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(false, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (status.getLocalLock() != null) {
            lock = status.getLocalLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(true, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if ((SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_ADDED) || SVNStatusType.STATUS_MODIFIED.equals(status.getNodeStatus())) && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            String parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(FilePath filePath, SVNStatus status) throws SVNException {
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile());
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)format) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            SvnChangeProviderContext.loadEntriesFile(filePath);
        }
        if (status != null) {
            FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
            SVNStatusType statusType = status.getContentsStatus();
            SVNStatusType propStatus = status.getPropertiesStatus();
            if (SvnVcs.svnStatusIsUnversioned(status) || SvnVcs.svnStatusIs(status, SVNStatusType.UNKNOWN)) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null) {
                    this.myChangelistBuilder.processUnversionedFile(file);
                }
            } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_ADDED)) {
                this.myChangelistBuilder.processChangeInList(this.createChange(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
            } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_CONFLICTED) || SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_MODIFIED) || SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_REPLACED) || propStatus == SVNStatusType.STATUS_MODIFIED || propStatus == SVNStatusType.STATUS_CONFLICTED) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_DELETED)) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
            } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_MISSING)) {
                this.myChangelistBuilder.processLocallyDeletedFile(this.createLocallyDeletedChange(filePath, status));
            } else if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_IGNORED)) {
                if (!this.myVcs.isWcRoot(filePath)) {
                    this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
                }
            } else if (!(status.isCopied() || fStatus != FileStatus.NOT_CHANGED && fStatus != FileStatus.SWITCHED || statusType == SVNStatusType.STATUS_NONE)) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                    this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnUtil.getChangelistName(status), SvnVcs.getKey());
                } else if (status.getTreeConflict() != null) {
                    this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
                }
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            }
        }
    }

    public void addModifiedNotSavedChange(VirtualFile file) throws SVNException {
        FilePathImpl filePath = new FilePathImpl(file);
        SVNInfo svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            SVNStatus svnStatus = new SVNStatus();
            svnStatus.setRevision(svnInfo.getRevision());
            this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, (FilePath)filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus), (String)null, SvnVcs.getKey());
        }
    }

    private void checkSwitched(FilePath filePath, ChangelistBuilder builder, SVNStatus status, FileStatus convertedStatus) {
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String switchUrl = status.getURL().toString();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = null;
                try {
                    baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
                builder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl : baseUrl, true);
            }
        }
    }

    private static void loadEntriesFile(FilePath filePath) {
        FilePath parentPath = filePath.getParentPath();
        if (parentPath == null) {
            return;
        }
        SvnChangeProviderContext.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            SvnChangeProviderContext.refreshDotSvnAndEntries(filePath);
        }
    }

    private static void refreshDotSvnAndEntries(FilePath filePath) {
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        LocalFileSystem.getInstance().refreshIoFiles(Arrays.asList(svn, new File(svn, "entries")), true, false, null);
    }

    Change createMovedChange(ContentRevision before, ContentRevision after, SVNStatus copiedStatus, SVNStatus deletedStatus) throws SVNException {
        ConflictedSvnChange conflictedSvnChange = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        if (deletedStatus != null) {
            conflictedSvnChange.setBeforeDescription(deletedStatus.getTreeConflict());
        }
        if (copiedStatus != null) {
            conflictedSvnChange.setAfterDescription(copiedStatus.getTreeConflict());
        }
        return this.patchWithPropertyChange(conflictedSvnChange, copiedStatus, deletedStatus);
    }

    private Change createChange(ContentRevision before, ContentRevision after, FileStatus fStatus, SVNStatus svnStatus) throws SVNException {
        ConflictedSvnChange conflictedSvnChange = new ConflictedSvnChange(before, after, this.correctContentsStatus(fStatus, svnStatus), this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        if (svnStatus != null) {
            if (SVNStatusType.STATUS_DELETED.equals(svnStatus.getNodeStatus()) && !svnStatus.getRevision().isValid()) {
                conflictedSvnChange.setIsPhantom(true);
            }
            conflictedSvnChange.setBeforeDescription(svnStatus.getTreeConflict());
        }
        return this.patchWithPropertyChange(conflictedSvnChange, svnStatus, null);
    }

    private FileStatus correctContentsStatus(FileStatus fs, SVNStatus svnStatus) throws SVNException {
        return fs;
    }

    private LocallyDeletedChange createLocallyDeletedChange(@NotNull FilePath filePath, SVNStatus status) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/SvnChangeProviderContext", "createLocallyDeletedChange"));
        }
        return new SvnLocallyDeletedChange(filePath, this.getState(status));
    }

    private Change patchWithPropertyChange(Change change, SVNStatus svnStatus, SVNStatus deletedStatus) throws SVNException {
        if (svnStatus == null) {
            return change;
        }
        SVNStatusType propertiesStatus = svnStatus.getPropertiesStatus();
        if (SVNStatusType.STATUS_CONFLICTED.equals(propertiesStatus) || SVNStatusType.CHANGED.equals(propertiesStatus) || SVNStatusType.STATUS_ADDED.equals(propertiesStatus) || SVNStatusType.STATUS_DELETED.equals(propertiesStatus) || SVNStatusType.STATUS_MODIFIED.equals(propertiesStatus) || SVNStatusType.STATUS_REPLACED.equals(propertiesStatus) || SVNStatusType.MERGED.equals(propertiesStatus)) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            File ioFile = path.getIOFile();
            File beforeFile = deletedStatus != null ? deletedStatus.getFile() : ioFile;
            String beforeList = SVNStatusType.STATUS_ADDED.equals(propertiesStatus) && deletedStatus == null ? null : AbstractShowPropertiesDiffAction.getPropertyList(this.myVcs, beforeFile, SVNRevision.BASE);
            String afterList = SVNStatusType.STATUS_DELETED.equals(propertiesStatus) ? null : AbstractShowPropertiesDiffAction.getPropertyList(this.myVcs, ioFile, SVNRevision.WORKING);
            String beforeRevisionNu = change.getBeforeRevision() == null ? null : change.getBeforeRevision().getRevisionNumber().asString();
            String afterRevisionNu = change.getAfterRevision() == null ? null : change.getAfterRevision().getRevisionNumber().asString();
            Change propertyChange = new Change((ContentRevision)(beforeList == null ? null : new SimpleContentRevision(beforeList, path, beforeRevisionNu)), (ContentRevision)(afterList == null ? null : new SimpleContentRevision(afterList, path, afterRevisionNu)), deletedStatus != null ? FileStatus.MODIFIED : SvnStatusConvertor.convertPropertyStatus(propertiesStatus));
            change.addAdditionalLayerElement("Property", propertyChange);
        }
        return change;
    }

    private ConflictState getState(@Nullable SVNStatus svnStatus) {
        boolean propertyConflict;
        if (svnStatus == null) {
            return ConflictState.none;
        }
        SVNStatusType propertiesStatus = svnStatus.getPropertiesStatus();
        boolean treeConflict = svnStatus.getTreeConflict() != null;
        boolean textConflict = SVNStatusType.STATUS_CONFLICTED == svnStatus.getContentsStatus();
        boolean bl = propertyConflict = SVNStatusType.STATUS_CONFLICTED == propertiesStatus;
        if (treeConflict) {
            this.reportTreeConflict(svnStatus);
        }
        return ConflictState.getInstance(treeConflict, textConflict, propertyConflict);
    }
}

