/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class ProxySvnAuthentication {
    private ProxySvnAuthentication() {
    }

    public static SVNAuthentication proxy(SVNAuthentication in, boolean storeAuth, boolean forceSaving) {
        if (forceSaving && storeAuth) {
            return ProxySvnAuthentication.putPassedValueAsSave(in, forceSaving);
        }
        if (in.isStorageAllowed() == storeAuth || !in.isStorageAllowed()) {
            return in;
        }
        return ProxySvnAuthentication.putPassedValueAsSave(in, storeAuth);
    }

    private static SVNAuthentication putPassedValueAsSave(SVNAuthentication in, boolean storeAuth) {
        String userName = in.getUserName();
        if (in instanceof SVNPasswordAuthentication) {
            return new SVNPasswordAuthentication(userName, ((SVNPasswordAuthentication)in).getPassword(), storeAuth, in.getURL(), in.isPartial());
        }
        if (in instanceof SVNSSHAuthentication) {
            SVNSSHAuthentication svnsshAuthentication = (SVNSSHAuthentication)in;
            if (svnsshAuthentication.hasPrivateKey()) {
                return new SVNSSHAuthentication(userName, svnsshAuthentication.getPrivateKeyFile(), svnsshAuthentication.getPassphrase(), svnsshAuthentication.getPortNumber(), storeAuth, in.getURL(), in.isPartial());
            }
            return new SVNSSHAuthentication(userName, svnsshAuthentication.getPassword(), svnsshAuthentication.getPortNumber(), storeAuth, in.getURL(), in.isPartial());
        }
        if (in instanceof SVNSSLAuthentication) {
            SVNSSLAuthentication svnsslAuthentication = (SVNSSLAuthentication)in;
            if ("MSCAPI".equals(svnsslAuthentication.getSSLKind())) {
                return new SVNSSLAuthentication("MSCAPI", svnsslAuthentication.getAlias(), storeAuth, in.getURL(), in.isPartial());
            }
            return new SVNSSLAuthentication(svnsslAuthentication.getCertificateFile(), svnsslAuthentication.getPassword(), storeAuth, svnsslAuthentication.getURL(), svnsslAuthentication.isPartial());
        }
        if (in instanceof SVNUserNameAuthentication) {
            return new SVNUserNameAuthentication(in.getUserName(), storeAuth, in.getURL(), in.isPartial());
        }
        return in;
    }
}

