/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class NestedCopiesBuilder
implements StatusReceiver {
    private final Set<NestedCopyInfo> mySet;
    private final Project myProject;
    private final SvnFileUrlMapping myMapping;
    @NotNull
    private final SvnVcs myVcs;

    public NestedCopiesBuilder(@NotNull SvnVcs vcs, SvnFileUrlMapping mapping) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/NestedCopiesBuilder", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myMapping = mapping;
        this.mySet = new HashSet<NestedCopyInfo>();
    }

    @Override
    public void process(FilePath path, SVNStatus status) throws SVNException {
        VirtualFile file = path.getVirtualFile();
        if (file != null && SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_EXTERNAL)) {
            NestedCopyInfo info = new NestedCopyInfo(file, null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external, null);
            this.mySet.add(info);
            return;
        }
        if (file == null || status.getURL() == null) {
            return;
        }
        if (!SvnVcs.svnStatusIsUnversioned(status) && status.isSwitched()) {
            NestedCopyInfo info = new NestedCopyInfo(file, status.getURL(), this.myVcs.getWorkingCopyFormat(path.getIOFile()), NestedCopyType.switched, status.getRepositoryRootURL());
            this.mySet.add(info);
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
    }

    @Override
    public void processCopyRoot(VirtualFile file, SVNURL url, WorkingCopyFormat format, SVNURL rootURL) {
        NestedCopyInfo info = new NestedCopyInfo(file, url, format, NestedCopyType.inner, rootURL);
        this.mySet.add(info);
    }

    @Override
    public void bewareRoot(VirtualFile vf, SVNURL url) {
        File ioFile = new File(vf.getPath());
        RootUrlInfo info = this.myMapping.getWcRootForFilePath(ioFile);
        if (info != null && FileUtil.filesEqual((File)ioFile, (File)info.getIoFile()) && !info.getAbsoluteUrlAsUrl().equals((Object)url)) {
            SvnVcs.getInstance(this.myProject).invokeRefreshSvnRoots();
        }
    }

    public Set<NestedCopyInfo> getCopies() {
        return this.mySet;
    }
}

