/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class IgnoredFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.IgnoredFileInfo");
    private final File myFile;
    private final List<String> myPatterns;
    private final Set<String> myFileNames;
    private final Set<String> myOldPatterns;

    public IgnoredFileInfo(File file, Set<String> oldPatterns) {
        this.myFile = file;
        this.myPatterns = new ArrayList<String>();
        this.myFileNames = new HashSet<String>();
        this.myOldPatterns = oldPatterns;
    }

    public void addFileName(String name) {
        this.myFileNames.add(name);
    }

    public void addPattern(String value) {
        this.myPatterns.add(value);
    }

    public void calculatePatterns(SvnVcs vcs) {
        final ArrayList names = new ArrayList();
        try {
            vcs.createStatusClient().doStatus(this.myFile, SVNRevision.WORKING, SVNDepth.IMMEDIATES, false, true, true, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    if (SvnVcs.svnStatusIs(status, SVNStatusType.STATUS_IGNORED)) {
                        String name = status.getFile().getName();
                        if (!IgnoredFileInfo.this.myFileNames.contains(name)) {
                            names.add(name);
                        }
                    }
                }
            }, null);
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
        }
        block2: for (String pattern : this.myOldPatterns) {
            boolean usedSomewhereElse = false;
            for (String name : names) {
                if (!DefaultSVNOptions.matches((String)pattern, (String)name)) continue;
                usedSomewhereElse = true;
                break;
            }
            if (usedSomewhereElse) continue;
            for (String name : this.myFileNames) {
                if (!DefaultSVNOptions.matches((String)pattern, (String)name)) continue;
                this.myPatterns.add(pattern);
                continue block2;
            }
        }
    }

    public File getFile() {
        return this.myFile;
    }

    public List<String> getPatterns() {
        return this.myPatterns;
    }

    public Set<String> getFileNames() {
        return this.myFileNames;
    }

    public Set<String> getOldPatterns() {
        return this.myOldPatterns;
    }
}

