/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import javax.swing.Icon;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class ConflictedSvnChange
extends Change {
    private final ConflictState myConflictState;
    private SVNTreeConflictDescription myBeforeDescription;
    private SVNTreeConflictDescription myAfterDescription;
    private final FilePath myTreeConflictMarkHolder;
    private boolean myIsPhantom;

    public ConflictedSvnChange(ContentRevision beforeRevision, ContentRevision afterRevision, ConflictState conflictState, FilePath treeConflictMarkHolder) {
        super(beforeRevision, afterRevision);
        this.myConflictState = conflictState;
        this.myTreeConflictMarkHolder = treeConflictMarkHolder;
    }

    public ConflictedSvnChange(ContentRevision beforeRevision, ContentRevision afterRevision, FileStatus fileStatus, ConflictState conflictState, FilePath treeConflictMarkHolder) {
        super(beforeRevision, afterRevision, fileStatus);
        this.myConflictState = conflictState;
        this.myTreeConflictMarkHolder = treeConflictMarkHolder;
    }

    public ConflictState getConflictState() {
        return this.myConflictState;
    }

    public void setIsPhantom(boolean isPhantom) {
        this.myIsPhantom = isPhantom;
    }

    public boolean isTreeConflict() {
        return this.myConflictState.isTree();
    }

    public boolean isPhantom() {
        return this.myIsPhantom;
    }

    public SVNTreeConflictDescription getBeforeDescription() {
        return this.myBeforeDescription;
    }

    public void setBeforeDescription(SVNTreeConflictDescription beforeDescription) {
        this.myBeforeDescription = beforeDescription;
    }

    public SVNTreeConflictDescription getAfterDescription() {
        return this.myAfterDescription;
    }

    public void setAfterDescription(SVNTreeConflictDescription afterDescription) {
        this.myAfterDescription = afterDescription;
    }

    public Icon getAdditionalIcon() {
        return this.myConflictState.getIcon();
    }

    public String getDescription() {
        String description = this.myConflictState.getDescription();
        if (description != null) {
            StringBuilder sb = new StringBuilder(SvnBundle.message("svn.changeview.item.in.conflict.text", description));
            if (this.myBeforeDescription != null) {
                sb.append('\n');
                if (this.myAfterDescription != null) {
                    sb.append("before: ");
                }
                sb.append(SVNTreeConflictUtil.getHumanReadableConflictDescription((SVNTreeConflictDescription)this.myBeforeDescription));
            }
            if (this.myAfterDescription != null) {
                sb.append('\n');
                if (this.myBeforeDescription != null) {
                    sb.append("after: ");
                }
                sb.append(SVNTreeConflictUtil.getHumanReadableConflictDescription((SVNTreeConflictDescription)this.myAfterDescription));
            }
            return sb.toString();
        }
        return description;
    }

    public FilePath getTreeConflictMarkHolder() {
        return this.myTreeConflictMarkHolder;
    }
}

