/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuilderExecutionSettings {
    @Nullable
    private final File myGradleHomeDir;
    @Nullable
    private final File myGradleServiceDir;
    @Nullable
    private final File myJavaHomeDir;
    @NotNull
    private final File myProjectDir;
    @NotNull
    private final BuildMode myBuildMode;
    @NotNull
    private final List<String> myModulesToBuildNames;
    @NotNull
    private final List<String> myCommandLineOptions;
    @NotNull
    private final List<String> myJvmOptions;
    private final boolean myEmbeddedModeEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.embedded.daemon", (boolean)false);
    private final boolean myVerboseLoggingEnabled;
    private final boolean myParallelBuild;
    private final boolean myOfflineBuildMode;
    private final boolean myConfigureOnDemand;

    BuilderExecutionSettings() {
        this.myGradleHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.home.path", "Gradle home");
        this.myGradleServiceDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.service.dir.path", "Gradle service");
        this.myJavaHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.java.home.path", "Java home");
        this.myProjectDir = BuilderExecutionSettings.findProjectRootDir();
        String buildActionName = System.getProperty("com.android.studio.gradle.build.mode");
        this.myBuildMode = Strings.isNullOrEmpty((String)buildActionName) ? BuildMode.DEFAULT_BUILD_MODE : BuildMode.valueOf((String)buildActionName);
        this.myModulesToBuildNames = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.modules.count", "com.android.studio.gradle.modules.");
        this.myCommandLineOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.command.line.option.count", "com.android.studio.gradle.daemon.command.line.option.");
        this.myJvmOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.jvm.option.count", "com.android.studio.gradle.daemon.jvm.option.");
        this.myVerboseLoggingEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.verbose.logging", (boolean)false);
        this.myParallelBuild = SystemProperties.getBooleanProperty((String)"compile.parallel", (boolean)false);
        this.myOfflineBuildMode = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.offline.mode", (boolean)false);
        this.myConfigureOnDemand = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.configuration.on.demand", (boolean)false);
        this.populateHttpProxyJvmOptions();
    }

    @Nullable
    private static File findDir(@NotNull String jvmArgName, @NotNull String dirType) {
        if (jvmArgName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "findDir"));
        }
        if (dirType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "findDir"));
        }
        File gradleServiceDir = BuilderExecutionSettings.createFile(jvmArgName);
        if (gradleServiceDir == null) {
            return null;
        }
        BuilderExecutionSettings.ensureDirectoryExists(gradleServiceDir, dirType);
        return gradleServiceDir;
    }

    @NotNull
    private static File findProjectRootDir() {
        File projectRootDir = BuilderExecutionSettings.createFile("com.android.studio.gradle.project.path");
        if (projectRootDir == null) {
            throw new NullPointerException("Project directory not specified");
        }
        BuilderExecutionSettings.ensureDirectoryExists(projectRootDir, "project");
        File file = projectRootDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "findProjectRootDir"));
        }
        return file;
    }

    private static void ensureDirectoryExists(@NotNull File dir, @NotNull String type) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "ensureDirectoryExists"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "ensureDirectoryExists"));
        }
        if (!dir.isDirectory()) {
            String path = dir.getPath();
            String msg = String.format("Unable to obtain %1$s directory: the file '%2$s' is not a directory", type, path);
            throw new IllegalArgumentException(msg);
        }
    }

    @Nullable
    private static File createFile(@NotNull String jvmArgName) {
        if (jvmArgName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "createFile"));
        }
        String path = System.getProperty(jvmArgName);
        return path != null && !path.isEmpty() ? new File(path) : null;
    }

    @NotNull
    private static List<String> getJvmArgGroup(@NotNull String countArgName, @NotNull String argPrefix) {
        if (countArgName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getJvmArgGroup"));
        }
        if (argPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getJvmArgGroup"));
        }
        int count = SystemProperties.getIntProperty((String)countArgName, (int)0);
        ArrayList args = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            String arg = System.getProperty(argPrefix + i);
            if (Strings.isNullOrEmpty((String)arg)) continue;
            args.add(arg);
        }
        ArrayList arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getJvmArgGroup"));
        }
        return arrayList;
    }

    private void populateHttpProxyJvmOptions() {
        int vmOptionCount = SystemProperties.getIntProperty((String)"com.android.studio.gradle.proxy.property.count", (int)0);
        for (int i = 0; i < vmOptionCount; ++i) {
            int indexOfSeparator;
            String jvmOption = System.getProperty("com.android.studio.gradle.proxy.property." + i);
            if (Strings.isNullOrEmpty((String)jvmOption) || (indexOfSeparator = jvmOption.indexOf(":")) < 0 || indexOfSeparator >= jvmOption.length() - 1) continue;
            String arg = AndroidGradleSettings.createJvmArg((String)jvmOption.substring(0, indexOfSeparator), (String)jvmOption.substring(indexOfSeparator + 1));
            this.myJvmOptions.add(arg);
        }
    }

    boolean isEmbeddedModeEnabled() {
        return this.myEmbeddedModeEnabled;
    }

    boolean isVerboseLoggingEnabled() {
        return this.myVerboseLoggingEnabled;
    }

    @NotNull
    List<String> getCommandLineOptions() {
        List<String> list = this.myCommandLineOptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getCommandLineOptions"));
        }
        return list;
    }

    @NotNull
    List<String> getJvmOptions() {
        List<String> list = this.myJvmOptions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getJvmOptions"));
        }
        return list;
    }

    @Nullable
    File getGradleHomeDir() {
        return this.myGradleHomeDir;
    }

    @Nullable
    File getGradleServiceDir() {
        return this.myGradleServiceDir;
    }

    @Nullable
    File getJavaHomeDir() {
        return this.myJavaHomeDir;
    }

    @NotNull
    File getProjectDir() {
        File file = this.myProjectDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getProjectDir"));
        }
        return file;
    }

    @NotNull
    BuildMode getBuildMode() {
        BuildMode buildMode = this.myBuildMode;
        if (buildMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getBuildMode"));
        }
        return buildMode;
    }

    boolean isParallelBuild() {
        return this.myParallelBuild;
    }

    boolean isOfflineBuild() {
        return this.myOfflineBuildMode;
    }

    public boolean isConfigureOnDemand() {
        return this.myConfigureOnDemand;
    }

    @NotNull
    List<String> getModulesToBuildNames() {
        List<String> list = this.myModulesToBuildNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/BuilderExecutionSettings", "getModulesToBuildNames"));
        }
        return list;
    }

    public String toString() {
        return "BuilderExecutionSettings[buildMode=" + this.myBuildMode.name() + ", commandLineOptions=" + this.myCommandLineOptions + ", embeddedModeEnabled=" + this.myEmbeddedModeEnabled + ", gradleHomeDir=" + this.myGradleHomeDir + ", gradleServiceDir=" + this.myGradleServiceDir + ", javaHomeDir=" + this.myJavaHomeDir + ", jvmOptions=" + this.myJvmOptions + ", modulesToBuildNames=" + this.myModulesToBuildNames + ", offlineBuild=" + this.myOfflineBuildMode + ", parallelBuild=" + this.myParallelBuild + ", projectDir=" + this.myProjectDir + ", verboseLoggingEnabled=" + this.myVerboseLoggingEnabled + ']';
    }
}

