/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleBuilds;
import com.android.tools.idea.jps.AndroidGradleJps;
import com.android.tools.idea.jps.builder.AndroidGradleBuildTarget;
import com.android.tools.idea.jps.builder.BuilderExecutionSettings;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;

public class AndroidGradleTargetBuilder
extends TargetBuilder<AndroidGradleBuildTarget.RootDescriptor, AndroidGradleBuildTarget> {
    private static final Logger LOG = Logger.getInstance(AndroidGradleTargetBuilder.class);
    @NonNls
    private static final String BUILDER_NAME = "Android Gradle Target Builder";
    private static final int BUFFER_SIZE = 2048;

    public AndroidGradleTargetBuilder() {
        super(Collections.singletonList(AndroidGradleBuildTarget.TargetType.INSTANCE));
    }

    public void build(@NotNull AndroidGradleBuildTarget target, @NotNull DirtyFilesHolder<AndroidGradleBuildTarget.RootDescriptor, AndroidGradleBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        BuilderExecutionSettings executionSettings;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "build"));
        }
        JpsProject project = target.getProject();
        AndroidGradleTargetBuilder.checkUnsupportedModules(project, context);
        try {
            executionSettings = new BuilderExecutionSettings();
        }
        catch (RuntimeException e) {
            throw new ProjectBuildException((Throwable)e);
        }
        LOG.info("Using execution settings: " + executionSettings);
        Object[] buildTasks = AndroidGradleTargetBuilder.getBuildTasks(project, context, executionSettings);
        if (buildTasks.length == 0) {
            String format = "No build tasks found for project '%1$s'. Nothing done.";
            LOG.info(String.format(format, project.getName()));
            return;
        }
        String msg = "Gradle build using tasks: " + Arrays.toString(buildTasks);
        context.processMessage((BuildMessage)new ProgressMessage(msg));
        LOG.info(msg);
        AndroidGradleTargetBuilder.ensureTempDirExists();
        String androidHome = null;
        if (!AndroidGradleSettings.isAndroidSdkDirInLocalPropertiesFile((File)executionSettings.getProjectDir())) {
            androidHome = AndroidGradleTargetBuilder.getAndroidHomeFromModuleSdk(project);
        }
        String format = "About to build project '%1$s' located at %2$s";
        LOG.info(String.format(format, project.getName(), executionSettings.getProjectDir().getAbsolutePath()));
        AndroidGradleTargetBuilder.doBuild(context, (String[])buildTasks, executionSettings, androidHome);
    }

    private static void checkUnsupportedModules(JpsProject project, CompileContext context) {
        for (JpsTypedModule module : project.getModules((JpsModuleType)JpsJavaModuleType.INSTANCE)) {
            if (AndroidGradleJps.getGradleSystemExtension((JpsModule)module) != null) continue;
            context.processMessage((BuildMessage)AndroidGradleJps.createCompilerMessage(BuildMessage.Kind.WARNING, "module '" + module.getName() + "' won't be compiled. " + "Unfortunately you can't have non-Gradle Java module and Android-Gradle module in one project."));
        }
    }

    @NotNull
    private static String[] getBuildTasks(@NotNull JpsProject project, @NotNull CompileContext context, @NotNull BuilderExecutionSettings executionSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getBuildTasks"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getBuildTasks"));
        }
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getBuildTasks"));
        }
        BuildMode buildMode = executionSettings.getBuildMode();
        if (buildMode == BuildMode.ASSEMBLE_TRANSLATE) {
            String[] stringArray = new String[]{"assembleTranslate"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getBuildTasks"));
            }
            return stringArray;
        }
        boolean isCleanBuildMode = buildMode == BuildMode.CLEAN;
        ArrayList tasks = Lists.newArrayList();
        List<JpsModule> modulesToBuild = AndroidGradleTargetBuilder.getModulesToBuild(project, executionSettings);
        if (modulesToBuild.isEmpty()) {
            tasks.add("assemble");
        } else {
            BuildMode tempBuildMode = buildMode;
            if (isCleanBuildMode) {
                tempBuildMode = BuildMode.SOURCE_GEN;
            }
            for (JpsModule module : modulesToBuild) {
                AndroidGradleTargetBuilder.populateBuildTasks(module, tempBuildMode, tasks, context);
            }
        }
        if (isCleanBuildMode || !tasks.isEmpty() && JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
            tasks.add(0, "clean");
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)tasks);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getBuildTasks"));
        }
        return stringArray;
    }

    @NotNull
    private static List<JpsModule> getModulesToBuild(@NotNull JpsProject project, @NotNull BuilderExecutionSettings executionSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getModulesToBuild"));
        }
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getModulesToBuild"));
        }
        List modules = project.getModules();
        List<String> moduleNames = executionSettings.getModulesToBuildNames();
        if (moduleNames.isEmpty()) {
            if (AndroidGradleTargetBuilder.isGradleProject(modules)) {
                List<JpsModule> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getModulesToBuild"));
                }
                return list;
            }
            List list = modules;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getModulesToBuild"));
            }
            return list;
        }
        ArrayList modulesToBuild = Lists.newArrayList();
        for (JpsModule module : modules) {
            if ("buildSrc".equals(module.getName()) || !moduleNames.contains(module.getName())) continue;
            modulesToBuild.add(module);
        }
        ArrayList arrayList = modulesToBuild;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getModulesToBuild"));
        }
        return arrayList;
    }

    private static boolean isGradleProject(@NotNull List<JpsModule> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "isGradleProject"));
        }
        for (JpsModule module : modules) {
            JpsAndroidModuleProperties properties = AndroidGradleTargetBuilder.getAndroidModuleProperties(module);
            if (properties == null || properties.ALLOW_USER_CONFIGURATION) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JpsAndroidModuleProperties getAndroidModuleProperties(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getAndroidModuleProperties"));
        }
        JpsAndroidModuleExtensionImpl androidFacet = (JpsAndroidModuleExtensionImpl)AndroidJpsUtil.getExtension((JpsModule)module);
        return androidFacet != null ? androidFacet.getProperties() : null;
    }

    private static void populateBuildTasks(@NotNull JpsModule module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, CompileContext context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "populateBuildTasks"));
        }
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "populateBuildTasks"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "populateBuildTasks"));
        }
        JpsAndroidGradleModuleExtension androidGradleFacet = AndroidGradleJps.getExtension(module);
        if (androidGradleFacet == null) {
            return;
        }
        String gradleProjectPath = androidGradleFacet.getProperties().GRADLE_PROJECT_PATH;
        JpsAndroidModuleProperties properties = AndroidGradleTargetBuilder.getAndroidModuleProperties(module);
        GradleBuilds.findAndAddBuildTask((String)module.getName(), (BuildMode)buildMode, (String)gradleProjectPath, (JpsAndroidModuleProperties)properties, tasks, (GradleBuilds.TestCompileType)AndroidGradleTargetBuilder.getTestCompileType(context));
    }

    private static GradleBuilds.TestCompileType getTestCompileType(CompileContext context) {
        if (AndroidJpsUtil.isJunitTestContext((CompileContext)context)) {
            return GradleBuilds.TestCompileType.JAVA_TESTS;
        }
        if (AndroidJpsUtil.isInstrumentationTestContext((CompileContext)context)) {
            return GradleBuilds.TestCompileType.ANDROID_TESTS;
        }
        return GradleBuilds.TestCompileType.NONE;
    }

    private static void ensureTempDirExists() {
        String tmpDirProperty = System.getProperty("java.io.tmpdir");
        if (!Strings.isNullOrEmpty((String)tmpDirProperty)) {
            File tmpDir = new File(tmpDirProperty);
            try {
                FileUtil.ensureExists((File)tmpDir);
            }
            catch (IOException e) {
                LOG.warn("Unable to create temp directory", (Throwable)e);
            }
        }
    }

    @Nullable
    private static String getAndroidHomeFromModuleSdk(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getAndroidHomeFromModuleSdk"));
        }
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> androidSdk = AndroidGradleTargetBuilder.getFirstAndroidSdk(project);
        if (androidSdk == null) {
            String msg = String.format("There is no Android SDK specified for project '%1$s'", project.getName());
            LOG.error(msg);
            return null;
        }
        String androidHome = androidSdk.getHomePath();
        if (Strings.isNullOrEmpty((String)androidHome)) {
            String msg = "Selected Android SDK does not have a home directory path";
            LOG.error(msg);
            return null;
        }
        return androidHome;
    }

    @Nullable
    private static JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getFirstAndroidSdk(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getFirstAndroidSdk"));
        }
        for (JpsModule module : project.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doBuild(@NotNull CompileContext context, @NotNull String[] buildTasks, @NotNull BuilderExecutionSettings executionSettings, @Nullable String androidHome) throws ProjectBuildException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "doBuild"));
        }
        if (buildTasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "doBuild"));
        }
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "doBuild"));
        }
        GradleConnector connector = AndroidGradleTargetBuilder.getGradleConnector(executionSettings);
        ProjectConnection connection = connector.connect();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream(2048);
        ByteArrayOutputStream stderr = new ByteArrayOutputStream(2048);
        try {
            File javaHomeDir;
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(buildTasks);
            ArrayList jvmArgs = Lists.newArrayList();
            BuildMode buildMode = executionSettings.getBuildMode();
            if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
                String arg = AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
                jvmArgs.add(arg);
            }
            if (androidHome != null && !androidHome.isEmpty()) {
                String androidSdkArg = AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHome);
                jvmArgs.add(androidSdkArg);
            }
            jvmArgs.addAll(executionSettings.getJvmOptions());
            LOG.info("Build JVM args: " + jvmArgs);
            if (!jvmArgs.isEmpty()) {
                launcher.setJvmArguments(ArrayUtil.toStringArray((Collection)jvmArgs));
            }
            ArrayList commandLineArgs = Lists.newArrayList();
            commandLineArgs.addAll(executionSettings.getCommandLineOptions());
            commandLineArgs.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
            if (executionSettings.isParallelBuild() && !commandLineArgs.contains("--parallel")) {
                commandLineArgs.add("--parallel");
            }
            if (executionSettings.isOfflineBuild() && !commandLineArgs.contains("--offline")) {
                commandLineArgs.add("--offline");
            }
            if (executionSettings.isConfigureOnDemand() && !commandLineArgs.contains("--configure-on-demand")) {
                commandLineArgs.add("--configure-on-demand");
            }
            LOG.info("Build command line args: " + commandLineArgs);
            if (!commandLineArgs.isEmpty()) {
                launcher.withArguments(ArrayUtil.toStringArray((Collection)commandLineArgs));
            }
            if ((javaHomeDir = executionSettings.getJavaHomeDir()) != null) {
                launcher.setJavaHome(javaHomeDir);
            }
            launcher.setStandardOutput((OutputStream)stdout);
            launcher.setStandardError((OutputStream)stderr);
            launcher.run();
        }
        catch (BuildException e) {
            AndroidGradleTargetBuilder.handleBuildException(e, context, stderr.toString());
        }
        finally {
            String outText = stdout.toString();
            context.processMessage((BuildMessage)new ProgressMessage(outText, 1.0f));
            try {
                Closeables.close((Closeable)stdout, (boolean)true);
                Closeables.close((Closeable)stderr, (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            connection.close();
        }
    }

    @NotNull
    private static GradleConnector getGradleConnector(@NotNull BuilderExecutionSettings executionSettings) {
        File gradleServiceDir;
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getGradleConnector"));
        }
        GradleConnector connector = GradleConnector.newConnector();
        if (connector instanceof DefaultGradleConnector) {
            DefaultGradleConnector defaultConnector = (DefaultGradleConnector)connector;
            if (executionSettings.isEmbeddedModeEnabled()) {
                LOG.info("Using Gradle embedded mode.");
                defaultConnector.embedded(true);
            }
            defaultConnector.setVerboseLogging(executionSettings.isVerboseLoggingEnabled());
        }
        connector.forProjectDirectory(executionSettings.getProjectDir());
        File gradleHomeDir = executionSettings.getGradleHomeDir();
        if (gradleHomeDir != null) {
            connector.useInstallation(gradleHomeDir);
        }
        if ((gradleServiceDir = executionSettings.getGradleServiceDir()) != null) {
            connector.useGradleUserHomeDir(gradleServiceDir);
        }
        GradleConnector gradleConnector = connector;
        if (gradleConnector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getGradleConnector"));
        }
        return gradleConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleBuildException(BuildException e, CompileContext context, String stdErr) throws ProjectBuildException {
        List compilerMessages = new BuildOutputParser().parseGradleOutput(stdErr);
        if (!compilerMessages.isEmpty()) {
            for (GradleMessage message : compilerMessages) {
                context.processMessage((BuildMessage)AndroidGradleJps.createCompilerMessage(message));
            }
            return;
        }
        if (!stdErr.isEmpty()) {
            context.processMessage((BuildMessage)AndroidGradleTargetBuilder.createCompilerErrorMessage(stdErr));
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                e.printStackTrace(new PrintStream(out));
                String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                context.processMessage((BuildMessage)AndroidGradleTargetBuilder.createCompilerErrorMessage(message));
            }
            finally {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException e1) {
                    LOG.debug((Throwable)e1);
                }
            }
        }
        throw new ProjectBuildException(e.getMessage());
    }

    @NotNull
    private static CompilerMessage createCompilerErrorMessage(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "createCompilerErrorMessage"));
        }
        CompilerMessage compilerMessage = AndroidGradleJps.createCompilerMessage(BuildMessage.Kind.ERROR, msg);
        if (compilerMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "createCompilerErrorMessage"));
        }
        return compilerMessage;
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/builder/AndroidGradleTargetBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }
}

