/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertActualNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevertList;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbRevert
extends SvnWcDbShared {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(SVNWCDbRoot root, File localRelPath) throws SVNException {
        long opDepth;
        long affectedRows;
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        SvnRevertActualNodesTrigger actualNodesTableTrigger = new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (!stmt.next()) {
                SvnWcDbStatementUtil.reset(stmt);
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
                try {
                    ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                    stmt.bindf("is", root.getWcId(), localRelPath);
                    affectedRows = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows > 0L) {
                    stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
                    try {
                        stmt.bindf("is", root.getWcId(), localRelPath);
                        if (stmt.next()) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                    }
                    finally {
                        SvnWcDbStatementUtil.reset(stmt);
                    }
                    return;
                }
                SvnWcDbRevert.nodeNotFound(root, localRelPath);
            }
            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        if (opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err;
            boolean haveRow;
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_GE_OP_DEPTH_CHILDREN);
            try {
                stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
                haveRow = stmt.next();
            }
            finally {
                SvnWcDbStatementUtil.reset(stmt);
            }
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                haveRow = stmt.next();
            }
            finally {
                SvnWcDbStatementUtil.reset(stmt);
            }
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = sdb.getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_INCREASE_RECURSIVE);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
                stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN);
            try {
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            affectedRows = stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 0L) {
            stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST);
            try {
                ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                stmt.bindf("is", root.getWcId(), localRelPath);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertRecursive(SVNWCDbRoot root, File localRelPath) throws SVNException {
        long opDepth;
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        SvnRevertActualNodesTrigger actualNodesTableTrigger = new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (!stmt.next()) {
                long affectedRows;
                SvnWcDbStatementUtil.reset(stmt);
                stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
                try {
                    ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
                    stmt.bindf("is", root.getWcId(), localRelPath);
                    affectedRows = stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (affectedRows > 0L) {
                    return;
                }
                SvnWcDbRevert.nodeNotFound(root, localRelPath);
            }
            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        if (opDepth > 0L && opDepth != (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting parent", (Object)root.getAbsPath(localRelPath));
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (opDepth == 0L) {
            opDepth = 1L;
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_NODES_RECURSIVE);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
            stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        try {
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN_RECURSIVE);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    public static Map<File, ISVNWCDb.SVNWCDbKind> readRevertCopiedChildren(SVNWCContext context, File localAbsPath) throws SVNException {
        TreeMap<File, ISVNWCDb.SVNWCDbKind> result = new TreeMap<File, ISVNWCDb.SVNWCDbKind>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String path1 = o1.getAbsolutePath();
                String path2 = o2.getAbsolutePath();
                return -SVNPathUtil.PATH_COMPARATOR.compare(path1, path2);
            }
        });
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SvnWcDbRevertList revertList = root.getSDb().getRevertList();
        long selectDepth = SVNWCUtils.relpathDepth(localRelpath);
        String selectPath = SVNFileUtil.getFilePath(localRelpath);
        Iterator<SvnWcDbRevertList.RevertListRow> rows = revertList.rows();
        while (rows.hasNext()) {
            SvnWcDbRevertList.RevertListRow row = rows.next();
            if (row.reposId == 0L || "".equals(row.localRelpath) || !"".equals(selectPath) && !row.localRelpath.startsWith(selectPath + "/") || row.opDepth < selectDepth) continue;
            File childFile = SVNFileUtil.createFilePath(root.getAbsPath(), row.localRelpath);
            result.put(childFile, SvnWcDbStatementUtil.getKindForString(row.kind));
        }
        return result;
    }

    public static Structure<RevertInfo> readRevertInfo(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        Object result = Structure.obtain(RevertInfo.class);
        ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Unknown);
        ((Structure)result).set((RevertInfo)RevertInfo.reverted, false);
        ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, false);
        SvnWcDbRevertList.RevertListRow row = root.getSDb().getRevertList().getActualRow(SVNFileUtil.getFilePath(localRelpath));
        SvnWcDbRevertList.RevertListRow revertListRow = row = row == null ? root.getSDb().getRevertList().getRow(SVNFileUtil.getFilePath(localRelpath)) : row;
        if (row != null) {
            if (row.actual != 0L) {
                ((Structure)result).set((RevertInfo)RevertInfo.reverted, row.notify != 0L);
                if (row.conflictOld != null) {
                    ((Structure)result).set((RevertInfo)RevertInfo.conflictOld, SVNFileUtil.createFilePath(root.getAbsPath(), row.conflictOld));
                }
                if (row.conflictNew != null) {
                    ((Structure)result).set((RevertInfo)RevertInfo.conflictNew, SVNFileUtil.createFilePath(root.getAbsPath(), row.conflictNew));
                }
                if (row.conflictWorking != null) {
                    ((Structure)result).set((RevertInfo)RevertInfo.conflictWorking, SVNFileUtil.createFilePath(root.getAbsPath(), row.conflictWorking));
                }
                if (row.propReject != null) {
                    ((Structure)result).set((RevertInfo)RevertInfo.propReject, SVNFileUtil.createFilePath(root.getAbsPath(), row.propReject));
                }
                row = root.getSDb().getRevertList().getRow(SVNFileUtil.getFilePath(localRelpath));
            }
            if (row != null) {
                ((Structure)result).set((RevertInfo)RevertInfo.reverted, true);
                if (row.reposId != 0L) {
                    ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, row.opDepth == (long)SVNWCUtils.relpathDepth(localRelpath));
                }
                ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)SvnWcDbStatementUtil.getKindForString(row.kind));
            }
            root.getSDb().getRevertList().deleteRow(SVNFileUtil.getFilePath(localRelpath));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropRevertList(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SVNWCDbCreateSchema stmt = new SVNWCDbCreateSchema(root.getSDb(), SVNWCDbCreateSchema.DROP_REVERT_LIST, -1);
        try {
            stmt.done();
        }
        finally {
            stmt.reset();
        }
    }

    public static void notifyRevert(SVNWCContext context, File localAbsPath, ISVNEventHandler eventHandler) throws SVNException {
        String rowPath;
        SvnWcDbRevertList.RevertListRow row;
        Iterator<SvnWcDbRevertList.RevertListRow> rows;
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        String localRelpath = SVNFileUtil.getFilePath(dirInfo.localRelPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SvnWcDbRevertList revertList = root.getSDb().getRevertList();
        File previousPath = null;
        if (eventHandler != null) {
            rows = revertList.rows();
            while (rows.hasNext()) {
                row = rows.next();
                rowPath = row.localRelpath;
                if (!localRelpath.equals(rowPath) && !"".equals(localRelpath) && !rowPath.startsWith(localRelpath + "/") || row.notify == 0L && row.actual != 0L) continue;
                File notifyRelPath = SVNFileUtil.createFilePath(rowPath);
                if (previousPath != null && notifyRelPath.equals(previousPath)) continue;
                previousPath = notifyRelPath;
                File notifyAbsPath = SVNFileUtil.createFilePath(root.getAbsPath(), notifyRelPath);
                eventHandler.handleEvent(SVNEventFactory.createSVNEvent(notifyAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
            }
        }
        rows = revertList.rows();
        while (rows.hasNext()) {
            row = rows.next();
            rowPath = row.localRelpath;
            if ("".equals(localRelpath)) {
                revertList.deleteRow(rowPath);
                continue;
            }
            if (!rowPath.equals(localRelpath) && !rowPath.startsWith(localRelpath + "/")) continue;
            revertList.deleteRow(rowPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RevertInfo {
        reverted,
        conflictOld,
        conflictNew,
        conflictWorking,
        propReject,
        copiedHere,
        kind;

    }
}

