/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UntrackedFilesNotifier {
    private UntrackedFilesNotifier() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(final @NotNull Project project, final @NotNull Collection<VirtualFile> untrackedFiles, final @NotNull String operation, @Nullable String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        if (untrackedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        String notificationTitle = StringUtil.capitalize((String)operation) + " failed";
        String notificationDesc = description == null ? UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, true) : description;
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, notificationDesc, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/UntrackedFilesNotifier$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/UntrackedFilesNotifier$1", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String dialogDesc = UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, false);
                    UntrackedFilesDialog dlg = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                    dlg.setTitle("Untracked Files Preventing " + StringUtil.capitalize((String)operation));
                    dlg.show();
                }
            }
        });
    }

    public static String createUntrackedFilesOverwrittenDescription(@NotNull String operation, boolean addLinkToViewFiles) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/UntrackedFilesNotifier", "createUntrackedFilesOverwrittenDescription"));
        }
        String description1 = " untracked working tree files would be overwritten by " + operation + ".";
        String description2 = "Please move or remove them before you can " + operation + ".";
        String notificationDesc = addLinkToViewFiles ? "Some" + description1 + "<br/>" + description2 + " <a href='view'>View them</a>" : "These" + description1 + "<br/>" + description2;
        return notificationDesc;
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        public UntrackedFilesDialog(Project project, Collection<VirtualFile> untrackedFiles, String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, false, true);
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/UntrackedFilesNotifier$UntrackedFilesDialog", "createActions"));
            }
            return actionArray;
        }
    }
}

