/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class GitUpdateLocallyModifiedDialog
extends DialogWrapper {
    private JButton myRescanButton;
    private JList myFilesList;
    private JLabel myDescriptionLabel;
    private JLabel myGitRoot;
    private JPanel myRootPanel;
    private final List<String> myLocallyModifiedFiles;

    protected GitUpdateLocallyModifiedDialog(final Project project, final VirtualFile root, List<String> locallyModifiedFiles) {
        super(project, true);
        this.myLocallyModifiedFiles = locallyModifiedFiles;
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("update.locally.modified.title"));
        this.myGitRoot.setText(root.getPresentableUrl());
        this.myFilesList.setModel(new DefaultListModel());
        this.setOKButtonText(GitBundle.getString("update.locally.modified.revert"));
        this.syncListModel();
        this.myRescanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitUpdateLocallyModifiedDialog.this.myLocallyModifiedFiles.clear();
                try {
                    GitUpdateLocallyModifiedDialog.scanFiles(project, root, GitUpdateLocallyModifiedDialog.this.myLocallyModifiedFiles);
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(project, ex, "Checking for locally modified files");
                }
            }
        });
        this.myDescriptionLabel.setText(GitBundle.message("update.locally.modified.message", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.init();
    }

    private void syncListModel() {
        DefaultListModel listModel = (DefaultListModel)this.myFilesList.getModel();
        listModel.removeAllElements();
        for (String p : this.myLocallyModifiedFiles) {
            listModel.addElement(p);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static void scanFiles(Project project, VirtualFile root, List<String> files) throws VcsException {
        String rootPath = root.getPath();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.DIFF);
        h.addParameters("--name-status");
        h.setSilent(true);
        h.setStdoutSuppressed(true);
        StringScanner s = new StringScanner(h.run());
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.line();
                continue;
            }
            if (s.tryConsume("M\t")) {
                String path = rootPath + "/" + GitUtil.unescapePath(s.line());
                files.add(path);
                continue;
            }
            throw new VcsException("Working tree is dirty in unsupported way: " + s.line());
        }
    }

    public static boolean showIfNeeded(final Project project, final VirtualFile root) {
        final ArrayList<String> files = new ArrayList<String>();
        try {
            GitUpdateLocallyModifiedDialog.scanFiles(project, root, files);
            final AtomicBoolean rc = new AtomicBoolean(true);
            if (!files.isEmpty()) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GitUpdateLocallyModifiedDialog d = new GitUpdateLocallyModifiedDialog(project, root, files);
                        d.show();
                        rc.set(d.isOK());
                    }
                });
                if (rc.get() && !files.isEmpty()) {
                    GitUpdateLocallyModifiedDialog.revertFiles(project, root, files);
                }
            }
            return rc.get();
        }
        catch (VcsException e) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GitUIUtil.showOperationError(project, e, "Checking for locally modified files");
                }
            });
            return false;
        }
    }

    private static void revertFiles(Project project, VirtualFile root, ArrayList<String> files) throws VcsException {
        GitRollbackEnvironment rollback = GitRollbackEnvironment.getInstance(project);
        ArrayList<FilePath> list = new ArrayList<FilePath>(files.size());
        for (String p : files) {
            list.add(VcsUtil.getFilePath((String)p));
        }
        rollback.revert(root, list);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.locally.modified.git.root"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRoot = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 2, 0, 3, 0, 0, null, null, null));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myFilesList = jBList;
        jBList.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.locally.modified.files.tooltip"));
        jBScrollPane.setViewportView((Component)jBList);
        this.myRescanButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.locally.modified.rescan"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.locally.modified.rescan.tooltip"));
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setVerticalAlignment(0);
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.locally.modified.files"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        jLabel4.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

