/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ContentsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.rebase.GitRebaseUtils;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class GitSkippedCommits
extends PanelWithActionsAndCloseButton {
    private final Project myProject;
    private final Tree myTree;
    private JBScrollPane myCenterComponent;

    public GitSkippedCommits(@NotNull ContentManager contentManager, Project project, SortedMap<VirtualFile, List<GitRebaseUtils.CommitInfo>> skippedCommits) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/update/GitSkippedCommits", "<init>"));
        }
        super(contentManager, null);
        this.myProject = project;
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("ROOT", true);
        for (Map.Entry<VirtualFile, List<GitRebaseUtils.CommitInfo>> e : skippedCommits.entrySet()) {
            DefaultMutableTreeNode vcsRoot = new DefaultMutableTreeNode(new VcsRoot(e.getKey()));
            int missed = 0;
            for (GitRebaseUtils.CommitInfo c : e.getValue()) {
                if (c != null) {
                    vcsRoot.add(new DefaultMutableTreeNode(new Commit(e.getKey(), c)));
                    continue;
                }
                ++missed;
            }
            treeRoot.add(vcsRoot);
            if (missed <= 0) continue;
            vcsRoot.add(new DefaultMutableTreeNode("The " + missed + " commit(s) were not parsed due to unsupported rebase directory format"));
        }
        this.myTree = new Tree((TreeNode)treeRoot);
        this.myTree.setCellRenderer((TreeCellRenderer)this.createTreeCellRenderer());
        this.myTree.setRootVisible(false);
        this.myCenterComponent = new JBScrollPane((Component)this.myTree);
        this.init();
        TreeUtil.expandAll((JTree)this.myTree);
    }

    private DefaultTreeCellRenderer createTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object o;
                Component r = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object object = o = value instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)value).getUserObject() : null;
                if (o instanceof VcsRoot) {
                    r.setFont(tree.getFont().deriveFont(1));
                    r.setForeground(sel ? this.textSelectionColor : this.textNonSelectionColor);
                } else if (o instanceof String) {
                    r.setForeground(sel ? this.textSelectionColor : JBColor.RED);
                    r.setFont(tree.getFont());
                } else {
                    r.setForeground(sel ? this.textSelectionColor : this.textNonSelectionColor);
                    r.setFont(tree.getFont());
                }
                return r;
            }
        };
    }

    protected JComponent createCenterPanel() {
        return this.myCenterComponent;
    }

    protected void addActionsTo(DefaultActionGroup group) {
        super.addActionsTo(group);
        ShowAllAffectedGenericAction showCommit = ShowAllAffectedGenericAction.getInstance();
        showCommit.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{CommonShortcuts.DOUBLE_CLICK_1.getShortcuts()[0]}), (JComponent)this.myTree);
        group.addAction((AnAction)showCommit);
    }

    public Object getData(String dataId) {
        Object o;
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        TreePath selectionPath = this.myTree.getSelectionPath();
        DefaultMutableTreeNode node = selectionPath == null ? null : (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object object = o = node == null ? null : node.getUserObject();
        if (o instanceof Commit) {
            Commit c = (Commit)o;
            if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
                return c.root;
            }
            if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
                return new GitFileRevision(this.myProject, VcsUtil.getFilePath((String)c.root.getPath()), c.commitInfo.revision);
            }
        }
        return super.getData(dataId);
    }

    public static void showSkipped(final Project project, final SortedMap<VirtualFile, List<GitRebaseUtils.CommitInfo>> skippedCommits) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentManager contentManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).getContentManager();
                if (contentManager == null) {
                    return;
                }
                GitSkippedCommits skipped = new GitSkippedCommits(contentManager, project, skippedCommits);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)skipped), "Skipped Commits", true);
                ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (boolean)true);
                ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS).activate(null);
            }
        });
    }

    private static class Commit {
        final VirtualFile root;
        final GitRebaseUtils.CommitInfo commitInfo;

        public Commit(VirtualFile root, GitRebaseUtils.CommitInfo commitInfo) {
            this.root = root;
            this.commitInfo = commitInfo;
        }

        public String toString() {
            return this.commitInfo.revision.asString().substring(0, 8) + ": " + this.commitInfo.subject;
        }
    }

    private static class VcsRoot {
        final VirtualFile root;

        public VcsRoot(VirtualFile root) {
            this.root = root;
        }

        public String toString() {
            return this.root.getPath();
        }
    }
}

