/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vfs.VirtualFile;
import git4idea.util.GitFileUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRepositoryFiles {
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    public static final String CONFIG = "config";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "index";
    public static final String INFO = "info";
    public static final String INFO_EXCLUDE = "info/exclude";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    public static final String MERGE_MSG = "MERGE_MSG";
    public static final String REBASE_APPLY = "rebase-apply";
    public static final String REBASE_MERGE = "rebase-merge";
    public static final String PACKED_REFS = "packed-refs";
    public static final String REFS_HEADS = "refs/heads";
    public static final String REFS_REMOTES = "refs/remotes";
    public static final String SQUASH_MSG = "SQUASH_MSG";
    public static final String GIT_HEAD = ".git" + GitRepositoryFiles.slash("HEAD");
    public static final String GIT_REFS_REMOTES = ".git" + GitRepositoryFiles.slash("refs/remotes");
    public static final String GIT_PACKED_REFS = ".git" + GitRepositoryFiles.slash("packed-refs");
    public static final String GIT_MERGE_HEAD = ".git" + GitRepositoryFiles.slash("MERGE_HEAD");
    public static final String GIT_MERGE_MSG = ".git" + GitRepositoryFiles.slash("MERGE_MSG");
    public static final String GIT_SQUASH_MSG = ".git" + GitRepositoryFiles.slash("SQUASH_MSG");
    public static final String GIT_COMMIT_EDITMSG = ".git" + GitRepositoryFiles.slash("COMMIT_EDITMSG");
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myCommitMessagePath;
    private final String myExcludePath;

    public static GitRepositoryFiles getInstance(@NotNull VirtualFile gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryFiles", "getInstance"));
        }
        return new GitRepositoryFiles(gitDir);
    }

    private GitRepositoryFiles(@NotNull VirtualFile gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryFiles", "<init>"));
        }
        String gitDirPath = GitFileUtils.stripFileProtocolPrefix(gitDir.getPath());
        this.myConfigFilePath = gitDirPath + GitRepositoryFiles.slash(CONFIG);
        this.myHeadFilePath = gitDirPath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = gitDirPath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = gitDirPath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCommitMessagePath = gitDirPath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myRebaseApplyPath = gitDirPath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = gitDirPath + GitRepositoryFiles.slash(REBASE_MERGE);
        this.myPackedRefsPath = gitDirPath + GitRepositoryFiles.slash(PACKED_REFS);
        this.myRefsHeadsDirPath = gitDirPath + GitRepositoryFiles.slash(REFS_HEADS);
        this.myRefsRemotesDirPath = gitDirPath + GitRepositoryFiles.slash(REFS_REMOTES);
        this.myExcludePath = gitDirPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        String string = "/" + s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "slash"));
        }
        return string;
    }

    @NotNull
    static Collection<String> getSubDirRelativePaths() {
        List<String> list = Arrays.asList(GitRepositoryFiles.slash(REFS_HEADS), GitRepositoryFiles.slash(REFS_REMOTES), GitRepositoryFiles.slash(INFO));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getSubDirRelativePaths"));
        }
        return list;
    }

    @NotNull
    String getRefsHeadsPath() {
        String string = this.myRefsHeadsDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsHeadsPath"));
        }
        return string;
    }

    @NotNull
    String getRefsRemotesPath() {
        String string = this.myRefsRemotesDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryFiles", "getRefsRemotesPath"));
        }
        return string;
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryFiles", "isCommitMessageFile"));
        }
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepositoryFiles", "isExclude"));
        }
        return path.equals(this.myExcludePath);
    }
}

