/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepoInfo {
    @Nullable
    private final GitLocalBranch myCurrentBranch;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @NotNull
    private final Set<GitRemote> myRemotes;
    @NotNull
    private final Set<GitLocalBranch> myLocalBranches;
    @NotNull
    private final Set<GitRemoteBranch> myRemoteBranches;
    @NotNull
    private final Set<GitBranchTrackInfo> myBranchTrackInfos;

    public GitRepoInfo(@Nullable GitLocalBranch currentBranch, @Nullable String currentRevision, @NotNull Repository.State state, @NotNull Collection<GitRemote> remotes, @NotNull Collection<GitLocalBranch> localBranches, @NotNull Collection<GitRemoteBranch> remoteBranches, @NotNull Collection<GitBranchTrackInfo> branchTrackInfos) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        if (branchTrackInfos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "git4idea/repo/GitRepoInfo", "<init>"));
        }
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myState = state;
        this.myRemotes = new LinkedHashSet<GitRemote>(remotes);
        this.myLocalBranches = new LinkedHashSet<GitLocalBranch>(localBranches);
        this.myRemoteBranches = new LinkedHashSet<GitRemoteBranch>(remoteBranches);
        this.myBranchTrackInfos = new LinkedHashSet<GitBranchTrackInfo>(branchTrackInfos);
    }

    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public Collection<GitRemote> getRemotes() {
        Set<GitRemote> set = this.myRemotes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getRemotes"));
        }
        return set;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Set<GitLocalBranch> set = this.myLocalBranches;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getLocalBranches"));
        }
        return set;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Set<GitRemoteBranch> set = this.myRemoteBranches;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getRemoteBranches"));
        }
        return set;
    }

    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        Set<GitBranchTrackInfo> set = this.myBranchTrackInfos;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getBranchTrackInfos"));
        }
        return set;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepoInfo", "getState"));
        }
        return state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepoInfo info = (GitRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (this.myCurrentBranch != null ? !this.myCurrentBranch.equals(info.myCurrentBranch) : info.myCurrentBranch != null) {
            return false;
        }
        if (!((Object)this.myRemotes).equals(info.myRemotes)) {
            return false;
        }
        if (!((Object)this.myBranchTrackInfos).equals(info.myBranchTrackInfos)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myLocalBranches, info.myLocalBranches)) {
            return false;
        }
        return GitRepoInfo.areEqual(this.myRemoteBranches, info.myRemoteBranches);
    }

    public int hashCode() {
        int result = this.myCurrentBranch != null ? this.myCurrentBranch.hashCode() : 0;
        result = 31 * result + (this.myCurrentRevision != null ? this.myCurrentRevision.hashCode() : 0);
        result = 31 * result + this.myState.hashCode();
        result = 31 * result + ((Object)this.myRemotes).hashCode();
        result = 31 * result + ((Object)this.myLocalBranches).hashCode();
        result = 31 * result + ((Object)this.myRemoteBranches).hashCode();
        result = 31 * result + ((Object)this.myBranchTrackInfos).hashCode();
        return result;
    }

    public String toString() {
        return String.format("GitRepoInfo{current=%s, remotes=%s, localBranches=%s, remoteBranches=%s, trackInfos=%s}", this.myCurrentBranch, this.myRemotes, this.myLocalBranches, this.myRemoteBranches, this.myBranchTrackInfos);
    }

    private static <T extends GitBranch> boolean areEqual(Collection<T> c1, Collection<T> c2) {
        THashSet set1 = new THashSet(c1, (TObjectHashingStrategy)new BranchesComparingStrategy());
        THashSet set2 = new THashSet(c2, (TObjectHashingStrategy)new BranchesComparingStrategy());
        return set1.equals((Object)set2);
    }

    private static class BranchesComparingStrategy
    implements TObjectHashingStrategy<GitBranch> {
        private BranchesComparingStrategy() {
        }

        public int computeHashCode(@NotNull GitBranch branch) {
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "computeHashCode"));
            }
            return 31 * branch.getName().hashCode() + branch.getHash().hashCode();
        }

        public boolean equals(@NotNull GitBranch b1, @NotNull GitBranch b2) {
            if (b1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "equals"));
            }
            if (b2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/repo/GitRepoInfo$BranchesComparingStrategy", "equals"));
            }
            if (b1 == b2) {
                return true;
            }
            if (b1.getClass() != b2.getClass()) {
                return false;
            }
            return b1.getName().equals(b2.getName()) && b1.getHash().equals(b2.getHash());
        }
    }
}

