/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class GitSimplePushResult {
    private final Type myType;
    private final String myErrorOutput;
    private final Collection<String> myRejectedBranches;

    private GitSimplePushResult(@NotNull Type type, @NotNull String errorOutput, @NotNull Collection<String> rejectedBranches) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitSimplePushResult", "<init>"));
        }
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitSimplePushResult", "<init>"));
        }
        if (rejectedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitSimplePushResult", "<init>"));
        }
        this.myType = type;
        this.myErrorOutput = errorOutput;
        this.myRejectedBranches = rejectedBranches;
    }

    @NotNull
    public static GitSimplePushResult success() {
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.SUCCESS, "", Collections.<String>emptyList());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "success"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static GitSimplePushResult notPushed() {
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.NOT_PUSHED, "", Collections.<String>emptyList());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "notPushed"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static GitSimplePushResult cancel() {
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.CANCEL, "Cancelled by user", Collections.<String>emptyList());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "cancel"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static GitSimplePushResult notAuthorized() {
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.NOT_AUTHORIZED, "Couldn't authorize", Collections.<String>emptyList());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "notAuthorized"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static GitSimplePushResult reject(@NotNull Collection<String> rejectedBranches) {
        if (rejectedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitSimplePushResult", "reject"));
        }
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.REJECT, "", rejectedBranches);
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "reject"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public static GitSimplePushResult error(@NotNull String errorOutput) {
        if (errorOutput == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitSimplePushResult", "error"));
        }
        GitSimplePushResult gitSimplePushResult = new GitSimplePushResult(Type.ERROR, errorOutput, Collections.<String>emptyList());
        if (gitSimplePushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "error"));
        }
        return gitSimplePushResult;
    }

    @NotNull
    public String getOutput() {
        String string = this.myErrorOutput;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "getOutput"));
        }
        return string;
    }

    @NotNull
    public Collection<String> getRejectedBranches() {
        Collection<String> collection = this.myRejectedBranches;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "getRejectedBranches"));
        }
        return collection;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitSimplePushResult", "getType"));
        }
        return type;
    }

    public static enum Type {
        NOT_PUSHED,
        SUCCESS,
        REJECT,
        CANCEL,
        NOT_AUTHORIZED,
        ERROR;

    }
}

