/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPusher;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRejectedPushUpdateDialog
extends DialogWrapper {
    static final int MERGE_EXIT_CODE = 2;
    static final int REBASE_EXIT_CODE = 3;
    private static final String HTML_IDENT = "&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String DESCRIPTION_START = "<html>Push of current branch ";
    public static final String DESCRIPTION_ENDING = "Remote changes need to be merged before pushing.<br/>To push anyway you can merge or rebase now.</html>";
    private final Project myProject;
    private final Collection<GitRepository> myRepositories;
    private final JCheckBox myUpdateAllRoots;
    private final RebaseAction myRebaseAction;
    private final MergeAction myMergeAction;
    private final JCheckBox myAutoUpdateInFuture;

    protected GitRejectedPushUpdateDialog(@NotNull Project project, @NotNull Collection<GitRepository> repositories, @NotNull GitPusher.UpdateSettings initialSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitRejectedPushUpdateDialog", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitRejectedPushUpdateDialog", "<init>"));
        }
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitRejectedPushUpdateDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myRepositories = repositories;
        this.myUpdateAllRoots = new JCheckBox("Update not rejected repositories as well", initialSettings.shouldUpdateAllRoots());
        this.myUpdateAllRoots.setMnemonic('u');
        this.myAutoUpdateInFuture = new JCheckBox("<html>Remember the update method choice and <u>s</u>ilently update in future <br/>(you may change this in the Settings)</html>");
        this.myAutoUpdateInFuture.setMnemonic('s');
        this.myMergeAction = new MergeAction(this);
        this.myRebaseAction = new RebaseAction(this);
        this.getDefaultAction(initialSettings.getUpdateMethod()).putValue("DefaultAction", Boolean.TRUE);
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
        this.setTitle("Push Rejected");
    }

    private AbstractAction getDefaultAction(@Nullable UpdateMethod updateMethod) {
        if (updateMethod == UpdateMethod.REBASE) {
            return this.myRebaseAction;
        }
        return this.myMergeAction;
    }

    protected JComponent createCenterPanel() {
        JBLabel desc = new JBLabel(this.makeDescription());
        JPanel options = new JPanel(new BorderLayout());
        options.add((Component)this.myAutoUpdateInFuture, "South");
        if (!GitUtil.justOneGitRepository(this.myProject)) {
            options.add(this.myUpdateAllRoots);
        }
        int GAP = 15;
        JPanel rootPanel = new JPanel(new BorderLayout(15, 15));
        rootPanel.add((Component)desc);
        rootPanel.add((Component)options, "South");
        JLabel iconLabel = new JLabel(UIUtil.getQuestionIcon());
        rootPanel.add((Component)iconLabel, "West");
        return rootPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.UpdateOnRejectedPushDialog";
    }

    private String makeDescription() {
        if (GitUtil.justOneGitRepository(this.myProject)) {
            assert (!this.myRepositories.isEmpty()) : "repositories are empty";
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " was rejected. <br/>" + DESCRIPTION_ENDING;
        }
        if (this.myRepositories.size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " in repository <br/>" + GitUIUtil.code(repository.getPresentableUrl()) + " was rejected. <br/>" + DESCRIPTION_ENDING;
        }
        Map<GitRepository, GitBranch> currentBranches = this.getCurrentBranches();
        if (GitRejectedPushUpdateDialog.allBranchesHaveTheSameName(currentBranches)) {
            String branchName = currentBranches.values().iterator().next().getName();
            StringBuilder sb = new StringBuilder(DESCRIPTION_START + GitUIUtil.code(branchName) + " was rejected in repositories <br/>");
            for (GitRepository repository : RepositoryUtil.sortRepositories(currentBranches.keySet())) {
                sb.append(HTML_IDENT).append(GitUIUtil.code(repository.getPresentableUrl())).append("<br/>");
            }
            sb.append(DESCRIPTION_ENDING);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder("<html>Push of current branch was rejected: <br/>");
        for (Map.Entry<GitRepository, GitBranch> entry : currentBranches.entrySet()) {
            GitRepository repository = entry.getKey();
            GitBranch currentBranch = entry.getValue();
            sb.append(HTML_IDENT + GitUIUtil.code(currentBranch.getName()) + " in " + GitUIUtil.code(repository.getPresentableUrl()) + "<br/>");
        }
        sb.append(DESCRIPTION_ENDING);
        return sb.toString();
    }

    private static boolean allBranchesHaveTheSameName(@NotNull Map<GitRepository, GitBranch> branches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitRejectedPushUpdateDialog", "allBranchesHaveTheSameName"));
        }
        String name = null;
        for (GitBranch branch : branches.values()) {
            if (name == null) {
                name = branch.getName();
                continue;
            }
            if (name.equals(branch.getName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<GitRepository, GitBranch> getCurrentBranches() {
        HashMap<GitRepository, GitBranch> currentBranches = new HashMap<GitRepository, GitBranch>();
        for (GitRepository repository : this.myRepositories) {
            currentBranches.put(repository, GitRejectedPushUpdateDialog.getCurrentBranch(repository));
        }
        HashMap<GitRepository, GitBranch> hashMap = currentBranches;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitRejectedPushUpdateDialog", "getCurrentBranches"));
        }
        return hashMap;
    }

    @NotNull
    private static GitBranch getCurrentBranch(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        assert (currentBranch != null) : "Current branch can't be null here. " + repository;
        GitLocalBranch gitLocalBranch = currentBranch;
        if (gitLocalBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitRejectedPushUpdateDialog", "getCurrentBranch"));
        }
        return gitLocalBranch;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.myMergeAction, this.myRebaseAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitRejectedPushUpdateDialog", "createActions"));
        }
        return actionArray;
    }

    boolean shouldUpdateAll() {
        return this.myUpdateAllRoots.isSelected();
    }

    boolean shouldAutoUpdateInFuture() {
        return this.myAutoUpdateInFuture.isSelected();
    }

    private static class RebaseAction
    extends AbstractAction {
        private final DialogWrapper myDialog;

        RebaseAction(DialogWrapper dialog) {
            super("&Rebase");
            this.myDialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDialog.close(3);
        }
    }

    private static class MergeAction
    extends AbstractAction {
        private final DialogWrapper myDialog;

        MergeAction(DialogWrapper dialog) {
            super("&Merge");
            this.myDialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDialog.close(2);
        }
    }
}

