/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.push.GitCommitsByBranch;
import git4idea.push.GitCommitsByRepoAndBranch;
import git4idea.push.GitPushBranchInfo;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class GitPushLog
extends JPanel
implements TypeSafeDataProvider {
    private final Project myProject;
    private final Collection<GitRepository> myAllRepositories;
    private final ChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final DefaultTreeModel myTreeModel;
    private final CheckedTreeNode myRootNode;
    private final ReentrantReadWriteLock TREE_CONSTRUCTION_LOCK;
    private boolean myTreeWasConstructed;
    private final MyTreeCellRenderer myTreeCellRenderer;

    GitPushLog(@NotNull Project project, @NotNull Collection<GitRepository> repositories, final @NotNull Consumer<Boolean> checkboxListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushLog", "<init>"));
        }
        if (checkboxListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushLog", "<init>"));
        }
        this.TREE_CONSTRUCTION_LOCK = new ReentrantReadWriteLock();
        this.myProject = project;
        this.myAllRepositories = repositories;
        this.myRootNode = new CheckedTreeNode(null);
        this.myRootNode.add((MutableTreeNode)new DefaultMutableTreeNode(new FakeCommit()));
        this.myTreeModel = new DefaultTreeModel((TreeNode)this.myRootNode);
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, this.myRootNode){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                Object userObject = node.getUserObject();
                if (userObject instanceof GitRepository) {
                    checkboxListener.consume((Object)node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path = GitPushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (node == null || !(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
                if (userObject instanceof GitCommit) {
                    GitCommit commit = (GitCommit)((Object)userObject);
                    return GitPushLog.getHashString(commit) + "  " + GitPushLog.getDateString(commit) + "  by " + commit.getAuthor().getName() + "\n\n" + IssueLinkHtmlRenderer.formatTextWithLinks((Project)GitPushLog.this.myProject, (String)commit.getFullMessage());
                }
                return "";
            }
        };
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object nodeInfo;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GitPushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && (nodeInfo = node.getUserObject()) instanceof GitCommit) {
                    GitPushLog.this.myChangesBrowser.getViewer().setEmptyText("No differences");
                    GitPushLog.this.myChangesBrowser.setChangesToDisplay(new ArrayList(((GitCommit)((Object)nodeInfo)).getChanges()));
                    return;
                }
                GitPushLog.this.setDefaultEmptyText();
                GitPushLog.this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myChangesBrowser = new ChangesBrowser(project, null, Collections.emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)this.myTree);
        this.setDefaultEmptyText();
        Splitter splitter = new Splitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter);
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
    }

    public void calcData(DataKey key, DataSink sink) {
        if (VcsDataKeys.CHANGES.equals(key)) {
            DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
            if (selectedNodes.length == 0) {
                return;
            }
            Object object = selectedNodes[0].getUserObject();
            if (object instanceof GitCommit) {
                sink.put(key, (Object)ArrayUtil.toObjectArray((Collection)((GitCommit)((Object)object)).getChanges(), Change.class));
            }
        }
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushLog", "getPreferredFocusComponent"));
        }
        return checkboxTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCommits(@NotNull GitCommitsByRepoAndBranch commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "setCommits"));
        }
        try {
            this.TREE_CONSTRUCTION_LOCK.writeLock().lock();
            this.myRootNode.removeAllChildren();
            this.createNodes(commits);
            this.myTreeModel.nodeStructureChanged((TreeNode)this.myRootNode);
            this.myTree.setModel((TreeModel)this.myTreeModel);
            TreeUtil.expandAll((JTree)this.myTree);
            this.selectFirstCommit();
            this.collapseEmptyRepoNodes(commits);
            this.myTreeWasConstructed = true;
        }
        finally {
            this.TREE_CONSTRUCTION_LOCK.writeLock().unlock();
        }
    }

    private void selectFirstCommit() {
        DefaultMutableTreeNode firstLeaf = this.myRootNode.getFirstLeaf();
        if (firstLeaf == null) {
            return;
        }
        Enumeration enumeration = this.myRootNode.depthFirstEnumeration();
        DefaultMutableTreeNode node = null;
        while (!(!enumeration.hasMoreElements() || (node = (DefaultMutableTreeNode)enumeration.nextElement()).isLeaf() && node.getUserObject() instanceof GitCommit)) {
        }
        if (node == null) {
            node = firstLeaf;
        }
        this.myTree.setSelectionPath(new TreePath(node.getPath()));
    }

    private void collapseEmptyRepoNodes(GitCommitsByRepoAndBranch commits) {
        Enumeration enumeration = this.myRootNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = node.getUserObject();
            if (userObject == null) continue;
            if (userObject instanceof GitRepository) {
                if (!commits.get((GitRepository)userObject).isEmpty()) continue;
                this.myTree.collapsePath(new TreePath(node.getPath()));
                continue;
            }
            return;
        }
    }

    private void createNodes(@NotNull GitCommitsByRepoAndBranch commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "createNodes"));
        }
        for (GitRepository repository : GitPushLog.sortRepositories(commits)) {
            GitCommitsByBranch commitsByBranch = commits.get(repository);
            this.createRepoNode(repository, commitsByBranch, (DefaultMutableTreeNode)this.myRootNode);
        }
    }

    @NotNull
    private static List<GitRepository> sortRepositories(final @NotNull GitCommitsByRepoAndBranch commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "sortRepositories"));
        }
        ArrayList<GitRepository> repos = new ArrayList<GitRepository>(commits.getRepositories());
        Collections.sort(repos, new Comparator<GitRepository>(){

            @Override
            public int compare(GitRepository r1, GitRepository r2) {
                if (commits.get(r1).isEmpty() && !commits.get(r2).isEmpty()) {
                    return 1;
                }
                if (commits.get(r2).isEmpty() && !commits.get(r1).isEmpty()) {
                    return -1;
                }
                return r1.getPresentableUrl().compareTo(r2.getPresentableUrl());
            }
        });
        ArrayList<GitRepository> arrayList = repos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushLog", "sortRepositories"));
        }
        return arrayList;
    }

    private void createRepoNode(@NotNull GitRepository repository, @NotNull GitCommitsByBranch commitsByBranch, @NotNull DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode parentNode;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "createRepoNode"));
        }
        if (commitsByBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushLog", "createRepoNode"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/push/GitPushLog", "createRepoNode"));
        }
        if (GitUtil.justOneGitRepository(this.myProject)) {
            parentNode = rootNode;
        } else {
            parentNode = new CheckedTreeNode((Object)repository);
            if (commitsByBranch.isEmpty()) {
                ((CheckedTreeNode)parentNode).setChecked(false);
            }
            rootNode.add(parentNode);
        }
        for (GitBranch branch : GitPushLog.sortBranches(commitsByBranch.getBranches())) {
            DefaultMutableTreeNode branchNode = GitPushLog.createBranchNode(branch, commitsByBranch.get(branch));
            parentNode.add(branchNode);
        }
    }

    private static List<GitBranch> sortBranches(@NotNull Collection<GitBranch> branches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "sortBranches"));
        }
        ArrayList<GitBranch> sortedBranches = new ArrayList<GitBranch>(branches);
        Collections.sort(sortedBranches, new Comparator<GitBranch>(){

            @Override
            public int compare(GitBranch o1, GitBranch o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedBranches;
    }

    private static DefaultMutableTreeNode createBranchNode(@NotNull GitBranch branch, @NotNull GitPushBranchInfo branchInfo) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "createBranchNode"));
        }
        if (branchInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitPushLog", "createBranchNode"));
        }
        DefaultMutableTreeNode branchNode = new DefaultMutableTreeNode(branchInfo);
        for (GitCommit commit : branchInfo.getCommits()) {
            branchNode.add(new DefaultMutableTreeNode((Object)commit));
        }
        if (branchInfo.isNewBranchCreated()) {
            branchNode.add(new DefaultMutableTreeNode(new MoreCommitsToShow()));
        }
        return branchNode;
    }

    void displayError(String message) {
        DefaultMutableTreeNode titleNode = new DefaultMutableTreeNode("Error: couldn't collect commits to be pushed");
        DefaultMutableTreeNode detailNode = new DefaultMutableTreeNode(message);
        this.myRootNode.add((MutableTreeNode)titleNode);
        this.myRootNode.add((MutableTreeNode)detailNode);
        this.myTreeModel.reload((TreeNode)this.myRootNode);
        TreeUtil.expandAll((JTree)this.myTree);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<GitRepository> getSelectedRepositories() {
        if (this.myAllRepositories.size() == 1) {
            return this.myAllRepositories;
        }
        try {
            this.TREE_CONSTRUCTION_LOCK.readLock().lock();
            if (!this.myTreeWasConstructed) {
                Collection<GitRepository> collection = this.myAllRepositories;
                return collection;
            }
            ArrayList<GitRepository> selectedRepositories = new ArrayList<GitRepository>(this.myAllRepositories.size());
            if (this.myRootNode.getChildCount() == 0) {
                Collection<GitRepository> collection = this.myAllRepositories;
                return collection;
            }
            for (int i = 0; i < this.myRootNode.getChildCount(); ++i) {
                CheckedTreeNode node;
                TreeNode child = this.myRootNode.getChildAt(i);
                if (!(child instanceof CheckedTreeNode) || !(node = (CheckedTreeNode)child).isChecked() || !(node.getUserObject() instanceof GitRepository)) continue;
                selectedRepositories.add((GitRepository)node.getUserObject());
            }
            ArrayList<GitRepository> arrayList = selectedRepositories;
            return arrayList;
        }
        finally {
            this.TREE_CONSTRUCTION_LOCK.readLock().unlock();
        }
    }

    @NotNull
    private static String getDateString(@NotNull GitCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "getDateString"));
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTime()) + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushLog", "getDateString"));
        }
        return string;
    }

    @NotNull
    private static String getHashString(@NotNull GitCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushLog", "getHashString"));
        }
        String string = GitUtil.getShortHash(commit.getHash().toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushLog", "getHashString"));
        }
        return string;
    }

    private static class MoreCommitsToShow {
        private MoreCommitsToShow() {
        }
    }

    private static class FakeCommit {
        private FakeCommit() {
        }
    }

    private static class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (value instanceof CheckedTreeNode) {
                userObject = ((CheckedTreeNode)value).getUserObject();
            } else if (value instanceof DefaultMutableTreeNode) {
                userObject = ((DefaultMutableTreeNode)value).getUserObject();
            } else {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (userObject instanceof GitCommit) {
                GitCommit commit = (GitCommit)((Object)userObject);
                renderer.append(commit.getSubject(), new SimpleTextAttributes(128, this.getTextRenderer().getForeground()));
                renderer.setToolTipText(GitPushLog.getHashString(commit) + " " + GitPushLog.getDateString(commit));
            } else if (userObject instanceof GitRepository) {
                String repositoryPath = DvcsUtil.getShortRepositoryName((Repository)((GitRepository)userObject));
                renderer.append(repositoryPath, SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (userObject instanceof GitPushBranchInfo) {
                GitPushBranchInfo branchInfo = (GitPushBranchInfo)userObject;
                GitLocalBranch fromBranch = branchInfo.getSourceBranch();
                GitRemoteBranch dest = branchInfo.getDestBranch();
                GitPushBranchInfo.Type type = branchInfo.getType();
                String showingRecentCommits = ", showing 5 recent commits";
                String text = fromBranch.getName();
                SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                String additionalText = "";
                switch (type) {
                    case STANDARD: {
                        text = text + " -> " + dest.getName();
                        if (!branchInfo.getCommits().isEmpty()) break;
                        additionalText = " nothing to push";
                        break;
                    }
                    case NEW_BRANCH: {
                        text = text + " -> +" + dest.getName();
                        attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        additionalText = " new branch will be created, showing 5 recent commits";
                        break;
                    }
                    case NO_TRACKED_OR_TARGET: {
                        attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        additionalText = " no tracked branch. Use checkbox below to push branch to manually specified, showing 5 recent commits";
                    }
                }
                renderer.append(text, attrs);
                renderer.append(additionalText, new SimpleTextAttributes(128, UIUtil.getInactiveTextColor()));
            } else if (userObject instanceof FakeCommit) {
                int spaces = 54;
                String s = String.format("%" + spaces + "s", " ");
                renderer.append(s, new SimpleTextAttributes(0, renderer.getBackground()));
            } else if (userObject instanceof MoreCommitsToShow) {
                renderer.append("...");
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }
}

