/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitCommitsByRepoAndBranch;
import git4idea.push.GitManualPushToBranch;
import git4idea.push.GitPushInfo;
import git4idea.push.GitPushLog;
import git4idea.push.GitPushSpec;
import git4idea.push.GitPusher;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitPushDialog.class);
    private static final String DEFAULT_REMOTE = "origin";
    private Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final GitPusher myPusher;
    private final GitPushLog myListPanel;
    private GitCommitsByRepoAndBranch myGitCommitsToPush;
    private Map<GitRepository, GitPushSpec> myPushSpecs;
    private final Collection<GitRepository> myRepositories;
    private final JBLoadingPanel myLoadingPanel;
    private final Object COMMITS_LOADING_LOCK;
    private final GitManualPushToBranch myRefspecPanel;
    private final AtomicReference<String> myDestBranchInfoOnRefresh;
    private final boolean myPushPossible;

    public GitPushDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitPushDialog", "<init>"));
        }
        super(project);
        this.COMMITS_LOADING_LOCK = new Object();
        this.myDestBranchInfoOnRefresh = new AtomicReference();
        this.myProject = project;
        this.myPusher = new GitPusher(this.myProject, (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class), (ProgressIndicator)new EmptyProgressIndicator());
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepositories = this.getRepositoriesWithRemotes();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myListPanel = new GitPushLog(this.myProject, this.myRepositories, new RepositoryCheckboxListener());
        this.myRefspecPanel = new GitManualPushToBranch(this.myRepositories, new RefreshButtonListener());
        if (GitManualPushToBranch.getRemotesWithCommonNames(this.myRepositories).isEmpty()) {
            this.myRefspecPanel.setVisible(false);
            this.setErrorText("Can't push, because no remotes are defined");
            this.setOKActionEnabled(false);
            this.myPushPossible = false;
        } else {
            this.myPushPossible = true;
        }
        this.init();
        this.setOKButtonText("Push");
        this.setOKButtonMnemonic(80);
        this.setTitle("Git Push");
    }

    @NotNull
    private List<GitRepository> getRepositoriesWithRemotes() {
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>();
        for (GitRepository repository : this.myRepositoryManager.getRepositories()) {
            if (repository.getRemotes().isEmpty()) continue;
            repositories.add(repository);
        }
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushDialog", "getRepositoriesWithRemotes"));
        }
        return arrayList;
    }

    protected JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add(this.myRefspecPanel);
        JPanel rootPanel = new JPanel(new BorderLayout(0, 15));
        rootPanel.add((Component)this.createCommitListPanel(), "Center");
        rootPanel.add((Component)optionsPanel, "South");
        return rootPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.PushDialog";
    }

    private JComponent createCommitListPanel() {
        this.myLoadingPanel.add((Component)this.myListPanel, (Object)"Center");
        if (this.myPushPossible) {
            this.loadCommitsInBackground();
        } else {
            this.myLoadingPanel.startLoading();
            this.myLoadingPanel.stopLoading();
        }
        JPanel commitListPanel = new JPanel(new BorderLayout());
        commitListPanel.add((Component)this.myLoadingPanel, "Center");
        return commitListPanel;
    }

    private void loadCommitsInBackground() {
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final AtomicReference<String> error = new AtomicReference<String>();
                Object object = GitPushDialog.this.COMMITS_LOADING_LOCK;
                synchronized (object) {
                    error.set(GitPushDialog.this.collectInfoToPush());
                }
                final Pair remoteAndBranch = GitPushDialog.this.getRemoteAndTrackedBranchForCurrentBranch();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (error.get() != null) {
                            GitPushDialog.this.myListPanel.displayError((String)error.get());
                        } else {
                            GitPushDialog.this.myListPanel.setCommits(GitPushDialog.this.myGitCommitsToPush);
                        }
                        if (!GitPushDialog.this.myRefspecPanel.turnedOn()) {
                            GitPushDialog.this.myRefspecPanel.selectRemote((String)remoteAndBranch.getFirst());
                            GitPushDialog.this.myRefspecPanel.setBranchToPushIfNotSet((String)remoteAndBranch.getSecond());
                        }
                        GitPushDialog.this.myLoadingPanel.stopLoading();
                    }
                });
            }
        });
    }

    @NotNull
    private Pair<String, String> getRemoteAndTrackedBranchForCurrentBranch() {
        Collection<GitRepository> repositories;
        if (this.myGitCommitsToPush != null && !(repositories = this.myGitCommitsToPush.getRepositories()).isEmpty()) {
            String remoteName;
            GitRepository repository = repositories.iterator().next();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            if (this.myGitCommitsToPush.get(repository).get(currentBranch).getDestBranch() == GitPusher.NO_TARGET_BRANCH) {
                Pair pair = Pair.create((Object)DEFAULT_REMOTE, (Object)currentBranch.getName());
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushDialog", "getRemoteAndTrackedBranchForCurrentBranch"));
                }
                return pair;
            }
            try {
                remoteName = GitBranchUtil.getTrackedRemoteName(this.myProject, repository.getRoot(), currentBranch.getName());
                if (remoteName == null) {
                    remoteName = DEFAULT_REMOTE;
                }
            }
            catch (VcsException e) {
                LOG.info("Couldn't retrieve tracked branch for current branch " + currentBranch, (Throwable)e);
                remoteName = DEFAULT_REMOTE;
            }
            String targetBranch = this.myGitCommitsToPush.get(repository).get(currentBranch).getDestBranch().getNameForRemoteOperations();
            Pair pair = Pair.create((Object)remoteName, (Object)targetBranch);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushDialog", "getRemoteAndTrackedBranchForCurrentBranch"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)DEFAULT_REMOTE, (Object)"");
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushDialog", "getRemoteAndTrackedBranchForCurrentBranch"));
        }
        return pair;
    }

    @Nullable
    private String collectInfoToPush() {
        try {
            LOG.info("collectInfoToPush...");
            this.myPushSpecs = this.pushSpecsForCurrentOrEnteredBranches();
            this.myGitCommitsToPush = this.myPusher.collectCommitsToPush(this.myPushSpecs);
            LOG.info(String.format("collectInfoToPush | Collected commits to push. Push spec: %s, commits: %s", this.myPushSpecs, GitPushDialog.logMessageForCommits(this.myGitCommitsToPush)));
            return null;
        }
        catch (VcsException e) {
            this.myGitCommitsToPush = GitCommitsByRepoAndBranch.empty();
            LOG.error("collectInfoToPush | Couldn't collect commits to push. Push spec: " + this.myPushSpecs, (Throwable)e);
            return e.getMessage();
        }
    }

    private static String logMessageForCommits(GitCommitsByRepoAndBranch commitsToPush) {
        StringBuilder logMessage = new StringBuilder();
        for (GitCommit commit : commitsToPush.getAllCommits()) {
            logMessage.append(GitUtil.getShortHash(commit.getHash().toString()));
        }
        return logMessage.toString();
    }

    private Map<GitRepository, GitPushSpec> pushSpecsForCurrentOrEnteredBranches() throws VcsException {
        HashMap<GitRepository, GitPushSpec> defaultSpecs = new HashMap<GitRepository, GitPushSpec>();
        for (GitRepository repository : this.myRepositories) {
            Pair<GitRemote, GitRemoteBranch> remoteAndBranch;
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            if (currentBranch == null) continue;
            String remoteName = GitBranchUtil.getTrackedRemoteName(repository.getProject(), repository.getRoot(), currentBranch.getName());
            String trackedBranchName = GitBranchUtil.getTrackedBranchName(repository.getProject(), repository.getRoot(), currentBranch.getName());
            GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
            GitRemoteBranch targetBranch = remote != null && trackedBranchName != null ? GitBranchUtil.findRemoteBranchByName(trackedBranchName, remote.getName(), repository.getBranches().getRemoteBranches()) : ((remoteAndBranch = GitUtil.findMatchingRemoteBranch(repository, currentBranch)) == null ? GitPusher.NO_TARGET_BRANCH : (GitRemoteBranch)remoteAndBranch.getSecond());
            if (this.myRefspecPanel.turnedOn()) {
                String manualBranchName = this.myRefspecPanel.getBranchToPush();
                GitRemoteBranch manualBranch = GitBranchUtil.findRemoteBranchByName(manualBranchName, (remote = this.myRefspecPanel.getSelectedRemote()).getName(), repository.getBranches().getRemoteBranches());
                if (manualBranch == null) {
                    manualBranch = new GitStandardRemoteBranch(remote, manualBranchName, GitBranch.DUMMY_HASH);
                }
                targetBranch = manualBranch;
            }
            GitPushSpec pushSpec = new GitPushSpec(currentBranch, targetBranch == null ? GitPusher.NO_TARGET_BRANCH : targetBranch);
            defaultSpecs.put(repository, pushSpec);
        }
        return defaultSpecs;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitPushDialog.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public GitPushInfo getPushInfo() {
        GitCommitsByRepoAndBranch selectedCommits;
        LOG.info("getPushInfo start");
        Object object = this.COMMITS_LOADING_LOCK;
        // MONITORENTER : object
        if (this.myGitCommitsToPush == null) {
            LOG.info("getPushInfo | myGitCommitsToPush == null. collecting...");
            this.collectInfoToPush();
            selectedCommits = this.myGitCommitsToPush;
        } else {
            if (this.refreshNeeded()) {
                LOG.info("getPushInfo | refresh is needed, collecting...");
                this.collectInfoToPush();
            }
            Collection<GitRepository> selectedRepositories = this.myListPanel.getSelectedRepositories();
            selectedCommits = this.myGitCommitsToPush.retainAll(selectedRepositories);
        }
        LOG.info("getPushInfo | selectedCommits: " + GitPushDialog.logMessageForCommits(selectedCommits));
        GitPushInfo gitPushInfo = new GitPushInfo(selectedCommits, this.myPushSpecs);
        // MONITOREXIT : object
        if (gitPushInfo != null) return gitPushInfo;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushDialog", "getPushInfo"));
    }

    private boolean refreshNeeded() {
        String currentDestBranchValue = this.myRefspecPanel.turnedOn() ? this.myRefspecPanel.getBranchToPush() : null;
        String savedValue = this.myDestBranchInfoOnRefresh.get();
        if (savedValue == null) {
            return currentDestBranchValue != null;
        }
        return !savedValue.equals(currentDestBranchValue);
    }

    private class RefreshButtonListener
    implements Runnable {
        private RefreshButtonListener() {
        }

        @Override
        public void run() {
            GitPushDialog.this.myDestBranchInfoOnRefresh.set(GitPushDialog.this.myRefspecPanel.turnedOn() ? GitPushDialog.this.myRefspecPanel.getBranchToPush() : null);
            GitPushDialog.this.loadCommitsInBackground();
        }
    }

    private class RepositoryCheckboxListener
    implements Consumer<Boolean> {
        private RepositoryCheckboxListener() {
        }

        public void consume(Boolean checked) {
            if (checked.booleanValue()) {
                GitPushDialog.this.setOKActionEnabled(true);
            } else {
                Collection<GitRepository> repositories = GitPushDialog.this.myListPanel.getSelectedRepositories();
                if (repositories.isEmpty()) {
                    GitPushDialog.this.setOKActionEnabled(false);
                } else {
                    GitPushDialog.this.setOKActionEnabled(true);
                }
            }
        }
    }
}

