/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitPushBranchResult {
    private final Type myType;
    private final int myNumberOfPushedCommits;
    private final String myTargetBranchName;

    private GitPushBranchResult(Type type, int numberOfPushedCommits, @Nullable String targetBranchName) {
        this.myType = type;
        this.myNumberOfPushedCommits = numberOfPushedCommits;
        this.myTargetBranchName = targetBranchName;
    }

    static GitPushBranchResult success(int numberOfPushedCommits) {
        return new GitPushBranchResult(Type.SUCCESS, numberOfPushedCommits, null);
    }

    static GitPushBranchResult newBranch(String targetBranchName) {
        return new GitPushBranchResult(Type.NEW_BRANCH, 0, targetBranchName);
    }

    static GitPushBranchResult rejected() {
        return new GitPushBranchResult(Type.REJECTED, 0, null);
    }

    static GitPushBranchResult error() {
        return new GitPushBranchResult(Type.ERROR, 0, null);
    }

    int getNumberOfPushedCommits() {
        return this.myNumberOfPushedCommits;
    }

    boolean isSuccess() {
        return this.myType == Type.SUCCESS;
    }

    boolean isRejected() {
        return this.myType == Type.REJECTED;
    }

    boolean isError() {
        return this.myType == Type.ERROR;
    }

    boolean isNewBranch() {
        return this.myType == Type.NEW_BRANCH;
    }

    @NotNull
    String getTargetBranchName() {
        String string = this.myTargetBranchName != null ? this.myTargetBranchName : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushBranchResult", "getTargetBranchName"));
        }
        return string;
    }

    static enum Type {
        SUCCESS,
        NEW_BRANCH,
        REJECTED,
        ERROR;

    }
}

