/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class GitManualPushToBranch
extends JPanel {
    private final Collection<GitRepository> myRepositories;
    private final JCheckBox myManualPush;
    private final JTextField myDestBranchTextField;
    private final JBLabel myComment;
    private final GitPushLogRefreshAction myRefreshAction;
    private final JComponent myRefreshButton;
    private final RemoteSelector myRemoteSelector;
    private final JComponent myRemoteSelectorComponent;

    GitManualPushToBranch(@NotNull Collection<GitRepository> repositories, final @NotNull Runnable performOnRefresh) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch", "<init>"));
        }
        if (performOnRefresh == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/push/GitManualPushToBranch", "<init>"));
        }
        this.myRepositories = repositories;
        this.myManualPush = new JCheckBox("Push current branch to alternative branch: ", false);
        this.myManualPush.setMnemonic('b');
        this.myDestBranchTextField = new JTextField(20);
        this.myComment = new JBLabel("This will apply to all selected repositories", UIUtil.ComponentStyle.SMALL);
        this.myRefreshAction = new GitPushLogRefreshAction(){

            public void actionPerformed(AnActionEvent e) {
                performOnRefresh.run();
            }
        };
        this.myRefreshButton = new ActionButton((AnAction)this.myRefreshAction, this.myRefreshAction.getTemplatePresentation(), this.myRefreshAction.getTemplatePresentation().getText(), ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myRefreshButton.setFocusable(true);
        ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Refresh").getShortcutSet();
        this.myRefreshAction.registerCustomShortcutSet(shortcutSet, this.myRefreshButton);
        this.myRemoteSelector = new RemoteSelector(GitManualPushToBranch.getRemotesWithCommonNames(repositories));
        this.myRemoteSelectorComponent = this.myRemoteSelector.createComponent();
        this.setDefaultComponentsEnabledState(this.myManualPush.isSelected());
        this.myManualPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isManualPushSelected = GitManualPushToBranch.this.myManualPush.isSelected();
                GitManualPushToBranch.this.setDefaultComponentsEnabledState(isManualPushSelected);
                if (isManualPushSelected) {
                    GitManualPushToBranch.this.myDestBranchTextField.requestFocus();
                    GitManualPushToBranch.this.myDestBranchTextField.selectAll();
                }
            }
        });
        this.layoutComponents();
    }

    private void setDefaultComponentsEnabledState(boolean selected) {
        this.myDestBranchTextField.setEnabled(selected);
        this.myComment.setEnabled(selected);
        this.myRemoteSelector.setEnabled(selected);
    }

    private void layoutComponents() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBag g = new GridBag().setDefaultFill(0).setDefaultAnchor(512).setDefaultWeightX(1, 1.0).setDefaultInsets(new Insets(0, 0, 4, 5));
        panel.add((Component)this.myManualPush, g.nextLine().next());
        panel.add((Component)this.myRemoteSelectorComponent, g.next());
        panel.add((Component)this.myDestBranchTextField, g.next());
        panel.add((Component)this.myRefreshButton, g.next());
        if (this.myRepositories.size() > 1) {
            panel.add((Component)this.myComment, g.nextLine().insets(0, 28, 0, 0).coverLine());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "West");
    }

    boolean turnedOn() {
        return this.myManualPush.isSelected() && !this.myDestBranchTextField.getText().isEmpty();
    }

    @NotNull
    String getBranchToPush() {
        String string = this.myDestBranchTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch", "getBranchToPush"));
        }
        return string;
    }

    void setBranchToPushIfNotSet(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch", "setBranchToPushIfNotSet"));
        }
        if (this.myDestBranchTextField.getText().isEmpty()) {
            this.myDestBranchTextField.setText(text);
        }
    }

    @NotNull
    GitRemote getSelectedRemote() {
        GitRemote gitRemote = this.myRemoteSelector.getSelectedValue();
        if (gitRemote == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch", "getSelectedRemote"));
        }
        return gitRemote;
    }

    public void selectRemote(String remoteName) {
        this.myRemoteSelector.selectRemote(remoteName);
    }

    @NotNull
    public static Collection<GitRemote> getRemotesWithCommonNames(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch", "getRemotesWithCommonNames"));
        }
        if (repositories.isEmpty()) {
            List<GitRemote> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch", "getRemotesWithCommonNames"));
            }
            return list;
        }
        Iterator<GitRepository> iterator = repositories.iterator();
        ArrayList<GitRemote> commonRemotes = new ArrayList<GitRemote>(iterator.next().getRemotes());
        while (iterator.hasNext()) {
            GitRepository repository = iterator.next();
            Collection<String> remoteNames = GitManualPushToBranch.getRemoteNames(repository);
            Iterator commonIter = commonRemotes.iterator();
            while (commonIter.hasNext()) {
                GitRemote remote = (GitRemote)commonIter.next();
                if (remoteNames.contains(remote.getName())) continue;
                commonIter.remove();
            }
        }
        ArrayList<GitRemote> arrayList = commonRemotes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch", "getRemotesWithCommonNames"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> getRemoteNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch", "getRemoteNames"));
        }
        ArrayList<String> names = new ArrayList<String>(repository.getRemotes().size());
        for (GitRemote remote : repository.getRemotes()) {
            names.add(remote.getName());
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch", "getRemoteNames"));
        }
        return arrayList;
    }

    private static abstract class GitPushLogRefreshAction
    extends DumbAwareAction {
        GitPushLogRefreshAction() {
            super("Refresh commit list", "Refresh commit list", AllIcons.Actions.Refresh);
        }
    }

    private static class RemoteSelector {
        private final Collection<GitRemote> myRemotes;
        private JComboBox myRemoteCombobox;

        private RemoteSelector(@NotNull Collection<GitRemote> remotes) {
            if (remotes == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch$RemoteSelector", "<init>"));
            }
            this.myRemotes = remotes;
        }

        @NotNull
        JComponent createComponent() {
            this.myRemoteCombobox = new JComboBox();
            this.myRemoteCombobox.setRenderer(new RemoteCellRenderer(this.myRemoteCombobox.getRenderer()));
            for (GitRemote remote : this.myRemotes) {
                this.myRemoteCombobox.addItem(remote);
            }
            this.myRemoteCombobox.setToolTipText("Select remote");
            if (this.myRemotes.size() == 1) {
                this.myRemoteCombobox.setEnabled(false);
            }
            JComboBox jComboBox = this.myRemoteCombobox;
            if (jComboBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch$RemoteSelector", "createComponent"));
            }
            return jComboBox;
        }

        @NotNull
        GitRemote getSelectedValue() {
            GitRemote gitRemote = (GitRemote)this.myRemoteCombobox.getSelectedItem();
            if (gitRemote == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitManualPushToBranch$RemoteSelector", "getSelectedValue"));
            }
            return gitRemote;
        }

        void setEnabled(boolean selected) {
            if (this.myRemotes.size() > 1) {
                this.myRemoteCombobox.setEnabled(selected);
            }
        }

        public void selectRemote(@NotNull String remoteName) {
            if (remoteName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/push/GitManualPushToBranch$RemoteSelector", "selectRemote"));
            }
            for (GitRemote remote : this.myRemotes) {
                if (!remote.getName().equals(remoteName)) continue;
                this.myRemoteCombobox.setSelectedItem(remote);
                return;
            }
            this.myRemoteCombobox.setSelectedIndex(0);
        }

        private static class RemoteCellRenderer
        extends ListCellRendererWrapper {
            public RemoteCellRenderer(ListCellRenderer listCellRenderer) {
            }

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof GitRemote) {
                    this.setText(((GitRemote)value).getName());
                }
            }
        }
    }
}

