/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.ContentRevisionFactory;
import com.intellij.vcs.log.Hash;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GitContentRevisionFactory
extends ContentRevisionFactory {
    @NotNull
    private final Project myProject;

    private GitContentRevisionFactory(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitContentRevisionFactory", "<init>"));
        }
        this.myProject = project;
    }

    public static ContentRevisionFactory getInstance(Project project) {
        return (ContentRevisionFactory)ServiceManager.getService((Project)project, GitContentRevisionFactory.class);
    }

    @NotNull
    public ContentRevision createRevision(@NotNull VirtualFile file, @NotNull Hash hash) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        ContentRevision contentRevision = GitContentRevision.createRevision(file, (VcsRevisionNumber)new GitRevisionNumber(hash.asString()), this.myProject);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        return contentRevision;
    }

    @NotNull
    public ContentRevision createRevision(@NotNull VirtualFile root, @NotNull String path, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        ContentRevision contentRevision = GitContentRevision.createRevision((FilePath)new FilePathImpl(new File(path), false), (VcsRevisionNumber)new GitRevisionNumber(hash.asString()), this.myProject, null);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitContentRevisionFactory", "createRevision"));
        }
        return contentRevision;
    }
}

